/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.ldap;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.ldap.LDAPConnectionFactory;
import com.dataiku.dip.security.ldap.LdapCredentialsAuthenticatorAndSupplier;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.licensing.DkuLicenseEnforcementService;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSLdapCredentialsAuthenticatorAndSupplier
extends LdapCredentialsAuthenticatorAndSupplier {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");

    @Autowired
    public DSSLdapCredentialsAuthenticatorAndSupplier(LDAPConnectionFactory ldapConnectionFactory, DkuLicenseEnforcementService licenseEnforcementService, GeneralSettingsDAO generalSettingsDao, PubSubService pubSubService) {
        super(ldapConnectionFactory, licenseEnforcementService);
        this.ldapSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().ldapSettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = generalSettingsDao.getUnsafeAutoTXN();
                this.ldapSettings = generalSettings.ldapSettings;
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }
}

