/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.model;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.PerUserOAuth2Helper;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JOSEException;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JOSEObjectType;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSAlgorithm;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSHeader;
import com.dataiku.dss.shadelib.com.nimbusds.jose.JWSSigner;
import com.dataiku.dss.shadelib.com.nimbusds.jose.crypto.RSASSASigner;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.Base64;
import com.dataiku.dss.shadelib.com.nimbusds.jose.util.Base64URL;
import com.dataiku.dss.shadelib.com.nimbusds.jwt.SignedJWT;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.GrantType;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.JWTBearerGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ResponseType;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.Scope;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.TokenRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.TokenResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionDetails;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.auth.Secret;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.device.DeviceAuthorizationRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.device.DeviceAuthorizationResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.device.DeviceAuthorizationSuccessResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.device.DeviceCode;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.device.DeviceCodeGrant;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Audience;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.ClientID;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Issuer;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.JWTID;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.State;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.id.Subject;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.AccessToken;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.dataiku.dss.shadelib.com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import com.dataiku.dss.shadelib.net.minidev.json.JSONObject;
import com.dataiku.dss.shadelib.net.minidev.json.JSONStyle;
import com.dataiku.dss.shadelib.org.apache.commons.codec.binary.Hex;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

@RoutinelyUsedInExtensionCode
public class OAuth2Client {
    private static final long ACCESS_TOKEN_CACHE_MAX_VALIDITY_MINUTES = DKUApp.getParams().getLongParam("dku.oauth2.accessTokenCache.maxValidityMinutes", 1440L);
    private static final long ACCESS_TOKEN_CACHE_TOKEN_MIN_VALIDITY = DKUApp.getParams().getLongParam("dku.oauth2.accessTokenCache.minRemainingTimeS", 480L) * 1000L;
    private static final long JWT_ASSERTION_VALIDITY_IN_MS = 300000L;
    private static final Cache<String, AccessTokenResult> accessTokenCache = CacheBuilder.newBuilder().expireAfterWrite(ACCESS_TOKEN_CACHE_MAX_VALIDITY_MINUTES, TimeUnit.MINUTES).build();
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final String clientId;
    private final String clientSecret;
    private final ClientAuthenticationMethod clientAuthMethod;
    private final String scope;
    private final AccessType accessType;
    private final PromptType prompt;
    private final String privateKey;
    private final String thumbprint;
    private final URI[] resources;
    private final boolean usePkce;
    private final String audience;
    private final ProxySettings proxy;
    private final boolean snowflakeOverrideAuthorizationHeader;
    private final boolean useAccessTokenCache;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.oauth");

    private OAuth2Client(Builder builder) {
        this.authorizationEndpoint = builder.authorizationEndpoint;
        this.tokenEndpoint = builder.tokenEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.clientAuthMethod = builder.clientAuthMethod;
        this.scope = builder.scope;
        this.resources = builder.resources;
        this.usePkce = builder.usePkce;
        this.audience = builder.audience;
        this.accessType = builder.accessType;
        this.prompt = builder.prompt;
        this.privateKey = builder.privateKey;
        this.thumbprint = builder.thumbprint;
        this.snowflakeOverrideAuthorizationHeader = builder.snowflakeOverrideAuthorizationHeader;
        this.proxy = builder.proxy != null ? builder.proxy : (builder.useGlobalProxy ? ApplicationConfigurator.getProxySettings() : new ProxySettings());
        this.useAccessTokenCache = builder.useAccessTokenCache;
    }

    static String generateAStateValue() {
        return new State().getValue();
    }

    static String generatePkceCodeVerifier() {
        return new CodeVerifier().getValue();
    }

    String getAuthorizationUrl(String redirectEndpoint, String state, @Nullable String codeVerifier) throws URISyntaxException {
        AuthorizationRequest.Builder request = new AuthorizationRequest.Builder(new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), new ClientID(this.clientId)).state(new State(state)).scope(Scope.parse((String)this.scope)).redirectionURI(new URI(redirectEndpoint)).endpointURI(new URI(this.authorizationEndpoint)).resources(this.resources).codeChallenge(this.usePkce && codeVerifier != null ? new CodeVerifier(codeVerifier) : null, CodeChallengeMethod.S256);
        if (this.accessType != AccessType.NONE) {
            request = request.customParameter("access_type", new String[]{this.accessType.getLabel()});
        }
        if (this.prompt != PromptType.NONE) {
            request = request.customParameter("prompt", new String[]{this.prompt.getLabel()});
        }
        if (StringUtils.isNotBlank((String)this.audience)) {
            request = request.customParameter("audience", new String[]{this.audience});
        }
        return request.build().toURI().toString();
    }

    private TokenRequest getTokenRequest(AuthorizationGrant grant) throws URISyntaxException, DKUSecurityException {
        Scope scope = grant instanceof ClientCredentialsGrant || grant instanceof ResourceOwnerPasswordCredentialsGrant || grant instanceof JWTBearerGrant ? Scope.parse((String)this.scope) : null;
        HashMap<String, List<String>> customParams = new HashMap<String, List<String>>();
        if (StringUtils.isNotBlank((String)this.audience)) {
            customParams.put("audience", Collections.singletonList(this.audience));
        }
        if (grant instanceof DeviceCodeGrant) {
            return new TokenRequest(new URI(this.tokenEndpoint), new ClientID(this.clientId), grant);
        }
        if (StringUtils.isNotBlank((String)this.privateKey)) {
            SignedJWT jwtAssertion = this.generateClientAssertion(this.privateKey, this.thumbprint);
            PrivateKeyJWT clientAuth = new PrivateKeyJWT(jwtAssertion);
            String header = jwtAssertion.getHeader().toBase64URL().toString();
            String payload = jwtAssertion.getPayload().toBase64URL().toString();
            String unsignedJWT = header + "." + payload + ".";
            logger.debug((Object)("Unsigned JWT (header.claims.): " + unsignedJWT));
            return new TokenRequest(new URI(this.tokenEndpoint), (ClientAuthentication)clientAuth, grant, scope, (List)null, customParams);
        }
        if (StringUtils.isNotBlank((String)this.clientSecret)) {
            ClientSecretBasic clientAuth;
            if (this.clientAuthMethod == ClientAuthenticationMethod.CLIENT_SECRET_BASIC) {
                clientAuth = new ClientSecretBasic(new ClientID(this.clientId), new Secret(this.clientSecret));
            } else if (this.clientAuthMethod == ClientAuthenticationMethod.CLIENT_SECRET_POST) {
                clientAuth = new ClientSecretPost(new ClientID(this.clientId), new Secret(this.clientSecret));
            } else if (this.clientAuthMethod == ClientAuthenticationMethod.NONE) {
                clientAuth = null;
            } else {
                throw new DKUSecurityException("Unsupported client authentication method " + String.valueOf(this.clientAuthMethod));
            }
            return new TokenRequest(new URI(this.tokenEndpoint), (ClientAuthentication)clientAuth, grant, scope, (List)null, customParams);
        }
        return new TokenRequest(new URI(this.tokenEndpoint), new ClientID(this.clientId), grant, scope, (List)null, (RefreshToken)null, customParams);
    }

    private AccessTokenResponse getTokens(AuthorizationGrant grant) throws URISyntaxException, IOException, DKUSecurityException, ParseException {
        HTTPResponse httpResponse;
        HTTPRequest httpRequest = this.getTokenRequest(grant).toHTTPRequest();
        ProxyUtils.applyProxySettings((ProxySettings)this.proxy, (HTTPRequest)httpRequest);
        logger.trace(() -> "Getting tokens with authorization grant: " + JSON.json((Object)grant));
        if (this.snowflakeOverrideAuthorizationHeader) {
            httpRequest.setAuthorization("Basic " + String.valueOf(Base64.encode((String)(this.clientId + ":" + this.clientSecret))));
        }
        int timeoutMs = DKUApp.getParams().getIntParam("dku.connection.oauth.timeoutMs", Integer.valueOf(60000));
        httpRequest.setConnectTimeout(timeoutMs);
        httpRequest.setReadTimeout(timeoutMs);
        httpRequest.setAccept("application/json");
        try {
            httpResponse = httpRequest.send();
        }
        catch (IOException e) {
            throw new DKUSecurityException("Failed to acquire a OAuth2 token due to network error: " + e.getMessage(), (Throwable)e);
        }
        TokenResponse response = httpResponse.getStatusCode() == 201 ? AccessTokenResponse.parse((JSONObject)httpResponse.getBodyAsJSONObject()) : TokenResponse.parse((HTTPResponse)httpResponse);
        logger.trace(() -> "Got tokens: " + JSON.json((Object)response));
        if (!response.indicatesSuccess()) {
            TokenErrorResponse errorResponse = response.toErrorResponse();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Error response: " + JSON.json((Object)errorResponse)));
            }
            String errorCode = errorResponse.getErrorObject().getCode();
            Object errorMessage = String.format("Failed to acquire a successful OAuth2 token response because of '%s'.", errorCode);
            ConnectionCodes code = null;
            if ("invalid_grant".equals(errorCode)) {
                if (grant.getType() == GrantType.REFRESH_TOKEN) {
                    code = ConnectionCodes.ERR_CONNECTION_OAUTH2_REFRESH_TOKEN_FLOW_FAIL;
                    errorMessage = "The refresh token may be expired, revoked, or invalid.";
                } else if (grant.getType() == GrantType.AUTHORIZATION_CODE) {
                    errorMessage = "The authorization code may be invalid or expired.";
                }
            } else if ("invalid_client".equals(errorCode)) {
                errorMessage = (String)errorMessage + " Your client id or secret may be invalid.";
            }
            errorMessage = (String)errorMessage + " Token response error: " + errorResponse.toJSONObject().toJSONString(new JSONStyle(16)) + ", HTTP status: " + httpResponse.getStatusCode() + ", HTTP content: '" + httpResponse.getContent() + "'";
            throw new DKUSecurityException((String)errorMessage).withCode((InfoMessage.MessageCode)code);
        }
        return response.toSuccessResponse();
    }

    public String acquireRefreshTokenFromAuthorizationCode(String authorizationCode, String redirectEndpoint, @Nullable String codeVerifier) throws URISyntaxException, IOException, ParseException, DKUSecurityException {
        AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(new AuthorizationCode(authorizationCode), new URI(redirectEndpoint), this.usePkce && codeVerifier != null ? new CodeVerifier(codeVerifier) : null);
        AccessTokenResponse atr = this.getTokens((AuthorizationGrant)codeGrant);
        if (atr.getTokens().getRefreshToken() == null) {
            throw new DKUSecurityException("OAuth2 token request did not return a refresh token");
        }
        return atr.getTokens().getRefreshToken().getValue();
    }

    private AccessTokenResult retrieveAccessTokenFromCache(AuthCtx authCtx, String credentialsKey, boolean useOIDCIdToken) {
        AccessTokenResult accessTokenResult = null;
        if (this.useAccessTokenCache) {
            logger.debug((Object)("Looking up access token in cache for " + authCtx.getIdentifier()));
            accessTokenResult = OAuth2Client.getUsableAccessToken(this.generateAccessTokenCacheKeyForAuthorizationCodeGrantFlow(authCtx.getIdentifier(), credentialsKey, useOIDCIdToken));
        }
        return accessTokenResult;
    }

    private AccessTokenResult getAccessToken(AuthCtx authCtx, String credentialsKey, AuthorizationGrant authorizationGrant, boolean useOIDCIdToken) throws DKUSecurityException, URISyntaxException, IOException, ParseException {
        AccessTokenResult accessTokenResult;
        AccessTokenResponse accessTokenResponse = this.getTokens(authorizationGrant);
        AccessToken token = accessTokenResponse.getTokens().getAccessToken();
        RefreshToken refreshTokenUpdate = accessTokenResponse.getTokens().getRefreshToken();
        logger.debug((Object)("Successfully acquired an access token with lifetime= " + token.getLifetime() + " seconds"));
        if (useOIDCIdToken) {
            Object idToken = accessTokenResponse.getCustomParameters().get("id_token");
            if (idToken == null) {
                throw new DKUSecurityException("no id_token in access token response custom parameters");
            }
            accessTokenResult = new AccessTokenResult(idToken.toString(), token.getLifetime(), refreshTokenUpdate != null ? refreshTokenUpdate.getValue() : null, idToken.toString());
        } else {
            Object idToken = accessTokenResponse.getCustomParameters().get("id_token");
            accessTokenResult = new AccessTokenResult(token.getValue(), token.getLifetime(), refreshTokenUpdate != null ? refreshTokenUpdate.getValue() : null, idToken == null ? null : idToken.toString());
        }
        if (this.useAccessTokenCache) {
            OAuth2Client.putUsableAccessToken(this.generateAccessTokenCacheKeyForAuthorizationCodeGrantFlow(authCtx.getIdentifier(), credentialsKey, useOIDCIdToken), accessTokenResult);
        }
        return accessTokenResult;
    }

    public AccessTokenResult acquireAccessTokenResultFromRefreshToken(AuthCtx authCtx, String refreshToken, String credentialsKey, boolean useOIDCIdToken) throws URISyntaxException, IOException, DKUSecurityException, ParseException {
        AccessTokenResult accessTokenResult = this.retrieveAccessTokenFromCache(authCtx, credentialsKey, useOIDCIdToken);
        if (accessTokenResult == null) {
            RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(new RefreshToken(refreshToken));
            accessTokenResult = this.getAccessToken(authCtx, credentialsKey, (AuthorizationGrant)refreshTokenGrant, useOIDCIdToken);
            PerUserOAuth2Helper.logAsJWTWithoutSignatureOrNothing(accessTokenResult.getAccessToken(), "Access token JWT without signature: %s");
        }
        return accessTokenResult;
    }

    public AccessTokenResult acquireAccessTokenResultFromResourceOwnerPassword(AuthCtx authCtx, String userName, String password, String credentialsKey, boolean useOIDCIdToken) throws URISyntaxException, IOException, DKUSecurityException, ParseException {
        AccessTokenResult accessTokenResult = this.retrieveAccessTokenFromCache(authCtx, credentialsKey, useOIDCIdToken);
        if (accessTokenResult == null) {
            ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordGrant = new ResourceOwnerPasswordCredentialsGrant(userName, new Secret(password));
            accessTokenResult = this.getAccessToken(authCtx, credentialsKey, (AuthorizationGrant)resourceOwnerPasswordGrant, useOIDCIdToken);
            PerUserOAuth2Helper.logAsJWTWithoutSignatureOrNothing(accessTokenResult.getAccessToken(), "Access token JWT without signature: %s");
        }
        return accessTokenResult;
    }

    @NotNull
    private SignedJWT generateClientAssertion(String privateKey, String thumbprint) throws DKUSecurityException {
        RSAPrivateKey rsaPrivateKey;
        KeyFactory keyFactory;
        Subject subject = new Subject(this.clientId);
        Issuer issuer = new Issuer(this.clientId);
        Audience audience = new Audience(this.tokenEndpoint);
        Date timeNow = new Date();
        Date validityDate = new Date(new Date().getTime() + 300000L);
        HashMap other = new HashMap();
        byte[] rawKey = null;
        try {
            rawKey = Hex.decodeHex((String)thumbprint);
        }
        catch (Exception e) {
            logger.errorV("Failed to decode the private key thumbprint (%s)", new Object[]{thumbprint});
            throw new DKUSecurityException("Failed to acquire a OAuth2 token due incorrect private key thumbprint : " + e.getMessage(), (Throwable)e);
        }
        JWTAssertionDetails jwtClaims = new JWTAssertionDetails(issuer, subject, audience.toSingleAudienceList(), validityDate, (Date)null, timeNow, new JWTID(), other);
        String privateKeyPEM = privateKey.replace("-----BEGIN PRIVATE KEY-----", "").replace(System.lineSeparator(), "").replace(" ", "").replace("-----END PRIVATE KEY-----", "");
        byte[] encoded = new Base64(privateKeyPEM).decode();
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DKUSecurityException("Issue getting RSA key factory", (Throwable)e);
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        try {
            rsaPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException e) {
            logger.error((Object)"Error while processing the provided private key");
            throw new DKUSecurityException("The provided private key is invalid", (Throwable)e);
        }
        SignedJWT jwtAssertion = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).type(JOSEObjectType.JWT).keyID(thumbprint).x509CertThumbprint(Base64URL.encode((byte[])rawKey)).build(), jwtClaims.toJWTClaimsSet());
        RSASSASigner signer = new RSASSASigner((PrivateKey)rsaPrivateKey);
        try {
            jwtAssertion.sign((JWSSigner)signer);
        }
        catch (JOSEException e) {
            logger.errorV("Error while signing the assertion (%s)", new Object[]{jwtAssertion.toString()});
            throw new DKUSecurityException("Issue while signing the JWT assertion", (Throwable)e);
        }
        return jwtAssertion;
    }

    public AccessTokenResult acquireAccessTokenResultWithClientCredentialsGrant(boolean useCache) throws URISyntaxException, IOException, DKUSecurityException, ParseException {
        if (useCache) {
            AccessTokenResult accessToken = OAuth2Client.getUsableAccessToken(this.generateAccessTokenCacheKeyForClientCredentialGrantFlow());
            if (accessToken != null) {
                return accessToken;
            }
            logger.info((Object)"No usable access token found, fetching a new one");
        }
        ClientCredentialsGrant clientCredentialsGrant = new ClientCredentialsGrant();
        AccessTokenResponse atr = this.getTokens((AuthorizationGrant)clientCredentialsGrant);
        AccessToken token = atr.getTokens().getAccessToken();
        logger.debug((Object)("Successfully acquired an access token with lifetime= " + token.getLifetime() + " seconds"));
        AccessTokenResult accessTokenResult = new AccessTokenResult(token.getValue(), token.getLifetime(), null, null);
        if (useCache) {
            OAuth2Client.putUsableAccessToken(this.generateAccessTokenCacheKeyForClientCredentialGrantFlow(), accessTokenResult);
        }
        return accessTokenResult;
    }

    public String generateAccessTokenCacheKeyForClientCredentialGrantFlow() {
        String cacheKey = new StringJoiner(":").add("client_cred").add(this.tokenEndpoint).add(this.clientId).add(this.clientSecret).add(this.thumbprint).add(this.scope).toString();
        if (StringUtils.isNotBlank((String)this.clientSecret)) {
            logger.info((Object)("Using access token cache key: '" + cacheKey.replace(this.clientSecret, "[client secret]")));
        } else {
            logger.info((Object)("Using access token cache key: '" + cacheKey));
        }
        return cacheKey;
    }

    public DeviceAuthorizationSuccessResponse acquireDeviceCode() throws URISyntaxException, IOException, DKUSecurityException, ParseException {
        DeviceAuthorizationRequest deviceAuthRequest = new DeviceAuthorizationRequest(new URI(this.tokenEndpoint.replace("token", "devicecode")), new ClientID(this.clientId), new Scope(new String[]{this.scope}));
        HTTPResponse deviceAuthResponse = deviceAuthRequest.toHTTPRequest().send();
        DeviceAuthorizationResponse deviceResponse = DeviceAuthorizationResponse.parse((HTTPResponse)deviceAuthResponse);
        if (!deviceResponse.indicatesSuccess()) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_AZURE_INVALID_CONFIG, "Failed to get access token: " + deviceResponse.toErrorResponse().toJSONObject().toJSONString());
        }
        return deviceResponse.toSuccessResponse();
    }

    public AccessTokenResult acquireAccessTokenResultWithDeviceCode(DeviceCode deviceCode) throws URISyntaxException, IOException, ParseException, DKUSecurityException {
        AccessTokenResponse atr = this.getTokens((AuthorizationGrant)new DeviceCodeGrant(deviceCode));
        AccessToken token = atr.getTokens().getAccessToken();
        logger.debug((Object)("Successfully acquired an access token with lifetime= " + token.getLifetime() + " seconds"));
        PerUserOAuth2Helper.logAsJWTWithoutSignatureOrNothing(token.getValue(), "Access token JWT without signature: %s");
        String idToken = atr.getTokens() instanceof OIDCTokens ? atr.getTokens().toOIDCTokens().getIDTokenString() : "";
        PerUserOAuth2Helper.logAsJWTWithoutSignatureOrNothing(idToken, "ID token JWT without signature: %s");
        return new AccessTokenResult(token.getValue(), token.getLifetime(), atr.getTokens().getRefreshToken().getValue(), idToken);
    }

    private String generateAccessTokenCacheKeyForAuthorizationCodeGrantFlow(String userIdentifier, String refreshToken, boolean useOIDCIdToken) {
        String keyFields = new StringJoiner(":").add("auth_code").add(this.tokenEndpoint).add(this.clientId).add(this.clientSecret).add(this.thumbprint).add(this.scope).add(userIdentifier).add(refreshToken).add(Boolean.toString(useOIDCIdToken)).toString();
        return DigestUtils.md5Hex((String)keyFields);
    }

    private static synchronized AccessTokenResult getUsableAccessToken(String cacheKey) {
        AccessTokenResult accessTokenResult = (AccessTokenResult)accessTokenCache.getIfPresent((Object)cacheKey);
        if (accessTokenResult != null) {
            if (accessTokenResult.hasExpiredOrIsAboutToExpire(ACCESS_TOKEN_CACHE_TOKEN_MIN_VALIDITY)) {
                logger.debugV("Cached OAuth access token found, but it has expired or will expire too soon (expiresOn=%s, timeLeft=%s)", new Object[]{accessTokenResult.getExpiresOn(), accessTokenResult.getTimeLeft()});
                return null;
            }
            logger.debug((Object)"Valid cached OAuth access token found");
            return accessTokenResult;
        }
        return null;
    }

    private static synchronized void putUsableAccessToken(String cacheKey, AccessTokenResult accessToken) {
        accessTokenCache.put((Object)cacheKey, (Object)accessToken);
    }

    public boolean usePkce() {
        return this.usePkce;
    }

    public String getClientId() {
        return this.clientId;
    }

    public static class Builder {
        private String authorizationEndpoint;
        private String tokenEndpoint;
        private String clientId;
        private String clientSecret;
        private ClientAuthenticationMethod clientAuthMethod = ClientAuthenticationMethod.CLIENT_SECRET_BASIC;
        private String scope;
        private URI[] resources;
        private boolean usePkce = false;
        private String audience;
        private boolean snowflakeOverrideAuthorizationHeader = false;
        private boolean useGlobalProxy = false;
        private ProxySettings proxy;
        private String privateKey;
        private String thumbprint;
        private boolean useAccessTokenCache = true;
        private AccessType accessType = AccessType.NONE;
        private PromptType prompt = PromptType.NONE;

        public Builder authorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public Builder tokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public Builder certificate(String thumbprint, String privateKey) {
            this.thumbprint = thumbprint;
            this.privateKey = privateKey;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder clientAuthMethod(ClientAuthenticationMethod clientAuthMethod) {
            this.clientAuthMethod = clientAuthMethod;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder accessType(AccessType accessType) {
            this.accessType = accessType;
            return this;
        }

        public Builder prompt(PromptType prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder resources(List<String> values) throws URISyntaxException {
            if (values == null || values.isEmpty()) {
                this.resources = null;
            } else {
                ArrayList<URI> resourcesList = new ArrayList<URI>();
                for (String value : values) {
                    resourcesList.add(new URI(value));
                }
                this.resources = resourcesList.toArray(new URI[0]);
            }
            return this;
        }

        public Builder usePkce(boolean usePkce) {
            this.usePkce = usePkce;
            return this;
        }

        public Builder audience(String audience) {
            this.audience = audience;
            return this;
        }

        public Builder snowflakeOverrideAuthorizationHeader(boolean snowflakeOverrideAuthorizationHeader) {
            this.snowflakeOverrideAuthorizationHeader = snowflakeOverrideAuthorizationHeader;
            return this;
        }

        public Builder useGlobalProxy(boolean useGlobalProxy) {
            this.useGlobalProxy = useGlobalProxy;
            return this;
        }

        public Builder proxy(ProxySettings proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder useAccessTokenCache(boolean useAccessTokenCache) {
            this.useAccessTokenCache = useAccessTokenCache;
            return this;
        }

        public OAuth2Client build() throws DKUSecurityException {
            if (StringUtils.isBlank((String)this.authorizationEndpoint)) {
                throw new DKUSecurityException("Authorization endpoint cannot be blank");
            }
            if (StringUtils.isBlank((String)this.tokenEndpoint)) {
                throw new DKUSecurityException("Token endpoint cannot be blank");
            }
            if (StringUtils.isBlank((String)this.clientId)) {
                throw new DKUSecurityException("Client ID cannot be blank");
            }
            return new OAuth2Client(this);
        }
    }

    public static enum AccessType {
        OFFLINE("offline"),
        ONLINE("online"),
        NONE("");

        public static final String GET_PARAMETER = "access_type";
        private String label;

        private AccessType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static enum PromptType {
        CONSENT("consent"),
        SELECT_ACCOUNT("select_account"),
        NONE("");

        public static final String GET_PARAMETER = "prompt";
        private String label;

        private PromptType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static class AccessTokenResult {
        private final String accessToken;
        private final String idToken;
        private final long expiresIn;
        private final long expiresEpoch;
        private final transient String refreshToken;

        public AccessTokenResult(String accessToken, long expiresIn, String refreshToken, String idToken) {
            this.accessToken = accessToken;
            long expiryCap = DKUApp.getParams().getLongParam("dku.oauth2.accessTokensMaxExpiryS", 1800L);
            this.expiresIn = expiresIn <= 0L ? Math.max(expiryCap, 0L) * 1000L : (expiryCap <= 0L ? expiresIn * 1000L : Math.min(expiresIn, expiryCap) * 1000L);
            this.expiresEpoch = new Date().getTime();
            this.refreshToken = refreshToken;
            this.idToken = idToken;
        }

        private AccessTokenResult(AccessTokenResult other, String refreshToken, String idToken) {
            this.accessToken = other.accessToken;
            this.expiresIn = other.expiresIn;
            this.expiresEpoch = other.expiresEpoch;
            this.refreshToken = refreshToken;
            this.idToken = idToken;
        }

        public AccessTokenResult withUpdatedRefreshToken(String refreshToken) {
            return new AccessTokenResult(this, refreshToken, this.idToken);
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public Date getExpiresOn() {
            if (this.expiresIn > 0L) {
                return new Date(this.expiresEpoch + this.expiresIn);
            }
            return null;
        }

        public long getTimeLeft() {
            if (this.expiresIn > 0L) {
                return this.expiresEpoch + this.expiresIn - new Date().getTime();
            }
            return Long.MAX_VALUE;
        }

        public boolean hasExpiredOrIsAboutToExpire(long minimumTimeLeft) {
            return this.getTimeLeft() < minimumTimeLeft;
        }

        public SerializableAccessTokenResult asSerializable() {
            return new SerializableAccessTokenResult(this.accessToken, this.expiresIn > 0L ? this.expiresEpoch + this.expiresIn : -1L);
        }
    }

    public static interface AccessTokenCredentialConvertible {
        public SerializableAccessTokenResult toSerializableAccessTokenResult();
    }

    public static class SerializableAccessTokenResult {
        public String accessToken;
        public long expiresOn;

        public SerializableAccessTokenResult(String accessToken, long expiresOn) {
            this.accessToken = accessToken;
            this.expiresOn = expiresOn;
        }
    }
}

