/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.trust;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.trust.FingerprintComputer;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadOnlyFS;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebApp;
import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FingerprintService {
    private final Cache<RelFile, FingerprintComputer.Fingerprint> cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    private final FingerprintComputer fingerprintComputer = new FingerprintComputer(this.cache);
    private NativeFS libNativeFs;
    private final Cache<RelFile, FingerprintComputer.Fingerprint> libCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.DAYS).build();
    private final FingerprintComputer libFingerprintComputer = new FingerprintComputer(this.libCache);
    private final List<RelFile> libRoots = Lists.newArrayList();
    private static final DKULogger logger = DKULogger.getLogger(FingerprintService.class);

    @PostConstruct
    public void setupResourcesLocations() throws IOException {
        File libProjects = ApplicationConfigurator.getFile((String[])new String[]{"lib", "projects"});
        File libCodeStudio = ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio"});
        File libUser = ApplicationConfigurator.getFile((String[])new String[]{"lib", "user-data"});
        File libDir = ApplicationConfigurator.getFile((String)"lib");
        this.libNativeFs = NativeFS.from((File)libDir).build();
        for (File libSubDir : new File[]{libProjects, libCodeStudio, libUser}) {
            DKUFileUtils.mkdirs((File)libSubDir);
            this.libRoots.add(this.libNativeFs.relativize(libSubDir));
        }
    }

    public byte[] computeDirectoriesFingerprint(List<RelFile> pathsToScan) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return this.fingerprintComputer.getFingerprint((ReadOnlyFS)t, pathsToScan);
    }

    public byte[] computeDirectoryFingerprint(RelFile pathToScan) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        return this.fingerprintComputer.getFingerprint((ReadOnlyFS)t, pathToScan);
    }

    public byte[] computeResourcesDirectoryFingerprint(File pathToScan) throws IOException {
        if (!DKUFileUtils.isWithin((File)this.libNativeFs.getRoot(), (File)pathToScan)) {
            throw new IOException("No resources nativeFS for " + pathToScan.getAbsolutePath());
        }
        RelFile rf = this.libNativeFs.relativize(pathToScan);
        for (RelFile lib : this.libRoots) {
            if (!lib.isAncestorOf(rf)) continue;
            return this.libFingerprintComputer.getFingerprint((ReadOnlyFS)this.libNativeFs, Lists.newArrayList((Object[])new RelFile[]{rf}));
        }
        throw new IOException("No acceptable resource location for " + pathToScan.getAbsolutePath());
    }

    public void clearCache() {
        this.cache.invalidateAll();
    }

    public String computeWebAppFingerprint(WebApp webApp, AuthCtx authCtx) throws IOException, DKUSecurityException {
        logger.debug((Object)("Computing fingerprint of webapp " + webApp.getFullId()));
        Stopwatch sw = Stopwatch.createStarted();
        MessageDigest digester = DigestUtils.getSha256Digest();
        digester.update(webApp.fingerprintOfSensitiveSettings(authCtx));
        if (webApp.params.isLoadingPythonLibraries()) {
            digester.update(this.computePythonProjectLibrariesFingerprint(webApp.projectKey));
        }
        if (webApp.params.isLoadingRLibraries()) {
            digester.update(this.computeRProjectLibrariesFingerprint(webApp.projectKey));
        }
        digester.update(this.computeDirectoryFingerprint(new RelFile(new String[]{"projects", webApp.projectKey, "lib", "static"})));
        digester.update(this.computeResourcesDirectoryFingerprint(ApplicationConfigurator.getFile((String[])new String[]{"lib", "projects", webApp.projectKey, "static"})));
        String fingerprint = Hex.encodeHexString((byte[])digester.digest());
        logger.debug((Object)("Computed fingerprint " + fingerprint + " in " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        return fingerprint;
    }

    private byte[] computeProjectLibrariesFingerprint(String projectKey, Function<DSSGitModel.ExternalLibraries, Set<String>> pathGetterForLibType) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile projectLibrariesDir = new RelFile(new String[]{"projects", projectKey, "lib"});
        RelFile externalLibsFile = projectLibrariesDir.append(new String[]{"external-libraries.json"});
        DSSGitModel.ExternalLibraries externalLibs = (DSSGitModel.ExternalLibraries)t.readObjectDefaultUnsafe(externalLibsFile, DSSGitModel.ExternalLibraries.class);
        ArrayList<RelFile> pathsToScan = new ArrayList<RelFile>();
        for (String pathInLib : pathGetterForLibType.apply(externalLibs)) {
            RelFile rf = projectLibrariesDir.appendPath_withoutDirectoryTraversalCheck(pathInLib);
            if (rf.isChildOf(projectLibrariesDir)) {
                pathsToScan.add(rf);
                continue;
            }
            logger.warn((Object)("Ignored path in " + String.valueOf(externalLibsFile) + ": " + pathInLib));
        }
        for (String importedProjectKey : externalLibs.getNonNullLibrariesFromProjects()) {
            RelFile importedProjectLibrariesDir = new RelFile(new String[]{"projects", importedProjectKey, "lib"});
            DSSGitModel.ExternalLibraries importedProjectExternalLibs = (DSSGitModel.ExternalLibraries)t.readObjectDefaultUnsafe(importedProjectLibrariesDir.append(new String[]{"external-libraries.json"}), DSSGitModel.ExternalLibraries.class);
            for (String pathInLib : pathGetterForLibType.apply(importedProjectExternalLibs)) {
                RelFile rf = importedProjectLibrariesDir.appendPath_withoutDirectoryTraversalCheck(pathInLib);
                if (rf.isChildOf(importedProjectLibrariesDir)) {
                    pathsToScan.add(rf);
                    continue;
                }
                logger.warn((Object)("Ignored path in " + String.valueOf(externalLibsFile) + ": " + pathInLib));
            }
        }
        logger.debug((Object)("Scanned libraries: " + StringUtils.join(pathsToScan, (String)":")));
        return this.computeDirectoriesFingerprint(pathsToScan);
    }

    private byte[] computePythonProjectLibrariesFingerprint(String projectKey) throws IOException {
        return this.computeProjectLibrariesFingerprint(projectKey, externalLibraries -> externalLibraries.pythonPath);
    }

    private byte[] computeRProjectLibrariesFingerprint(String projectKey) throws IOException {
        return this.computeProjectLibrariesFingerprint(projectKey, externalLibraries -> externalLibraries.rsrcPath);
    }
}

