/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.DKUNoGitTransactionService;
import com.dataiku.dip.server.services.ProjectGitMergeRequestService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.git.GitCodes;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.MergeRequest;
import com.dataiku.dip.transactions.git.MergeRequestInfo;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionScope;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringUtils;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MergeRequestGitController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectGitMergeRequestService projectGitMergeRequestService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ProjectsJGitService projectsGitService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    private DKUNoGitTransactionService noGitTransactionService = new DKUNoGitTransactionService();

    @AuditedCall(value={"msgType", "project-git-list-branches", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/git/merge-requests/list-branches"})
    public void listAllBranches(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
        }
        MergeRequestGitController.writeJSON((HttpServletResponse)resp, this.projectsGitService.listAvailableBranchesByType_NT(projectKey, false));
    }

    @AuditedCall(value={"msgType", "merge-request-create"})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/git/merge-requests"})
    public void createMergeRequest(HttpServletRequest req, HttpServletResponse resp, final @RequestParam String projectKey, final @RequestParam MergeRequest request) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
            request.baseProject = projectKey;
            if (request.type == MergeRequest.Type.PROJECT && StringUtils.nullIfBlank((String)request.projectToMerge) != null) {
                this.projectsService.checkPerm(authCtx, request.projectToMerge, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        MergeRequestGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<Object>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected MergeRequestInfo compute() throws Exception {
                try {
                    MergeRequestInfo mergeRequest = MergeRequestGitController.this.projectGitMergeRequestService.createMergeRequest(authCtx, request, this.logTailBuilder);
                    MergeRequestGitController.this.auditTrailService.generic("merge-requests-create").with("projectKey", projectKey).with("id", (Number)mergeRequest.mergeRequest.id).with("title", mergeRequest.mergeRequest.title).with("baseBranch", mergeRequest.mergeRequest.baseBranch).with("branchToMerge", mergeRequest.mergeRequest.branchToMerge).with("projectToMerge", mergeRequest.mergeRequest.projectToMerge).with("branchToMergeType", mergeRequest.mergeRequest.branchToMergeType.toString()).emit();
                    return mergeRequest;
                }
                catch (Exception e) {
                    MergeRequestGitController.this.auditTrailService.failure("merge-requests-create", (Throwable)e).emit();
                    throw e;
                }
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"create_merge_request", (String)"Create merge request");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<Object>>(){}));
    }

    @AuditedCall(value={"msgType", "merge-request-list", "projectKey", "${projectKey}"})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/git/merge-requests"})
    public void listMergeRequests(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        resp.setStatus(HttpStatus.OK.value());
        MergeRequestGitController.writeJSON((HttpServletResponse)resp, this.projectGitMergeRequestService.getMergeRequests(projectKey).values());
    }

    @AuditedCall(value={"msgType", "merge-request-get", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/git/merge-requests/{requestId}"})
    public void getMergeRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @PathVariable int requestId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        t = this.noGitTransactionService.beginRead();
        try {
            resp.setStatus(HttpStatus.OK.value());
            MergeRequestGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectGitMergeRequestService.getMergeRequestInfo(projectKey, requestId));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "merge-request-get-info", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/git/merge-requests/{requestId}/info"})
    public void getMergeRequestInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @PathVariable int requestId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        t = this.noGitTransactionService.beginRead();
        try {
            resp.setStatus(HttpStatus.OK.value());
            MergeRequestGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectGitMergeRequestService.getMergeRequestInfo(projectKey, requestId));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "merge-request-delete", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/git/merge-requests/{requestId}"})
    public void deleteMergeRequest(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @PathVariable int requestId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        this.projectGitMergeRequestService.deleteMergeRequest(authCtx, projectKey, requestId);
        resp.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @AuditedCall(value={"msgType", "merge-request-update", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/git/merge-requests/{requestId}"})
    public void updateMergeRequest(HttpServletRequest req, HttpServletResponse resp, @PathVariable int requestId, final @RequestParam MergeRequest request, final @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        request.id = requestId;
        MergeRequestGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<Object>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected InfoMessage.InfoMessages compute() throws Exception {
                InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
                try {
                    MergeRequestGitController.this.projectGitMergeRequestService.updateMergeRequest(authCtx, projectKey, request);
                    infoMessages.withSuccess((InfoMessage.MessageCode)GitCodes.INFO_GIT_MERGE_UPDATE_OK, "Merge request updated with success");
                }
                catch (CodedException e) {
                    infoMessages.withError(e.getCode(), ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return infoMessages;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"update_merge_request", (String)"Update merge request");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<Object>>(){}));
    }

    @AuditedCall(value={"msgType", "merge-request-mark-file-as-resolved", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/git/merge-requests/{requestId}/action/markFileAsResolved"})
    public void markFileAsResolved(HttpServletRequest req, HttpServletResponse resp, @PathVariable int requestId, @RequestParam String file, @RequestParam String projectKey, @RequestParam(defaultValue="MANUAL") ResolutionStrategy resolutionStrategy) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        MergeRequest mergeRequest = this.projectGitMergeRequestService.getMergeRequest(projectKey, requestId);
        this.projectGitMergeRequestService.markFileAsResolved(authCtx, projectKey, mergeRequest, file, resolutionStrategy);
        MergeRequestGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectGitMergeRequestService.getMergeRequestInfo(projectKey, requestId));
    }

    @AuditedCall(value={"msgType", "merge-request-mark-all-files-as-resolved", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/git/merge-requests/{requestId}/action/markAllFilesAsResolved"})
    public void markFileAsResolved(HttpServletRequest req, HttpServletResponse resp, @PathVariable int requestId, @RequestParam String projectKey, @RequestParam ResolutionStrategy resolutionStrategy) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        MergeRequest mergeRequest = this.projectGitMergeRequestService.getMergeRequest(projectKey, requestId);
        this.projectGitMergeRequestService.markAllFilesAsResolved(authCtx, projectKey, mergeRequest, resolutionStrategy);
        MergeRequestGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectGitMergeRequestService.getMergeRequestInfo(projectKey, requestId));
    }

    @AuditedCall(value={"msgType", "merge-request-merge", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/git/merge-requests/{requestId}/action/merge"})
    public void merge(HttpServletRequest req, HttpServletResponse resp, final @PathVariable int requestId, final @RequestParam String projectKey) throws Exception {
        MergeRequest mergeRequest;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
            if (!authCtx.isSafeCodeAllowed()) {
                throw new UnauthorizedException("You need to be able to write code in order to merge", "safe-code-denied");
            }
        }
        t = this.noGitTransactionService.beginRead();
        try {
            mergeRequest = this.projectGitMergeRequestService.getMergeRequest(projectKey, requestId);
            if (mergeRequest.type == MergeRequest.Type.PROJECT && StringUtils.nullIfBlank((String)mergeRequest.projectToMerge) != null) {
                this.projectsService.checkPerm(authCtx, mergeRequest.projectToMerge, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        t = this.projectGitMergeRequestService.getTransactionProvider(mergeRequest).retrieveOrBeginRead();
        try (TransactionScope ts = TransactionContext.with((TransactionRef)t);){
            GitModel.MultiCommitDiff modifiedFiles = this.projectGitMergeRequestService.diffNameOnly(mergeRequest);
            this.permissionsService.checkUnsafeCodePermission(authCtx, t, modifiedFiles);
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        MergeRequestGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<InfoMessage.InfoMessages>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected InfoMessage.InfoMessages compute() throws Exception {
                InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
                try {
                    MergeRequestGitController.this.projectGitMergeRequestService.merge(authCtx, projectKey, mergeRequest, this.logTailBuilder);
                    MergeRequestGitController.this.projectGitMergeRequestService.getMergeRequestInfo(mergeRequest);
                    infoMessages.withSuccess((InfoMessage.MessageCode)GitCodes.INFO_GIT_MERGE_OK, "Merge request '" + requestId + "' merged successfully.");
                }
                catch (CodedException e) {
                    infoMessages.withError(e.getCode(), ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return infoMessages;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"merge_merge_request", (String)"Merge merge request");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){}));
    }

    @AuditedCall(value={"msgType", "merge-request-refresh-merged-branch", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/git/merge-requests/{requestId}/action/refresh-merged-branch"})
    public void refreshMergedBranch(HttpServletRequest req, HttpServletResponse resp, final @PathVariable int requestId, final @RequestParam String projectKey) throws Exception {
        MergeRequest mergeRequest;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
            if (!authCtx.isSafeCodeAllowed()) {
                throw new UnauthorizedException("You need to be able to write code in order to refresh merged branch", "safe-code-denied");
            }
        }
        t = this.noGitTransactionService.beginRead();
        try {
            mergeRequest = this.projectGitMergeRequestService.getMergeRequest(projectKey, requestId);
            if (mergeRequest.type == MergeRequest.Type.PROJECT && StringUtils.nullIfBlank((String)mergeRequest.projectToMerge) != null) {
                this.projectsService.checkPerm(authCtx, mergeRequest.projectToMerge, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        MergeRequestGitController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(new SimpleFutureThread<InfoMessage.InfoMessages>(authCtx){
            DKUtils.SmartLogTailBuilder logTailBuilder;
            {
                super(owner);
                this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            }

            @Override
            protected InfoMessage.InfoMessages compute() throws Exception {
                InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
                try {
                    MergeRequestGitController.this.projectGitMergeRequestService.refreshMergedBranch(authCtx, projectKey, mergeRequest, this.logTailBuilder);
                    infoMessages.withSuccess((InfoMessage.MessageCode)GitCodes.INFO_GIT_MERGE_REFRESH_MERGED_BRANCH_OK, "Merge request '" + requestId + "' merged branch '" + mergeRequest.branchToMerge + "' successfully refreshed.");
                }
                catch (CodedException e) {
                    infoMessages.withError(e.getCode(), ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
                return infoMessages;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"refresh_merged_branch", (String)"Refresh merged branch");
            }

            public SmartLogTail getLog() {
                return this.logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){}));
    }

    @AuditedCall(value={"msgType", "merge-request-get-file", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/git/merge-requests/{requestId}/file"})
    public void getFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @PathVariable int requestId, @RequestParam String file) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        t = this.noGitTransactionService.beginRead();
        try {
            resp.setStatus(HttpStatus.OK.value());
            MergeRequest mergeRequest = this.projectGitMergeRequestService.getMergeRequest(projectKey, requestId);
            MergeRequestGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectGitMergeRequestService.getFile(mergeRequest, file));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "merge-request-save-file", "projectKey", "${projectKey}", "requestId", "${requestId}"})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/git/merge-requests/{requestId}/file"})
    public void saveFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @PathVariable int requestId, @RequestParam String file, @RequestParam String content) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        t = this.noGitTransactionService.beginRead();
        try {
            MergeRequest mergeRequest = this.projectGitMergeRequestService.getMergeRequest(projectKey, requestId);
            this.projectGitMergeRequestService.saveFile(authCtx, mergeRequest, file, content);
            resp.setStatus(HttpStatus.OK.value());
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "merge-request-get-diff", "projectKey", "${projectKey}", "requestId", "${requestId}", "commitId", "${commitId}"})
    @RequestMapping(value={"/api/git/merge-requests/{requestId}/get-commit-diff"})
    public void getObjectLog(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @PathVariable int requestId, @RequestParam String commitId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        t = this.noGitTransactionService.beginRead();
        try {
            MergeRequestGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectGitMergeRequestService.getDiff(projectKey, requestId, commitId));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "merge-request-get-diff", "projectKey", "${projectKey}", "requestId", "${requestId}", "commitFrom", "${commitFrom}", "commitTo", "${commitTo}"})
    @RequestMapping(value={"/api/git/merge-requests/{requestId}/get-revisions-diff"})
    public void getRevisionsDiff(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @PathVariable int requestId, @RequestParam String commitFrom, @RequestParam String commitTo) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.checkPerm(authCtx, projectKey);
        }
        t = this.noGitTransactionService.beginRead();
        try {
            MergeRequestGitController.writeJSON((HttpServletResponse)resp, (Object)this.projectGitMergeRequestService.getDiff(projectKey, requestId, commitFrom, commitTo));
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    public void checkPerm(AuthCtx authCtx, String projectKey) throws DKUSecurityException {
        this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
    }

    public static enum ResolutionStrategy {
        MANUAL,
        MASTER,
        BRANCH;

    }
}

