/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers.admin;

import com.dataiku.dip.activity.ConnectionDataReportingService;
import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.activity.GlobalUsageSummaryBuilder;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AdminMonitoringController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ConnectionTasksService connectionTasksService;
    @Autowired
    private ConnectionDataReportingService dataReportingService;
    @Autowired
    private ProjectsService projectsService;
    private static final Logger logger = Logger.getLogger((String)"dku.admin.monitoringpapi.js");

    @AuditedCall(value={"msgType", "admin-get-usage-summary"})
    @RequestMapping(value={"/api/admin/monitoring/get-global-usage-summary"})
    public void getGlobalUsageSummary(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        AdminMonitoringController.writeJSON((HttpServletResponse)resp, (Object)new GlobalUsageSummaryBuilder().buildGlobalMonitoringReport());
    }

    @AuditedCall(value={"msgType", "admin-get-connection-tasks-history", "connection", "${connectionId}"})
    @RequestMapping(value={"/api/admin/monitoring/ct/get-history"})
    public void getConnectionTasksHistoryPerProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionId) throws Exception {
        long oneMonth = System.currentTimeMillis() - 2592000000L;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            AdminMonitoringController.writeJSON((HttpServletResponse)resp, (Object)this.connectionTasksService.getHistory(connectionId, oneMonth));
        }
    }

    @AuditedCall(value={"msgType", "admin-get-connection-data-info", "connection", "${connectionId}"})
    @RequestMapping(value={"/api/admin/monitoring/cd/get"})
    public void getConnectionData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        AdminMonitoringController.writeJSON((HttpServletResponse)resp, (Object)this.dataReportingService.getConnectionData_NT(connectionId));
    }

    @AuditedCall(value={"msgType", "admin-get-connection-data-info", "connection", "${connectionId}", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/admin/monitoring/cd/get-for-project"})
    public void getProjectData(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionId, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        AdminMonitoringController.writeJSON((HttpServletResponse)resp, (Object)this.dataReportingService.getConnectionProjectData_NT(connectionId, projectKey));
    }

    @AuditedCall(value={"msgType", "admin-update-connection-data-info", "connection", "${connectionId}", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/admin/monitoring/cd/update-for-project"})
    public void updateForProject(HttpServletRequest req, HttpServletResponse resp, @RequestParam String connectionId, @RequestParam String projectKey, @RequestParam boolean computeRecords, @RequestParam boolean forceRecompute) throws Exception {
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        AdminMonitoringController.writeJSON((HttpServletResponse)resp, this.dataReportingService.updateForProject(liu, connectionId, projectKey, computeRecords, forceRecompute));
    }

    @AuditedCall(value={"msgType", "admin-get-connection-data-info", "connection", "${connectionId}", "projectKey", "${projectKey}", "datasetName", "${datasetName"})
    @RequestMapping(value={"/api/admin/monitoring/cd/update-for-dataset"})
    public void updateForDataset(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String datasetName, @RequestParam boolean computeRecords, @RequestParam boolean forceRecompute) throws Exception {
        AuthCtx liu = null;
        try (Transaction t = this.transactionService.beginRead();){
            liu = this.authService.getMandatoryUser(req);
            this.authService.failIfNotAdmin(req);
        }
        AdminMonitoringController.writeJSON((HttpServletResponse)resp, this.dataReportingService.updateForDataset(liu, projectKey, datasetName, computeRecords, forceRecompute));
    }

    @AuditedCall(value={"msgType", "admin-get-projects-integrations"})
    @RequestMapping(value={"/api/admin/monitoring/get-projects-integrations"})
    public void getProjectsIntegrations(HttpServletRequest req, HttpServletResponse resp) throws IOException, DKUSecurityException {
        List<SerializedProject> projects;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        try (Transaction t = this.transactionService.beginRead();){
            projects = this.projectsService.listAll();
        }
        List projectsIntegrations = projects.stream().filter(p -> !p.settings.integrations.integrations.isEmpty()).map(p -> new ProjectIntegrationsList(p.projectKey, p.settings.integrations.integrations)).collect(Collectors.toList());
        AdminMonitoringController.writeJSON((HttpServletResponse)resp, projectsIntegrations);
    }

    @AuditedCall(value={"msgType", "admin-save-project-integration", "projectKey", "${projectKey}", "data", "${data}"})
    @RequestMapping(value={"/api/admin/monitoring/save-project-integration"})
    public void saveProjectIntegration(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        this.saveOrDeleteProjectIntegration(req, resp, projectKey, data, false, "Updated state of project integration ");
    }

    @AuditedCall(value={"msgType", "admin-delete-project-integration", "projectKey", "${projectKey}", "data", "${data}"})
    @RequestMapping(value={"/api/admin/monitoring/delete-project-integration"})
    public void deleteProjectIntegration(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        this.saveOrDeleteProjectIntegration(req, resp, projectKey, data, true, "Deleted project integration: ");
    }

    private void saveOrDeleteProjectIntegration(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data, boolean delete, String commitMessage) throws Exception {
        SerializedProject project;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            project = this.projectsService.getMandatory(projectKey);
        }
        SerializedProject.ProjectIntegration projectIntegration = (SerializedProject.ProjectIntegration)JSON.parse((String)data, SerializedProject.ProjectIntegration.class);
        SerializedProject.ProjectIntegration oldProjectIntegration = project.settings.integrations.integrations.stream().filter(i -> i.hook.equals(projectIntegration.hook)).findFirst().orElseThrow(() -> new IllegalArgumentException("Project Integration not found"));
        if (delete) {
            project.settings.integrations.integrations.remove(oldProjectIntegration);
        } else {
            oldProjectIntegration.active = projectIntegration.active;
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
            t.commit(commitMessage + projectIntegration.hook.getType());
        }
        ProjectIntegrationsList result = new ProjectIntegrationsList(projectKey, project.settings.integrations.integrations);
        AdminMonitoringController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    private static class ProjectIntegrationsList {
        String projectKey;
        List<SerializedProject.ProjectIntegration> integrations;

        ProjectIntegrationsList(String projectKey, List<SerializedProject.ProjectIntegration> integrations) {
            this.projectKey = projectKey;
            this.integrations = integrations;
        }
    }
}

