/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.cuspol.ICustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.datasets.DatasetReadAPIUtils;
import com.dataiku.dip.server.services.SQLQueryStreamService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SQLQueriesIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private SQLQueryStreamService service;
    private static Logger logger = Logger.getLogger((String)"dku.intercom.sql");

    @AuditedCall(value={"msgType", "sql-query-start", "connection", "${connection}", "dbType", "${dbType}", "query", "${query}", "preQueries", "${preQueries}", "postQueries", "${postQueries}"})
    @RequestMapping(value={"/api/tintercom/sql-queries/start-streaming"})
    public void startStreamingSQLQuery(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="connection") String connectionOrDatasetName, @RequestParam(required=false) boolean findConnectionFromDataset, @RequestParam String dbType, @RequestParam String query, @RequestParam(required=false) String preQueries, @RequestParam(required=false) String postQueries, @RequestParam(required=false) String scriptSteps, @RequestParam(required=false) String scriptInputSchema, @RequestParam(required=false) String scriptOutputSchema, @RequestParam(required=false) String scriptReportLocation, @RequestParam(required=false) String extraConf, @RequestParam(required=false) String readTimestampWithoutTimezoneAsString, @RequestParam(required=false) String readDateAsString, @RequestParam(required=false, defaultValue="AS_IS") String datetimenotzReadModeStr, @RequestParam(required=false, defaultValue="AS_IS") String dateonlyReadModeStr, @RequestParam(required=false) String projectKey) throws Exception {
        AbstractSQLConnection connection;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();
             AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);){
            authCtx = authCtxUsage.getAuthCtx();
            connection = this.service.getConnectionForStreaming(authCtx, connectionOrDatasetName, findConnectionFromDataset, dbType, this.datasetsDAO);
        }
        assert (ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.BACKEND);
        ICustomPolicyHooksRegistry cuspolRegistry = (ICustomPolicyHooksRegistry)SpringUtils.getBean(ICustomPolicyHooksRegistry.class);
        try (Transaction t = this.transactionService.beginRead();){
            cuspolRegistry.onPreSQLConnectionDirectUse(authCtx, projectKey, connection.name);
        }
        AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.valueOf(datetimenotzReadModeStr);
        AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.valueOf(dateonlyReadModeStr);
        if (StringUtils.isNotBlank((String)readTimestampWithoutTimezoneAsString)) {
            datetimenotzReadMode = "true".equalsIgnoreCase(readTimestampWithoutTimezoneAsString) ? AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING : AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
        }
        if (StringUtils.isNotBlank((String)readDateAsString)) {
            dateonlyReadMode = "true".equalsIgnoreCase(readDateAsString) ? AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING : AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
        }
        SQLQueriesIntercomController.writeJSON((HttpServletResponse)resp, (Object)this.service.startStreamingSQLQuery(connection, query, preQueries, postQueries, extraConf, scriptSteps, scriptInputSchema, scriptOutputSchema, scriptReportLocation, authCtx, datetimenotzReadMode, dateonlyReadMode, projectKey));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/sql-queries/stream"})
    public void streamSQLQuery(HttpServletRequest req, HttpServletResponse resp, @RequestParam String queryId, @RequestParam(value="format", defaultValue="tsv-excel-header") String format, @RequestParam(value="formatParams", defaultValue="") String formatParams) throws Exception {
        try (AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext_NT(req);){
            this.service.streamSQLQuery(resp, authCtxUsage.getAuthCtx(), queryId, DatasetReadAPIUtils.getFormatDef(format, DatasetReadAPIUtils.formatParamsFromString(formatParams)));
        }
    }

    @AuditedCall(value={"msgType", "sql-query-verify", "queryId", "${queryId}"})
    @RequestMapping(value={"/api/tintercom/sql-queries/verify"})
    public void verifySQLQuery(HttpServletRequest req, HttpServletResponse resp, @RequestParam String queryId) throws Exception {
        try (AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext_NT(req);){
            this.service.verifySQLQuery(queryId);
            resp.setStatus(200);
        }
    }
}

