/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.frontend;

import com.dataiku.dip.server.notifications.frontend.FrontendEvent;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;

public class UIStateChangedEvent
extends FrontendEvent {
    public static final String NAME = "ui-state-changed";
    private final String stateName;
    private final Map<String, Object> stateParams;

    public UIStateChangedEvent(String userLogin, String webSocketSessionId, String stateName, Map<String, Object> stateParams) {
        super(userLogin, webSocketSessionId);
        this.stateParams = (Map)Preconditions.checkNotNull(stateParams);
        this.stateName = (String)Preconditions.checkNotNull((Object)stateName);
    }

    public String getStateName() {
        return (String)Preconditions.checkNotNull((Object)this.stateName);
    }

    public Map<String, Object> getStateParams() {
        if (this.stateParams != null) {
            return Collections.unmodifiableMap(this.stateParams);
        }
        return Collections.emptyMap();
    }

    public boolean shouldLog() {
        return false;
    }

    public String getName() {
        return NAME;
    }
}

