/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.server.DatasetExploreSettingsDAO;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.ExtensionFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExploresService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetExploreSettingsDAO datasetExploreSettingsDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.explore");

    public DatasetExploreSettings get(String projectKey, String datasetName) throws IOException {
        return this.datasetExploreSettingsDAO.get(projectKey, datasetName);
    }

    public DatasetExploreSettings getUnsafe(String projectKey, String datasetName) throws IOException {
        return this.datasetExploreSettingsDAO.getUnsafe(projectKey, datasetName);
    }

    public DatasetExploreSettings getCapture(String projectKey, String streamingEndpointId) throws IOException {
        return this.datasetExploreSettingsDAO.getCapture(projectKey, streamingEndpointId);
    }

    public void save(String projectKey, String datasetSmartName, DatasetExploreSettings exploreSettings) throws Exception {
        this.datasetExploreSettingsDAO.save(projectKey, datasetSmartName, exploreSettings);
    }

    public void delete(String projectKey, String datasetSmartName) throws IOException {
        this.datasetExploreSettingsDAO.delete(projectKey, datasetSmartName);
    }

    private List<RelFile> listExistingExploreFiles(String projectKey) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile exploreFolder = new RelFile(new String[]{"projects", projectKey, "explore"});
        if (!t.isDirectory(exploreFolder)) {
            return Collections.emptyList();
        }
        return t.listFiles(exploreFolder, (RelFileFilter)ExtensionFilter.json());
    }

    public List<DatasetExploreSettings> listExploresForProjectUnsafe(String projectKey) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<DatasetExploreSettings> explores = new ArrayList<DatasetExploreSettings>();
        for (RelFile file : this.listExistingExploreFiles(projectKey)) {
            try {
                explores.add((DatasetExploreSettings)t.readObjectUnsafe(file, DatasetExploreSettings.class));
            }
            catch (Exception e) {
                logger.warn((Object)("Cannot parse file " + file.getFullPath()), (Throwable)e);
            }
        }
        return explores;
    }

    public Map<String, DatasetExploreSettings> listExploresForProjectUnsafeWithDatasetName(String projectKey) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        HashMap<String, DatasetExploreSettings> explores = new HashMap<String, DatasetExploreSettings>();
        for (RelFile file : this.listExistingExploreFiles(projectKey)) {
            try {
                explores.put(file.getLeafName().replace(".json", ""), (DatasetExploreSettings)t.readObjectUnsafe(file, DatasetExploreSettings.class));
            }
            catch (Exception e) {
                logger.warn((Object)("Cannot parse file " + file.getFullPath()), (Throwable)e);
            }
        }
        return explores;
    }

    public void saveCapture(String projectKey, String streamingEndpointId, DatasetExploreSettings exploreSettings) throws Exception {
        this.datasetExploreSettingsDAO.saveCapture(projectKey, streamingEndpointId, exploreSettings);
    }

    public void deleteCapture(String projectKey, String streamingEndpointId) throws IOException {
        this.datasetExploreSettingsDAO.deleteCapture(projectKey, streamingEndpointId);
    }

    public void setExploreOnSinglePartition(String projectKey, String datasetSmartName, String partitionId) throws Exception {
        DatasetLocUtils.DatasetLoc dloc = DatasetLocUtils.resolveSmart(projectKey, datasetSmartName);
        this.datasetsDAO.getMandatoryUnsafe(dloc);
        DatasetExploreSettings explore = this.get(projectKey, datasetSmartName);
        explore.script.explorationSampling.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
        explore.script.explorationSampling.selection.selectedPartitions = Lists.newArrayList((Object[])new String[]{partitionId});
        this.save(projectKey, datasetSmartName, explore);
    }

    public List<DatasetExploreSettings.DatasetChart> listChartsForDatasetUnsafe(String projectKey, String datasetSmartName) throws IOException {
        return this.getUnsafe((String)projectKey, (String)datasetSmartName).charts;
    }

    public List<DatasetExploreSettings.ElasticSearchSavedQuery> listInteractiveSearchQueriesForDatasetUnsafe(String projectKey, String datasetSmartName) throws IOException {
        DatasetExploreSettings.DatasetInteractiveSearch interactiveSearch = this.getUnsafe((String)projectKey, (String)datasetSmartName).interactiveSearch;
        return interactiveSearch.savedQueries;
    }

    public void updateInteractiveSearchQuery(String projectKey, String datasetSmartName, DatasetExploreSettings.ElasticSearchSavedQuery savedQuery, String oldQueryName) throws IOException {
        ErrorContext.checkNotNull((Object)savedQuery.query);
        ErrorContext.checkNotNull((Object)savedQuery.name);
        DatasetExploreSettings exploreSettings = this.datasetExploreSettingsDAO.getUnsafe(projectKey, datasetSmartName);
        int i = this.findMatchingQueryIndex(exploreSettings.interactiveSearch, oldQueryName);
        if (i == -1) {
            throw new IllegalArgumentException("Cannot replace query: old query name not found: " + oldQueryName);
        }
        exploreSettings.interactiveSearch.savedQueries.set(i, savedQuery);
        this.datasetExploreSettingsDAO.save(projectKey, datasetSmartName, exploreSettings);
    }

    public void saveInteractiveSearchQuery(String projectKey, String datasetSmartName, DatasetExploreSettings.ElasticSearchSavedQuery savedQuery) throws IOException {
        ErrorContext.checkNotNull((Object)savedQuery.query);
        ErrorContext.checkNotNull((Object)savedQuery.name);
        DatasetExploreSettings exploreSettings = this.datasetExploreSettingsDAO.getUnsafe(projectKey, datasetSmartName);
        int i = this.findMatchingQueryIndex(exploreSettings.interactiveSearch, savedQuery.name);
        if (i != -1) {
            throw new IllegalArgumentException("Cannot save query: query name already exists: " + savedQuery.name);
        }
        exploreSettings.interactiveSearch.savedQueries.add(savedQuery);
        this.datasetExploreSettingsDAO.save(projectKey, datasetSmartName, exploreSettings);
    }

    public void deleteInteractiveSearchQuery(String projectKey, String datasetSmartName, String queryName) throws IOException {
        DatasetExploreSettings exploreSettings = this.datasetExploreSettingsDAO.getUnsafe(projectKey, datasetSmartName);
        int i = this.findMatchingQueryIndex(exploreSettings.interactiveSearch, queryName);
        if (i == -1) {
            throw new IllegalArgumentException("Cannot delete query: query name not found: " + queryName);
        }
        exploreSettings.interactiveSearch.savedQueries.remove(i);
        this.datasetExploreSettingsDAO.save(projectKey, datasetSmartName, exploreSettings);
    }

    private int findMatchingQueryIndex(DatasetExploreSettings.DatasetInteractiveSearch interactiveSearch, String queryName) {
        for (int i = 0; i < interactiveSearch.savedQueries.size(); ++i) {
            if (!interactiveSearch.savedQueries.get((int)i).name.equals(queryName)) continue;
            return i;
        }
        return -1;
    }
}

