/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.docgen.helpers.ModelDetailsBaseUtil;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationRecipePayloadParams;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionRecipesMeta;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.TabularPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecipeSchemaChangeService {
    @Autowired
    private SavedModelsCRUDService savedModelService;
    @Autowired
    private PredictionSMMgmtService psmmService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private RecipeSaveService recipeSaveService;
    @Autowired
    private TransactionService transactionService;

    public String updateEvalRecipeScriptDataPossibleCustomMetrics_NT(String projectKey, SerializedRecipe newRecipe, String scriptData) throws IOException {
        SavedModel newInputModel;
        EvaluationRecipePayloadParams newRecipeDesc;
        EvaluationRecipePayloadParams originalRecipeDesc;
        SavedModel originalInputModel;
        TransactionContext.assertNoAttachedTransaction();
        String recipeName = newRecipe.name;
        try (Transaction t = this.transactionService.beginRead();){
            SerializedRecipe originalRecipe = (SerializedRecipe)this.recipesDAO.getOrNullUnsafe(projectKey, recipeName);
            originalInputModel = this.getInputModelFromRecipe(projectKey, originalRecipe);
            String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
            originalRecipeDesc = (EvaluationRecipePayloadParams)JSON.parse((String)payload, EvaluationRecipePayloadParams.class);
            newRecipeDesc = (EvaluationRecipePayloadParams)JSON.parse((String)scriptData, EvaluationRecipePayloadParams.class);
            newInputModel = this.getInputModelFromRecipe(projectKey, newRecipe);
        }
        FullModelId originalFmi = originalRecipeDesc.getInputModelFMI(originalInputModel);
        FullModelId newFmi = newRecipeDesc.getInputModelFMI(newInputModel);
        PredictionModelDetails baseDetails = PredictionResultsReader.makeModelDetails(newFmi);
        if (baseDetails instanceof ClassicalPredictionModelDetails || baseDetails instanceof TimeseriesForecastingModelDetails) {
            TabularPredictionModelDetails details = (TabularPredictionModelDetails)baseDetails;
            if (!newFmi.equals(originalFmi)) {
                ArrayList<String> newCustomMetricNames = new ArrayList<String>(details.modeling.metrics.getCustomMetricNames());
                EvaluationRecipePayloadParams desc = (EvaluationRecipePayloadParams)JSON.parse((String)scriptData, EvaluationRecipePayloadParams.class);
                desc.setPossibleCustomMetrics(newCustomMetricNames);
                desc.setCustomMetrics(newCustomMetricNames);
                return JSON.pretty((Object)desc);
            }
        }
        return scriptData;
    }

    private InfoMessage.InfoMessages collectCustomMetricsChanges_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload beforeChange, SerializedRecipe.SerializedRecipeAndPayload afterChange) throws IOException {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (beforeChange.recipe.getType().equals(PredictionRecipesMeta.EVALUATION_META.getType()) && afterChange.recipe.getType().equals(PredictionRecipesMeta.EVALUATION_META.getType())) {
            FullModelId fmi;
            PredictionModelDetails baseDetails;
            SavedModel sm;
            try (Transaction t = this.transactionService.beginRead();){
                sm = this.getInputModelFromRecipe(projectKey, afterChange.recipe);
            }
            if (sm.getType() == MLTask.MLTaskType.PREDICTION && (baseDetails = PredictionResultsReader.makeModelDetails(fmi = this.psmmService.getActiveVersionFMI(sm))) instanceof ClassicalPredictionModelDetails) {
                EvaluationRecipePayloadParams initialPayload;
                ClassicalPredictionModelDetails details = (ClassicalPredictionModelDetails)baseDetails;
                Set<String> newCustomMetricNames = details.modeling.metrics.getCustomMetricNames();
                if (!CollectionUtils.isEqualCollection(newCustomMetricNames, (initialPayload = (EvaluationRecipePayloadParams)JSON.parse((String)beforeChange.payload, EvaluationRecipePayloadParams.class)).getPossibleCustomMetrics())) {
                    messages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_INPUT_MODEL_CUSTOM_METRICS_CHANGED, "New input model is configured with a different set of custom metrics to the previous input model. This change will force schema recreation for any downstream metric datasets upon the next run of this evaluation recipe.");
                }
            }
        }
        return messages;
    }

    private ArrayList<Boolean> updateDownstreamEvalRecipeMetrics(String projectKey, List<String> newCustomMetricNames, String savedModelId) throws IOException, CodedException, DKUSecurityException {
        ArrayList<Boolean> recipeUpdates = new ArrayList<Boolean>();
        for (SerializedRecipe recipe : this.recipesDAO.list(projectKey)) {
            if (!recipe.getType().equals(PredictionRecipesMeta.EVALUATION_META.getType()) || recipe.getInputsForRole("model").size() != 1 || !recipe.getSingleInput((String)"model").ref.endsWith(savedModelId)) continue;
            String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipe.name);
            EvaluationRecipePayloadParams desc = (EvaluationRecipePayloadParams)JSON.parse((String)payload, EvaluationRecipePayloadParams.class);
            if (desc.usesActiveModelVersion()) {
                desc.setPossibleCustomMetrics(newCustomMetricNames);
                desc.setCustomMetrics(newCustomMetricNames);
                this.recipeSaveService.save(projectKey, recipe, JSON.pretty((Object)desc));
                recipeUpdates.add(true);
                continue;
            }
            recipeUpdates.add(false);
        }
        return recipeUpdates;
    }

    private CustomMetricChangedResult getNewCustomMetricNamesIfChanged(MLTask baseTask, FullModelId originalFMI, FullModelId newFMI) {
        TabularPredictionModelDetails newModelDetails;
        if (!(baseTask instanceof PredictionMLTask.ClassicalPredictionMLTask) && !(baseTask instanceof PredictionMLTask.TimeseriesForecastingMLTask)) {
            return new CustomMetricChangedResult();
        }
        try {
            newModelDetails = (TabularPredictionModelDetails)ModelDetailsBaseUtil.getModel(baseTask, newFMI);
        }
        catch (IOException e) {
            PublicAPIControllerBase.logger.info((Object)"New model details cannot be retrieved, assuming the model version does not exist", (Throwable)e);
            return new CustomMetricChangedResult();
        }
        Set<String> updatedMetricNames = newModelDetails.modeling.metrics.getCustomMetricNames();
        try {
            TabularPredictionModelDetails oldModelDetails = (TabularPredictionModelDetails)ModelDetailsBaseUtil.getModel(baseTask, originalFMI);
            Set<String> initialMetricNames = oldModelDetails.modeling.metrics.getCustomMetricNames();
            if (!initialMetricNames.equals(updatedMetricNames)) {
                return new CustomMetricChangedResult(new ArrayList<String>(updatedMetricNames));
            }
            return new CustomMetricChangedResult();
        }
        catch (IOException e) {
            PublicAPIControllerBase.logger.info((Object)"Old model details cannot be retrieved, assuming the model version does not exist", (Throwable)e);
            return new CustomMetricChangedResult(new ArrayList<String>(updatedMetricNames));
        }
    }

    private boolean areForecastQuantilesDifferent(FullModelId originalFMI, FullModelId newFMI) {
        PredictionModelDetails newBaseDetails;
        if (!originalFMI.exists() && !newFMI.exists()) {
            return false;
        }
        try {
            newBaseDetails = PredictionResultsReader.makeModelDetails(newFMI);
        }
        catch (IOException e) {
            PublicAPIControllerBase.logger.info((Object)"New model details cannot be retrieved, assuming the model version does not exist", (Throwable)e);
            return false;
        }
        if (!(newBaseDetails instanceof TimeseriesForecastingModelDetails)) {
            return false;
        }
        try {
            PredictionModelDetails oldBaseDetails = PredictionResultsReader.makeModelDetails(originalFMI);
            TimeseriesForecastingModelDetails oldModelDetails = (TimeseriesForecastingModelDetails)oldBaseDetails;
            TimeseriesForecastingModelDetails newModelDetails = (TimeseriesForecastingModelDetails)newBaseDetails;
            return !CollectionUtils.isEqualCollection(oldModelDetails.coreParams.quantilesToForecast, newModelDetails.coreParams.quantilesToForecast);
        }
        catch (IOException e) {
            PublicAPIControllerBase.logger.info((Object)"Old model details cannot be retrieved, assuming the model version does not exist", (Throwable)e);
            return true;
        }
    }

    private InfoMessage.InfoMessages collectForecastQuantilesChanges_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload beforeChange, SerializedRecipe.SerializedRecipeAndPayload afterChange) throws IOException {
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (beforeChange.recipe.getType().equals(PredictionRecipesMeta.EVALUATION_META.getType()) || beforeChange.recipe.getType().equals(PredictionRecipesMeta.SCORING_META.getType())) {
            FullModelId newFMI;
            FullModelId originalFMI;
            SavedModel afterSavedModel;
            SavedModel beforeSavedModel;
            try (Transaction t = this.transactionService.beginRead();){
                beforeSavedModel = this.getInputModelFromRecipe(projectKey, beforeChange.recipe);
                afterSavedModel = this.getInputModelFromRecipe(projectKey, afterChange.recipe);
            }
            if (beforeSavedModel.miniTask instanceof PredictionMLTask.TimeseriesForecastingMLTask && afterSavedModel.miniTask instanceof PredictionMLTask.TimeseriesForecastingMLTask && this.areForecastQuantilesDifferent(originalFMI = this.psmmService.getActiveVersionFMI(beforeSavedModel), newFMI = this.psmmService.getActiveVersionFMI(afterSavedModel))) {
                messages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_INPUT_TIMESERIES_MODEL_QUANTILES_CHANGED, "New input model is configured with a different set of quantiles than the one of the previous input model. This change will force schema recreation for any downstream datasets upon the next run of this recipe.");
            }
        }
        return messages;
    }

    private SavedModel getInputModelFromRecipe(String recipeProjectKey, SerializedRecipe sr) throws IOException {
        AnyLoc model = sr.getSingleInput("model").getLoc(recipeProjectKey);
        String modelId = model.getId();
        String modelProjectKey = model.getProjectKey();
        return this.savedModelService.getMandatory(modelProjectKey, modelId);
    }

    public InfoMessage.InfoMessages collectIOChanges_NT(String projectKey, SerializedRecipe.SerializedRecipeAndPayload beforeChange, SerializedRecipe.SerializedRecipeAndPayload afterChange) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        messages.mergeFrom(this.collectCustomMetricsChanges_NT(projectKey, beforeChange, afterChange));
        messages.mergeFrom(this.collectForecastQuantilesChanges_NT(projectKey, beforeChange, afterChange));
        return messages;
    }

    public boolean computeAndPropagateSchemaChanges(SavedModel sm, FullModelId originalFMI, FullModelId newFMI) throws IOException, CodedException, DKUSecurityException {
        CustomMetricChangedResult changeResult = this.getNewCustomMetricNamesIfChanged(sm.miniTask, originalFMI, newFMI);
        if (changeResult.areMetricsChanged) {
            ArrayList<Boolean> updates = this.updateDownstreamEvalRecipeMetrics(sm.getProjectKey(), changeResult.newMetricNames, sm.id);
            return updates.stream().anyMatch(x -> x);
        }
        if (originalFMI.hasOverrides() != newFMI.hasOverrides()) {
            return true;
        }
        if (sm.miniTask instanceof PredictionMLTask.TimeseriesForecastingMLTask) {
            return this.areForecastQuantilesDifferent(originalFMI, newFMI);
        }
        return false;
    }

    private static class CustomMetricChangedResult {
        public final boolean areMetricsChanged;
        public final List<String> newMetricNames;

        public CustomMetricChangedResult() {
            this.areMetricsChanged = false;
            this.newMetricNames = new ArrayList<String>();
        }

        public CustomMetricChangedResult(List<String> newMetricNames) {
            this.areMetricsChanged = true;
            this.newMetricNames = newMetricNames;
        }
    }
}

