/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.staticdata;

import com.dataiku.dip.analysis.ml.MLDiagnostics;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.server.staticdata.AbstractStaticData;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class PmlDiagnosticsDefinition
implements AbstractStaticData {
    private final String lang;

    public PmlDiagnosticsDefinition(String lang) {
        this.lang = lang;
    }

    @Override
    public String getKey() {
        return "pmlDiagnosticsDefinition";
    }

    @Override
    public Object getData() {
        return this.getDiagnosticsDefinition();
    }

    private List<DiagnosticDefinitionItem> getDiagnosticsDefinition() {
        ArrayList<DiagnosticDefinitionItem> result = new ArrayList<DiagnosticDefinitionItem>();
        Stream.concat(Arrays.stream(MLTask.BackendType.values()), Stream.of((MLTask.BackendType)null)).forEach(backendType -> Stream.concat(Arrays.stream(PredictionMLTask.PredictionType.values()), Stream.of((PredictionMLTask.PredictionType)null)).forEach(predictionType -> {
            DiagnosticDefinitionItem item = new DiagnosticDefinitionItem((MLTask.BackendType)((Object)backendType), (PredictionMLTask.PredictionType)((Object)((Object)predictionType)));
            if (!item.definitions.isEmpty()) {
                item.definitions = MLDiagnostics.translateDiagnosticTypes(item.definitions, this.lang);
                result.add(item);
            }
        }));
        return result;
    }

    static class DiagnosticDefinitionItem {
        public MLTask.BackendType backendType;
        public PredictionMLTask.PredictionType predictionType;
        public Map<WarningsContext.WarningType, MLDiagnostics.DiagnosticDefinition> definitions;
        public String lang;

        public DiagnosticDefinitionItem(MLTask.BackendType backendType, PredictionMLTask.PredictionType predictionType) {
            this.backendType = backendType;
            this.predictionType = predictionType;
            this.definitions = MLDiagnostics.getMLTaskDiagnosticsTypes(MLTask.MLTaskType.PREDICTION, backendType, predictionType);
        }
    }
}

