/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.numbers;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.text.Labelled;
import com.dataiku.dip.util.ParamDesc;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class NumericalFormatConverter
extends AppliesToProcessor
implements Processor {
    private static final Pattern SPACES = Pattern.compile("[\\s\\u00a0\\u2002-\\u200b\\u202f\\u205f\\u3000\\u303f\\ufeff]+");
    private static final Pattern APOSTROPHES = Pattern.compile("['\\u02b9\\u02bc\\u02c8\\u0301\\u0313\\u0315\\u055a\\u05f3\\u07f4\\u1fbf\\u2019\\u2032\\ua78c\\uff07]+");
    private static final Pattern COMMAS = Pattern.compile("[,\\u0326\\u066b\\u201a\\u2e34\\ufe50\\uff0c]+");
    private static final Pattern DOTS = Pattern.compile("[\\.\\u00b7\\u0323]+");
    public static final ProcessorMeta<NumericalFormatConverter, Parameter> META = new ProcessorMeta<NumericalFormatConverter, Parameter>(){

        @Override
        public String getName() {
            return "NumericalFormatConverter";
        }

        @Override
        public String getDocPage() {
            return "numerical-format-convert";
        }

        @Override
        public Category getCategory() {
            return Category.CLEANSING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CLEANSING, ProcessorTag.MATH});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.NumericalFormatConverter.HELP", "Convert numbers from one language/country-specific format to another. \n\n# Options\n\n**Column**\n\nConvert numbers in the following columns: \n\n* A single column\n\n* An explicit list of columns\n\n* All columns matching a regex pattern\n\n* All columns \n\n**Input format**\n\nNumber format of input column(s). Decimal numbers are stored in the raw format. Supported formats: \n\n* Raw: 1234567890.123 (required format for numeric columns fed to other DSS mechanisms)\n\n* French: 1 234 567 890,123 (also: Canadian, Danish, Finnish, Swedish)\n\n* English: 1,234,567,890.123 (also: Thai)\n\n* Italian: 1.234.567.890,123 (also: Norwegian, Spanish)\n\n* Swiss: 1'234'567'890.123\n\n**Output format**\n\nNumber format of output column(s). See supported formats above.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.NumericalFormatConverter.DESCRIPTION", 1.actionVerb("Convert") + " number formats"), null, false).withParam(ParamDesc.advancedSelect("inFormat", this.translate(language, "SHAKER.PROCESSOR.NumericalFormatConverter.INPUT_FORMAT", "Input format"), "", Format.class, language).withDefaultValue(Format.EN)).withParam(ParamDesc.advancedSelect("outFormat", this.translate(language, "SHAKER.PROCESSOR.NumericalFormatConverter.OUTPUT_FORMAT", "Output format"), "", Format.class, language).withDefaultValue(Format.RAW)).withParam("outCol", "string", false, true, this.translate(language, "SHAKER.PROCESSORS.DESCRIPTION.OUTPUT_COLUMN_EMPTY_FOR_INPLACE", "Output column (empty for in-place)"));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject obj = AppliesToProcessor.selfReport(parameter);
            obj.remove("outCol");
            return obj;
        }

        @Override
        public NumericalFormatConverter build(Parameter parameter) {
            return new NumericalFormatConverter(parameter);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type:" + pss.params.getClass().getSimpleName());
            }
            Parameter converterParams = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                String singleColumn;
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                String string = singleColumn = !converterParams.columns.isEmpty() ? (String)converterParams.columns.get(0) : null;
                if (converterParams.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN && !Objects.equals(singleColumn, converterParams.outCol)) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(converterParams.outCol);
                    updatedDatasetPairLineage.addFactorizedColumnRelations(singleColumn, converterParams.outCol);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    Column outCD;
    boolean modified;
    final Parameter param;

    public static String normalize(String number) {
        number = SPACES.matcher(number).replaceAll(" ").trim();
        number = DOTS.matcher(number).replaceAll(".");
        number = COMMAS.matcher(number).replaceAll(",");
        number = APOSTROPHES.matcher(number).replaceAll("'");
        return number;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.param.appliesTo == AppliesToProcessor.AppliesTo.SINGLE_COLUMN && this.param.outCol != null && !this.param.outCol.equals("")) {
            this.outCD = this.getColumnFactory().columnAfter((String)this.param.columns.get(0), this.param.outCol, Processor.ProcessorRole.OUTPUT_COLUMN);
        }
        this.modified = this.param.inFormat != this.param.outFormat;
    }

    @Override
    public void processRowForColumns(Row row, Iterable<Column> columns) throws Exception {
        for (Column cd : columns) {
            boolean modified;
            String v = row.get(cd);
            boolean bl = modified = this.param.inFormat != this.param.outFormat;
            if (modified && v != null && !v.equals("")) {
                v = NumericalFormatConverter.normalize(v);
                v = this.param.outFormat.format(this.param.inFormat.toRaw(v));
            }
            if (this.outCD != null) {
                row.put(this.outCD, v);
                continue;
            }
            if (!modified) continue;
            row.put(cd, v);
        }
    }

    @Override
    public AppliesToProcessor.AppliesToParams getParams() {
        return this.param;
    }

    public void postProcess() throws Exception {
    }

    public NumericalFormatConverter(Parameter param) {
        this.param = param;
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = 1L;
        public Format inFormat = Format.EN;
        public Format outFormat = Format.RAW;
        public String outCol = "";
    }

    public static enum Format implements Labelled
    {
        RAW("Raw (1234567890.123)", ".", null),
        FR("French (1 234 567 890,123)", ",", " "),
        EN("English (1,234,567,890.123)", ".", ","),
        IT("Italian (1.234.567.890,123)", ",", "."),
        CH("Swiss (1'234'567'890.123)", ".", "'");

        public final String labelEn;
        public final CharSequence decimal;
        public final CharSequence thousands;

        private Format(String labelEn, CharSequence decimal, CharSequence thousands) {
            this.labelEn = labelEn;
            this.decimal = decimal;
            this.thousands = thousands;
        }

        @Override
        public String getLabel() {
            return this.labelEn;
        }

        @Override
        public String getLabel(String language) {
            TranslationService sts = (TranslationService)SpringUtils.getBean(TranslationService.class);
            return sts.translateNoContext(language, "SHAKER.PROCESSOR.NumericalFormatConverter.Format." + this.name(), this.labelEn, new Object[0]);
        }

        public String toRaw(String formatted) {
            if (this == RAW) {
                return formatted;
            }
            String raw = formatted.replace(this.thousands, "");
            if (!this.decimal.equals(".")) {
                raw = raw.replace(this.decimal, ".");
            }
            return raw;
        }

        public String format(String raw) {
            int pos;
            if (this == RAW) {
                return raw;
            }
            StringBuilder sb = new StringBuilder();
            int exp = raw.indexOf(101);
            String significandPart = exp >= 0 ? raw.substring(0, exp) : raw;
            String expPart = exp >= 0 ? raw.substring(exp) : "";
            int dec = significandPart.indexOf(46);
            String intPart = dec >= 0 ? significandPart.substring(0, dec) : significandPart;
            String decPart = dec >= 0 ? significandPart.substring(dec + 1) : "";
            boolean isNegative = intPart.startsWith("-");
            if (isNegative) {
                intPart = intPart.substring(1);
                sb.append("-");
            }
            if ((pos = intPart.length() % 3) != 0) {
                sb.append(intPart.substring(0, pos));
                if (intPart.length() > 3) {
                    sb.append(this.thousands);
                }
                intPart = intPart.substring(pos);
            }
            while (!intPart.isEmpty()) {
                sb.append(intPart.substring(0, 3));
                if (intPart.length() > 3) {
                    sb.append(this.thousands);
                }
                intPart = intPart.substring(3);
            }
            if (sb.length() == 0) {
                sb.append('0');
            }
            if (!decPart.isEmpty()) {
                sb.append(this.decimal).append(decPart);
            }
            if (exp > 0) {
                sb.append(expPart);
            }
            return sb.toString();
        }
    }
}

