/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;

public class ArrayExtractProcessor
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<ArrayExtractProcessor, Parameter> META = new ProcessorMeta<ArrayExtractProcessor, Parameter>(){

        @Override
        public String getName() {
            return "ArrayExtractProcessor";
        }

        @Override
        public String getDocPage() {
            return "array-extract";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.COMPLEX});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ArrayExtractProcessor.HELP", "Extract an element or a sub-array from an array written in JSON.\n\n# Options\n\n**Input column**\nColumn to extract element or array.\n\n**Mode**\nChoose from:\n- **Extract an element:** Provide the element's index number. Use negative index to count from the end of the array: (-1 is the last value, -2 is second to last, etc).\n- **Extract a sub-array:** Provide the starting and ending index numbers.\n\n**Output column**\nCreate a separate output column or leave blank to perform extraction in-column.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return new ProcessorDesc(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ArrayExtractProcessor.DESCRIPTION", 1.actionVerb("Extract") + " from array"), false);
        }

        @Override
        public Object selfReport(Parameter p) {
            return JSON.deepCopyExcept((Object)p, (String[])new String[]{"input", "output"});
        }

        @Override
        public ArrayExtractProcessor build(Parameter param) {
            return new ArrayExtractProcessor(param);
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            Parameter arrayExtractorParam = (Parameter)pss.params;
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                if (StringUtils.isNotBlank((String)arrayExtractorParam.output)) {
                    updatedDatasetPairLineage.addFactorizedColumnRelations(arrayExtractorParam.input, arrayExtractorParam.output);
                }
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final Parameter param;
    private Column in;
    private Column out;

    public ArrayExtractProcessor(Parameter parameter) {
        this.param = parameter;
    }

    public void init() {
        this.in = this.getColumnFactory().column(this.param.input, Processor.ProcessorRole.INPUT_COLUMN);
        this.out = this.param.output != null && !this.param.output.equals("") ? this.getColumnFactory().columnAfter(this.param.input, this.param.output, Processor.ProcessorRole.OUTPUT_COLUMN) : this.in;
    }

    public void processRow(Row row) {
        String v = row.get(this.in);
        if (v == null || v.isEmpty()) {
            return;
        }
        try {
            JSONArray array = new JSONArray(v);
            if (this.param.mode == Mode.INDEX) {
                int index;
                int n = index = this.param.index < 0 ? array.length() + this.param.index : this.param.index;
                if (index >= 0 && index < array.length()) {
                    Object so = array.get(index);
                    String r = so == null ? null : so.toString();
                    row.put(this.out, r);
                }
            } else if (this.param.mode == Mode.RANGE) {
                int begin = this.param.begin < 0 ? array.length() + this.param.begin : this.param.begin;
                int end = this.param.end < 0 ? array.length() + this.param.end + 1 : this.param.end + 1;
                begin = Math.max(begin, 0);
                end = Math.min(end, array.length());
                ArrayList<Object> outArray = new ArrayList<Object>();
                for (int i = begin; i < end; ++i) {
                    outArray.add(array.get(i));
                }
                row.put(this.out, new JSONArray(outArray).toString());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String input;
        public String output;
        public Mode mode = Mode.INDEX;
        public int index;
        public int begin;
        public int end;

        public void validate() throws IllegalArgumentException {
        }
    }

    public static enum Mode {
        INDEX,
        RANGE;

    }
}

