/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.datalayer.memimpl.HighlightedMemRow;
import com.dataiku.dip.datalayer.memimpl.HighlightedMemTable;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.TableColoringService;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SerializedTableChunk {
    public int firstRow;
    public int nbRows;
    public int firstCol;
    public int nbCols;
    public int totalRows;
    public int totalKeptRows;
    public WarningsContext.SerializedWarnings warnings;
    public int[] origRowIdx;
    public String[] status;
    public String[] content;
    @Nullable
    public Map<Integer, List<int[]>> highlightedIndices;
    public float[] colorBin;
    private transient List<MemColumn> columnsInRange = new ArrayList<MemColumn>();
    private final transient int firstOrigRow;
    private final transient TableColoringService coloringService;
    private transient Map<String, ColoringDefinition.ColoringGroup> columnNameToColoringGroups = new HashMap<String, ColoringDefinition.ColoringGroup>();
    private transient Map<String, List<Expression>> columnNameToExpressions = new HashMap<String, List<Expression>>();
    private transient Map<ColoringDefinition.ColoringGroup, List<Expression>> coloringGroupToExpressions = new HashMap<ColoringDefinition.ColoringGroup, List<Expression>>();

    public SerializedTableChunk(int firstRow, int nbRows, int firstCol, int nbCols) {
        this(firstRow, nbRows, firstCol, nbCols, 0);
    }

    public SerializedTableChunk(int firstRow, int nbRows, int firstCol, int nbCols, int firstOrigRow) {
        this.firstRow = firstRow;
        this.nbRows = nbRows;
        this.firstCol = firstCol;
        this.nbCols = nbCols;
        this.origRowIdx = new int[nbRows];
        this.status = new String[nbRows * nbCols];
        this.content = new String[nbRows * nbCols];
        this.coloringService = (TableColoringService)SpringUtils.getBean(TableColoringService.class);
        this.firstOrigRow = firstOrigRow;
    }

    public void fill(MemTable table, boolean[] filters, SerializedShakerScript.TableColoring coloring, SerializedShakerScript.DisplayedColumnsSelection columnsSelection) {
        int filledRows = 0;
        int validRows = 0;
        this.columnNameToColoringGroups = new HashMap<String, ColoringDefinition.ColoringGroup>();
        this.columnNameToExpressions = new HashMap<String, List<Expression>>();
        this.coloringGroupToExpressions = new HashMap<ColoringDefinition.ColoringGroup, List<Expression>>();
        if (coloring.scheme != ColoringDefinition.TableColoringScheme.MEANING_AND_STATUS && coloring.scheme != ColoringDefinition.TableColoringScheme.FILL_ONLY) {
            this.colorBin = new float[this.nbRows * this.nbCols];
        }
        this.columnsInRange = this.computeColumnsInRange(table, columnsSelection);
        if (coloring.scheme == ColoringDefinition.TableColoringScheme.INDIVIDUAL_COLUMNS_RULES) {
            Set columnNamesInRange = this.columnsInRange.stream().map(MemColumn::getName).collect(Collectors.toSet());
            for (ColoringDefinition.ColumnRules columnRules2 : coloring.individualColumnsRules) {
                if (!columnNamesInRange.contains(columnRules2.column)) continue;
                this.columnNameToExpressions.put(columnRules2.column, TableColoringService.buildExpressions(columnRules2.rulesDesc, table));
            }
        } else if (coloring.scheme == ColoringDefinition.TableColoringScheme.SINGLE_COLUMN_RULES) {
            if (coloring.singleColumn != null) {
                coloring.individualColumnsRules.stream().filter(r -> coloring.singleColumn.equals(r.column)).findFirst().ifPresent(columnRules -> this.columnNameToExpressions.put(columnRules.column, TableColoringService.buildExpressions(columnRules.rulesDesc, table)));
            }
        } else if (coloring.scheme == ColoringDefinition.TableColoringScheme.COLORING_GROUPS) {
            for (MemColumn column : this.columnsInRange) {
                List basedOnColumnFilterDescs;
                ColoringDefinition.ColoringGroup coloringGroup = ColoringDefinition.findAppliedColoringGroup(coloring.coloringGroups, (String)column.getName());
                this.columnNameToColoringGroups.put(column.getName(), coloringGroup);
                if (coloringGroup == null || coloringGroup.scheme != ColoringDefinition.ColoringGroupScheme.RULES) continue;
                if (coloringGroup.scope == ColoringDefinition.ColoringGroupScope.COLUMNS) {
                    basedOnColumnFilterDescs = coloringGroup.rulesGroup.getBasedOnColumnFilterDescs(column.getName());
                    this.columnNameToExpressions.put(column.getName(), TableColoringService.buildExpressions(basedOnColumnFilterDescs, table));
                    continue;
                }
                if (!coloringGroup.isBasedOnAnotherColumn(column.getName()) || !table.hasNonDeletedColumn(coloringGroup.basedOnColumnName) || this.coloringGroupToExpressions.get(coloringGroup) != null) continue;
                basedOnColumnFilterDescs = coloringGroup.rulesGroup.getBasedOnColumnFilterDescs(coloringGroup.basedOnColumnName);
                this.coloringGroupToExpressions.put(coloringGroup, TableColoringService.buildExpressions(basedOnColumnFilterDescs, table));
            }
        }
        for (int i = 0; i < table.rows.size(); ++i) {
            if (filters != null && !filters[i]) continue;
            if (validRows >= this.firstRow) {
                this.fillRow(filledRows, i, table, table.rows.get(i), coloring);
                if (++filledRows == this.nbRows) break;
            }
            ++validRows;
        }
        this.totalRows = table.rows.size();
        this.totalKeptRows = filters == null ? this.totalRows : FilteringExecutor.countTrue(filters);
    }

    private List<MemColumn> computeColumnsInRange(MemTable table, SerializedShakerScript.DisplayedColumnsSelection columnsSelection) {
        ArrayList<MemColumn> result = new ArrayList<MemColumn>();
        ArrayList<SerializedShakerScript.DisplayedColumn> displayedColumns = new ArrayList<SerializedShakerScript.DisplayedColumn>();
        if (columnsSelection.list == null) {
            if (columnsSelection.mode == SerializedShakerScript.DisplayedColumnsMode.ALL) {
                int lastIndex = Math.min(this.firstCol + this.nbCols, table.columnsList.size());
                return table.columnsList.subList(this.firstCol, lastIndex);
            }
            return result;
        }
        for (SerializedShakerScript.DisplayedColumn dc : columnsSelection.list) {
            if (!dc.d) continue;
            displayedColumns.add(dc);
        }
        for (int i = 0; i < this.nbCols; ++i) {
            if (this.firstCol + i >= displayedColumns.size()) continue;
            String name = ((SerializedShakerScript.DisplayedColumn)displayedColumns.get((int)(this.firstCol + i))).name;
            result.add(table.column(name));
        }
        return result;
    }

    private void fillRow(int targetRowIndex, int originalRowIndex, MemTable table, MemRow row, SerializedShakerScript.TableColoring coloring) {
        this.origRowIdx[targetRowIndex] = originalRowIndex + this.firstOrigRow;
        boolean canHighlight = table instanceof HighlightedMemTable;
        String singleColorPalette = null;
        float singleColorBin = -1.0f;
        HashMap<ColoringDefinition.ColoringGroup, ColorResult> cachedBasedOnAnotherColumnResults = null;
        if (coloring.scheme == ColoringDefinition.TableColoringScheme.SINGLE_COLUMN_VALUES && table.hasNonDeletedColumn(coloring.singleColumn)) {
            cd = table.getColumn(coloring.singleColumn);
            String val = row.getFast(cd.index);
            singleColorBin = this.coloringService.getColorBin(coloring.valueColoringMode, cd, val, 11);
            singleColorPalette = cd.colorPalette;
        } else if (coloring.scheme == ColoringDefinition.TableColoringScheme.SINGLE_COLUMN_RULES && table.hasNonDeletedColumn(coloring.singleColumn)) {
            cd = table.getColumn(coloring.singleColumn);
            List<Expression> expressions = this.columnNameToExpressions.get(cd.getName());
            singleColorBin = expressions != null ? (float)TableColoringService.findFirstMatchingRule(expressions, row) : -1.0f;
        }
        for (int i = 0; i < this.columnsInRange.size(); ++i) {
            List<int[]> highlightedVal;
            MemColumn cd = this.columnsInRange.get(i);
            String val = row.getFast(cd.index);
            int cellIdx = targetRowIndex * this.nbCols + i;
            block0 : switch (coloring.scheme) {
                case MEANING_AND_STATUS: {
                    this.colorCellByMeaning(table, cd, row, cellIdx, val);
                    break;
                }
                case INDIVIDUAL_COLUMNS_VALUES: {
                    if (coloring.individualColumns.contains(cd.getName())) {
                        this.status[cellIdx] = cd.colorPalette;
                        this.colorBin[cellIdx] = this.coloringService.getColorBin(coloring.valueColoringMode, cd, val, 11);
                        break;
                    }
                    this.status[cellIdx] = "VU";
                    break;
                }
                case ALL_COLUMNS_VALUES: {
                    this.status[cellIdx] = cd.colorPalette;
                    this.colorBin[cellIdx] = this.coloringService.getColorBin(coloring.valueColoringMode, cd, val, 11);
                    break;
                }
                case SINGLE_COLUMN_VALUES: {
                    this.status[cellIdx] = singleColorPalette;
                    this.colorBin[cellIdx] = singleColorBin;
                    break;
                }
                case SINGLE_VALUE_HIGHLIGHT: {
                    this.colorBin[cellIdx] = coloring.singleValue.equals(val) ? 1.0f : -1.0f;
                    break;
                }
                case FILL_ONLY: {
                    this.status[cellIdx] = "";
                    break;
                }
                case INDIVIDUAL_COLUMNS_RULES: {
                    this.colorCellByRules(cd, row, cellIdx);
                    break;
                }
                case SINGLE_COLUMN_RULES: {
                    this.status[cellIdx] = singleColorBin == -1.0f ? "VU" : "VR";
                    this.colorBin[cellIdx] = singleColorBin;
                    break;
                }
                case COLORING_GROUPS: {
                    ColoringDefinition.ColoringGroup coloringGroup = this.columnNameToColoringGroups.get(cd.getName());
                    if (coloringGroup != null && coloringGroup.scheme != null && coloringGroup.scope == ColoringDefinition.ColoringGroupScope.COLUMNS) {
                        switch (coloringGroup.scheme) {
                            case MEANING_AND_STATUS: {
                                this.colorCellByMeaning(table, cd, row, cellIdx, val);
                                break block0;
                            }
                            case COLOR_SCALE: {
                                int maxColoredBins = coloringGroup.colorScaleDef != null ? coloringGroup.colorScaleDef.sample.size() : 11;
                                this.status[cellIdx] = cd.colorPalette;
                                this.colorBin[cellIdx] = this.coloringService.getColorBin(coloring.valueColoringMode, cd, val, maxColoredBins);
                                break block0;
                            }
                            case RULES: {
                                this.colorCellByRules(cd, row, cellIdx);
                                break block0;
                            }
                        }
                        this.status[cellIdx] = "VU";
                        this.colorBin[cellIdx] = 0.0f;
                        break;
                    }
                    if (coloringGroup != null && coloringGroup.scheme != null && coloringGroup.scope == ColoringDefinition.ColoringGroupScope.ALL_COLUMNS_BASED_ON_ANOTHER_COLUMN && coloringGroup.basedOnColumnName != null) {
                        ColorResult cachedResult;
                        if (!table.hasNonDeletedColumn(coloringGroup.basedOnColumnName)) {
                            this.status[cellIdx] = "VU";
                            if (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.RULES) {
                                this.colorBin[cellIdx] = -1.0f;
                                break;
                            }
                            this.colorBin[cellIdx] = 0.0f;
                            break;
                        }
                        if (cachedBasedOnAnotherColumnResults == null) {
                            cachedBasedOnAnotherColumnResults = new HashMap<ColoringDefinition.ColoringGroup, ColorResult>();
                        }
                        if ((cachedResult = (ColorResult)cachedBasedOnAnotherColumnResults.get(coloringGroup)) == null) {
                            cachedResult = new ColorResult();
                            if (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.RULES) {
                                List<Expression> basedOnAnotherColumnExpressions = this.coloringGroupToExpressions.get(coloringGroup);
                                cachedResult.colorBin = basedOnAnotherColumnExpressions != null ? (float)TableColoringService.findFirstMatchingRule(basedOnAnotherColumnExpressions, row) : -1.0f;
                            } else if (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.COLOR_SCALE) {
                                basedOnAnotherColumn = table.getColumn(coloringGroup.basedOnColumnName);
                                basedOnAnotherColumnValue = row.getFast(basedOnAnotherColumn.index);
                                int maxColoredBins = coloringGroup.colorScaleDef != null ? coloringGroup.colorScaleDef.sample.size() : 11;
                                cachedResult.colorBin = this.coloringService.getColorBin(coloring.valueColoringMode, basedOnAnotherColumn, basedOnAnotherColumnValue, maxColoredBins);
                                cachedResult.status = basedOnAnotherColumn.colorPalette;
                            } else if (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.MEANING_AND_STATUS) {
                                basedOnAnotherColumn = table.getColumn(coloringGroup.basedOnColumnName);
                                basedOnAnotherColumnValue = row.getFast(basedOnAnotherColumn.index);
                                cachedResult.status = this.computeCellValidityStatus(basedOnAnotherColumn, basedOnAnotherColumnValue) + this.computeCellChangeStatus(table, row, basedOnAnotherColumn);
                            }
                            cachedBasedOnAnotherColumnResults.put(coloringGroup, cachedResult);
                        }
                        if (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.COLOR_SCALE) {
                            this.status[cellIdx] = cachedResult.status;
                            this.colorBin[cellIdx] = cachedResult.colorBin;
                            break;
                        }
                        if (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.RULES) {
                            this.colorBin[cellIdx] = cachedResult.colorBin;
                            if (cachedResult.colorBin == -1.0f) {
                                this.status[cellIdx] = "VU";
                                break;
                            }
                            this.status[cellIdx] = "VR";
                            break;
                        }
                        if (coloringGroup.scheme != ColoringDefinition.ColoringGroupScheme.MEANING_AND_STATUS) break;
                        this.status[cellIdx] = cachedResult.status;
                        break;
                    }
                    this.colorBin[cellIdx] = 0.0f;
                    this.status[cellIdx] = "VU";
                }
            }
            if (val != null && cd.selectedType != null && (cd.selectedType.type.isLong() || cd.selectedType.type.isDouble()) && (val.charAt(0) == '-' || val.charAt(0) >= '0' && val.charAt(0) <= '9') && DKUDoubles.tryParse((String)val) != null) {
                this.status[cellIdx] = "NV " + this.status[cellIdx];
            }
            this.content[cellIdx] = val;
            if (!canHighlight || !(row instanceof HighlightedMemRow)) continue;
            if (this.highlightedIndices == null) {
                this.highlightedIndices = new HashMap<Integer, List<int[]>>();
            }
            if ((highlightedVal = ((HighlightedMemRow)row).getHighlighted(cd)) == null) continue;
            this.highlightedIndices.put(cellIdx, highlightedVal);
        }
    }

    private void colorCellByMeaning(MemTable table, MemColumn column, MemRow row, int cellIdx, String cellValue) {
        this.status[cellIdx] = this.computeCellValidityStatus(column, cellValue) + this.computeCellChangeStatus(table, row, column);
    }

    private void colorCellByRules(MemColumn column, MemRow row, int cellIdx) {
        List<Expression> expressions = this.columnNameToExpressions.get(column.getName());
        int bin = expressions != null ? TableColoringService.findFirstMatchingRule(expressions, row) : -1;
        this.status[cellIdx] = bin == -1 ? "VU" : "VR";
        this.colorBin[cellIdx] = bin;
    }

    private String computeCellChangeStatus(MemTable table, MemRow row, MemColumn column) {
        if (table.changeTracking) {
            if (column.state == 1) {
                return "N";
            }
            switch (row.getCellState(column)) {
                case 0: {
                    return "U";
                }
                case 2: {
                    return "C";
                }
                case 1: {
                    return "N";
                }
                case 3: {
                    return "D";
                }
            }
            throw new Error("Never reached");
        }
        return "U";
    }

    private String computeCellValidityStatus(MemColumn cd, String val) {
        if (val == null) {
            return "E";
        }
        return cd.selectedType != null && cd.selectedType.type.detects(val) > 0.0 ? "V" : "I";
    }

    private static class ColorResult {
        String status = null;
        float colorBin = -1.0f;

        private ColorResult() {
        }
    }
}

