/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.sql.queries.QuotedPortionFinder;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QuotedPortionFinders {

    public static class PostgresStringLiteralFinder
    implements QuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new PostgresStringLiteralFinder(sql);
            }
        };
        private static final String HINT_STANDARD_CONFORMITY_PATTERN = "(--\\s*DKU_HINT_NONSTANDARD_STRINGS.*?\\r?\\n)";
        private static final String SET_STANDARD_CONFORMITY_PATTERN = "(\\bstandard_conforming_strings\\s*=\\s*(\\w+)\\b)";
        private final Matcher dkuHintMatcher;
        private final Matcher setConformityMatcher;
        private final QuotedPortionFinder conformMatcher;
        private final QuotedPortionFinder nonConformMatcher;
        private boolean isConform;
        private Map<Integer, String> hintsFound = Maps.newHashMap();
        private Map<Integer, String> setsFound = Maps.newHashMap();
        private Map<Integer, String> setValuesFound = Maps.newHashMap();
        private int nextHintStart = -1;
        private int nextSetStart = -1;
        private int nextLiteralStart = -1;
        private int nextHintFrom = -1;
        private int nextSetFrom = -1;
        private int nextLiteralFrom = -1;

        private PostgresStringLiteralFinder(String sql) {
            this.conformMatcher = SingleQuotedNoEscapeFinder.META.build(sql);
            this.nonConformMatcher = BackslashEscapedSingleQuotedFinder.META.build(sql);
            this.dkuHintMatcher = Pattern.compile(HINT_STANDARD_CONFORMITY_PATTERN, 2).matcher(sql);
            this.setConformityMatcher = Pattern.compile(SET_STANDARD_CONFORMITY_PATTERN, 2).matcher(sql);
            this.isConform = true;
        }

        public int findStart(int from) {
            if (this.nextHintFrom < 0 || from < this.nextHintFrom || this.nextHintStart >= 0 && from >= this.nextHintStart) {
                this.nextHintFrom = from;
                int n = this.nextHintStart = this.dkuHintMatcher.find(from) ? this.dkuHintMatcher.start() : -1;
            }
            if (this.nextSetFrom < 0 || from < this.nextSetFrom || this.nextSetStart >= 0 && from >= this.nextSetStart) {
                this.nextSetFrom = from;
                int n = this.nextSetStart = this.setConformityMatcher.find(from) ? this.setConformityMatcher.start() : -1;
            }
            if (this.nextLiteralFrom < 0 || from < this.nextLiteralFrom || this.nextLiteralStart >= 0 && from >= this.nextLiteralStart) {
                this.nextLiteralFrom = from;
                this.nextLiteralStart = this.isConform ? this.conformMatcher.findStart(from) : this.nonConformMatcher.findStart(from);
            }
            int hintStart = this.nextHintStart;
            int setStart = this.nextSetStart;
            int literalStart = this.nextLiteralStart;
            if (!(hintStart < 0 || setStart >= 0 && hintStart >= setStart || literalStart >= 0 && hintStart >= literalStart)) {
                this.hintsFound.put(hintStart, this.dkuHintMatcher.group());
                return hintStart;
            }
            if (!(setStart < 0 || hintStart >= 0 && setStart >= hintStart || literalStart >= 0 && setStart >= literalStart)) {
                this.setsFound.put(setStart, this.setConformityMatcher.group(1));
                this.setValuesFound.put(setStart, this.setConformityMatcher.group(2));
                return setStart;
            }
            return literalStart;
        }

        public int startSegmentLength(int from) {
            if (this.hintsFound.containsKey(from)) {
                return this.hintsFound.get(from).length();
            }
            if (this.setsFound.containsKey(from)) {
                return this.setsFound.get(from).length();
            }
            return this.isConform ? this.conformMatcher.startSegmentLength(from) : this.nonConformMatcher.startSegmentLength(from);
        }

        public int findEnd(int start) {
            if (this.hintsFound.containsKey(start)) {
                this.isConform = false;
                return start + this.hintsFound.get(start).length() - 1;
            }
            if (this.setsFound.containsKey(start)) {
                String newState = this.setValuesFound.get(start);
                this.isConform = newState.equalsIgnoreCase("true") || newState.equalsIgnoreCase("on");
                return start + this.setsFound.get(start).length() - 1;
            }
            return this.isConform ? this.conformMatcher.findEnd(start) : this.nonConformMatcher.findEnd(start);
        }

        public boolean findsComments() {
            return false;
        }
    }

    public static class NestedMultiLineCommentFinder
    extends RegexStartQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new NestedMultiLineCommentFinder(sql);
            }
        };

        private NestedMultiLineCommentFinder(String sql) {
            super(sql, "/\\*", true);
        }

        public int findEnd(int start) {
            int stackHeight = 1;
            int pos = start + 2;
            while (pos < this.sql.length() && stackHeight > 0) {
                int nextCommentStart = this.sql.indexOf("/*", pos);
                int nextCommentEnd = this.sql.indexOf("*/", pos);
                if (nextCommentStart < 0) {
                    nextCommentStart = this.sql.length();
                }
                if (nextCommentEnd < 0) {
                    nextCommentEnd = this.sql.length();
                }
                if (nextCommentStart < nextCommentEnd) {
                    pos = nextCommentStart + 2;
                    ++stackHeight;
                    continue;
                }
                pos = nextCommentEnd + 2;
                --stackHeight;
            }
            return pos - 1;
        }
    }

    public static class OracleQuotedStringLiteralFinder
    extends RegexStartQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new OracleQuotedStringLiteralFinder(sql);
            }
        };

        private OracleQuotedStringLiteralFinder(String sql) {
            super(sql, "(q|Q)'([^'])", false);
        }

        public int findEnd(int start) {
            this.startMatcher.find(start);
            int delimiter = this.startMatcher.group(2).charAt(0);
            if (delimiter == 91) {
                delimiter = 93;
            } else if (delimiter == 40) {
                delimiter = 41;
            } else if (delimiter == 123) {
                delimiter = 125;
            } else if (delimiter == 60) {
                delimiter = 62;
            }
            int end = this.sql.indexOf((char)delimiter + "'", start + 3);
            return end < 0 ? this.sql.length() - 1 : end + 1;
        }
    }

    public static class PostgresDollarQuotedLiteralFinder
    extends RegexStartQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new PostgresDollarQuotedLiteralFinder(sql);
            }
        };

        private PostgresDollarQuotedLiteralFinder(String sql) {
            super(sql, "\\$([^\\$]*)\\$", false);
        }

        public int findEnd(int start) {
            this.startMatcher.find(start);
            String tag = this.startMatcher.group(1);
            int end = this.sql.indexOf("$" + tag + "$", start + tag.length() + 2);
            return end < 0 ? this.sql.length() - 1 : end + tag.length() + 1;
        }
    }

    public static class MultiLineCommentFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new MultiLineCommentFinder(sql);
            }
        };

        private MultiLineCommentFinder(String sql) {
            super(sql, "/\\*", "\\*/", 2, false, true);
        }
    }

    public static class SharpSingleLineCommentFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new SharpSingleLineCommentFinder(sql);
            }
        };

        private SharpSingleLineCommentFinder(String sql) {
            super(sql, "#", "(\\r)?\\n", 1, false, true);
        }
    }

    public static class SingleLineCommentFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new SingleLineCommentFinder(sql);
            }
        };

        private SingleLineCommentFinder(String sql) {
            super(sql, "--", "(\\r)?\\n", 2, false, true);
        }
    }

    public static class EscapedStringLiteralFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new EscapedStringLiteralFinder(sql);
            }
        };

        private EscapedStringLiteralFinder(String sql) {
            super(sql, "(e|E)'", "(?<!\\\\)(\\\\\\\\)*+'", 2, false, false);
        }
    }

    public static class BackslashEscapedDoubleQuotedFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new BackslashEscapedDoubleQuotedFinder(sql);
            }
        };

        private BackslashEscapedDoubleQuotedFinder(String sql) {
            super(sql, "\"", "(?<!\\\\)(\\\\\\\\)*+\"", 1, false, false);
        }
    }

    public static class BackslashEscapedSingleQuotedFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new BackslashEscapedSingleQuotedFinder(sql);
            }
        };

        private BackslashEscapedSingleQuotedFinder(String sql) {
            super(sql, "'", "(?<!\\\\)(\\\\\\\\)*+'", 1, false, false);
        }
    }

    public static class BackTickedNoEscapeFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new BackTickedNoEscapeFinder(sql);
            }
        };

        private BackTickedNoEscapeFinder(String sql) {
            super(sql, "`", "`", 1, false, false);
        }
    }

    public static class BracketedNoEscapeFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new BracketedNoEscapeFinder(sql);
            }
        };

        private BracketedNoEscapeFinder(String sql) {
            super(sql, "\\[", "([^\\]]|\\]\\])*\\]", 1, true, false);
        }
    }

    public static class DoubleQuotedNoEscapeFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new DoubleQuotedNoEscapeFinder(sql);
            }
        };

        private DoubleQuotedNoEscapeFinder(String sql) {
            super(sql, "\"", "\"", 1, false, false);
        }
    }

    public static class SingleQuotedNoEscapeFinder
    extends RegexQuotedPortionFinder {
        public static final QuotedPortionFinderFactory META = new QuotedPortionFinderFactory(){

            public QuotedPortionFinder build(String sql) {
                return new SingleQuotedNoEscapeFinder(sql);
            }
        };

        private SingleQuotedNoEscapeFinder(String sql) {
            super(sql, "'", "'", 1, false, false);
        }
    }

    private static abstract class RegexStartQuotedPortionFinder
    implements QuotedPortionFinder {
        protected final Matcher startMatcher;
        protected final String sql;
        private final boolean isComment;

        protected RegexStartQuotedPortionFinder(String sql, String startRegex, boolean isComment) {
            this.sql = sql;
            this.isComment = isComment;
            this.startMatcher = Pattern.compile(startRegex).matcher(sql);
        }

        public int findStart(int from) {
            if (this.startMatcher.find(from)) {
                return this.startMatcher.start();
            }
            return -1;
        }

        public int startSegmentLength(int from) {
            return this.startMatcher.end() - from;
        }

        public boolean findsComments() {
            return this.isComment;
        }
    }

    private static abstract class RegexQuotedPortionFinder
    implements QuotedPortionFinder {
        private final Matcher startMatcher;
        private final Matcher endMatcher;
        private final String sql;
        private final int offset;
        private final boolean endMatchFromAfterStart;
        private final boolean isComment;

        protected RegexQuotedPortionFinder(String sql, String startRegex, String endRegex, int offset, boolean endMatchFromAfterStart, boolean isComment) {
            this.sql = sql;
            this.offset = offset;
            this.endMatchFromAfterStart = endMatchFromAfterStart;
            this.isComment = isComment;
            this.startMatcher = Pattern.compile(startRegex).matcher(sql);
            this.endMatcher = Pattern.compile(endRegex).matcher(sql);
        }

        public int findStart(int from) {
            if (this.startMatcher.find(from)) {
                return this.startMatcher.start();
            }
            return -1;
        }

        public int startSegmentLength(int from) {
            return this.startMatcher.end() - from;
        }

        public int findEnd(int start) {
            if (this.endMatcher.find(start + this.offset)) {
                if (!this.endMatchFromAfterStart || this.endMatcher.start() == start + this.offset) {
                    return this.endMatcher.end() - 1;
                }
                return this.sql.length() - 1;
            }
            return this.sql.length() - 1;
        }

        public boolean findsComments() {
            return this.isComment;
        }
    }
}

