/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.httpsse;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.ExceptionUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class MiniSSEEmitter
implements AutoCloseable {
    private final HttpServletResponse resp;
    private final long throttle;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private ExceptionUtils.ThrowingRunnable<Exception> interruptCallback = null;
    private boolean interrupted = false;
    protected static Logger logger = Logger.getLogger((String)"dku.streaming.httpsse");

    public MiniSSEEmitter(HttpServletResponse resp, boolean sendEmptyChunk) {
        this(resp, DKUApp.getParams().getLongParam("dip.llm.stream.throttle.ms", 0L), sendEmptyChunk);
    }

    public MiniSSEEmitter(HttpServletResponse resp, long throttle, boolean sendEmptyChunk) {
        this.resp = resp;
        resp.setHeader("X-Accel-Buffering", "no");
        resp.setHeader("Content-type", "text/event-stream");
        this.throttle = throttle;
        if (sendEmptyChunk) {
            long emptyChunkPeriod = DKUApp.getParams().getLongParam("dku.llm.stream.emptyChunkPeriod.ms", 200L);
            this.executor.scheduleAtFixedRate(() -> this.sendEmptyChunk(resp), emptyChunkPeriod, emptyChunkPeriod, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void sendEmptyChunk(HttpServletResponse resp) {
        try {
            resp.getOutputStream().write("data: \n\n".getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().flush();
        }
        catch (IOException e) {
            try {
                if (this.interrupted) {
                    return;
                }
                this.interrupted = true;
                if (this.interruptCallback != null) {
                    this.interruptCallback.run();
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public synchronized void initSuccess() {
        this.resp.setContentType("text/event-stream");
    }

    public synchronized void setInterruptCallback(ExceptionUtils.ThrowingRunnable<Exception> interruptCallback) {
        assert (this.interruptCallback == null);
        this.interruptCallback = interruptCallback;
    }

    public synchronized void sendEventWithData(String eventType, String eventData, boolean urgent) throws Exception {
        block8: {
            try {
                if (eventType != null) {
                    this.resp.getOutputStream().write(("event: " + eventType + "\n").getBytes(StandardCharsets.UTF_8));
                }
                this.resp.getOutputStream().write(("data: " + eventData + "\n\n").getBytes(StandardCharsets.UTF_8));
                this.resp.getOutputStream().flush();
                if (urgent) {
                    this.resp.getOutputStream().write(":\n\n".getBytes(StandardCharsets.UTF_8));
                    this.resp.getOutputStream().flush();
                }
                if (this.throttle <= 0L) break block8;
                try {
                    Thread.sleep(this.throttle);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Interrupted while waiting for throttle", (Throwable)e);
                    throw e;
                }
            }
            catch (IOException e) {
                if (this.interrupted) {
                    return;
                }
                this.interrupted = true;
                if (this.interruptCallback != null) {
                    this.interruptCallback.run();
                }
                throw e;
            }
        }
    }

    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void close() throws Exception {
        this.executor.shutdown();
    }
}

