/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints.kafka;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.KafkaConnection;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.streaming.endpoints.Replayable;
import com.dataiku.dip.streaming.endpoints.RowWithTimestamp;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePuller;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatDeserializer;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaFormatsFactory;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaRecordedState;
import com.dataiku.dip.streaming.endpoints.kafka.KafkaStreamingEndpointParams;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.springframework.beans.factory.annotation.Autowired;

public class KafkaSimplePuller
implements StreamingEndpointSimplePuller,
Replayable {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    private final AuthCtx authCtx;
    private final KafkaStreamingEndpointParams params;
    private volatile boolean closed;
    private RowFactory rf;
    private KafkaConsumer<?, ?> kconsumer;
    private Column timestampColumn;
    private KafkaRecordedState currentState;
    private HashMap<Integer, Long> maxOffsets;
    private KafkaFormatDeserializer valueDeserializer;
    private KafkaFormatDeserializer keyDeserializer;
    private Set<TopicPartition> assigned;
    private Map<Integer, Long> endOffsets;
    private Map<Integer, Long> committedOffsets;
    private boolean hasPassedEndOffsets = false;
    private boolean hasPassedCommittedOffsets = false;
    private List<StashedRow> stashed = Lists.newArrayList();
    private List<StashedRow> rewind = Lists.newArrayList();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.streaming.endpoints.kafka.puller");

    public KafkaSimplePuller(AuthCtx authCtx, KafkaStreamingEndpointParams params) {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.params = params;
    }

    @Override
    public void init(ColumnFactory cf, RowFactory rf, Schema readSchema, JsonElement previousState) throws IOException, DKUSecurityException {
        this.rf = rf;
        KafkaConnection conn = (KafkaConnection)this.connectionsDAO.getConnection(this.authCtx, this.params.connection);
        this.valueDeserializer = KafkaFormatsFactory.getDeserializer(this.params.formatType, this.params.formatParams);
        this.keyDeserializer = KafkaFormatsFactory.getDeserializer(this.params.keyFormatType, this.params.keyFormatParams);
        assert (this.valueDeserializer != null);
        Properties props = conn.buildBasicProperties(this.authCtx, null);
        for (SimpleKeyValue simpleKeyValue : this.params.consumerParams.properties) {
            if (!StringUtils.isNotBlank((String)simpleKeyValue.key)) continue;
            props.put(simpleKeyValue.key, StringUtils.defaultIfEmpty((String)simpleKeyValue.value, (String)""));
        }
        this.timestampColumn = null;
        if (StringUtils.isNotBlank((String)this.params.timestampColumn)) {
            this.timestampColumn = cf.column(this.params.timestampColumn);
        }
        props.put("key.deserializer", this.keyDeserializer.getKafkaDeserializer());
        props.put("value.deserializer", this.valueDeserializer.getKafkaDeserializer());
        props.put("group.id", props.getProperty("group.id.prefix", "dss_consumer-") + System.currentTimeMillis());
        props.put("enable.auto.commit", "true");
        this.kconsumer = new KafkaConsumer(props);
        this.assigned = Sets.newHashSet();
        for (PartitionInfo partitionInfo : this.kconsumer.partitionsFor(this.params.topic)) {
            this.assigned.add(new TopicPartition(this.params.topic, partitionInfo.partition()));
        }
        this.kconsumer.assign(this.assigned);
        logger.info((Object)("Consumer was assigned partitions " + this.assigned.stream().map(t -> Integer.toString(t.partition())).collect(Collectors.joining(", "))));
        this.endOffsets = Maps.newHashMap();
        this.committedOffsets = Maps.newHashMap();
        for (Map.Entry entry : this.kconsumer.endOffsets(this.assigned).entrySet()) {
            this.endOffsets.put(((TopicPartition)entry.getKey()).partition(), (Long)entry.getValue());
        }
        for (TopicPartition topicPartition : this.assigned) {
            OffsetAndMetadata committed = this.kconsumer.committed(topicPartition);
            this.committedOffsets.put(topicPartition.partition(), committed != null ? committed.offset() : 0L);
        }
        logger.info((Object)("Current end offsets are " + this.endOffsets.entrySet().stream().map(o -> String.format("%d -> %d", o.getKey(), o.getValue())).collect(Collectors.joining(", "))));
        logger.info((Object)("Current committed offsets are " + this.committedOffsets.entrySet().stream().map(o -> String.format("%d -> %d", o.getKey(), o.getValue())).collect(Collectors.joining(", "))));
        this.keyDeserializer.init(cf, rf, readSchema);
        this.valueDeserializer.init(cf, rf, readSchema);
        logger.info((Object)"Setting up state");
        if (previousState != null) {
            logger.info((Object)("Seek to previous state " + JSON.json((Object)previousState)));
            this.seekTo(previousState);
        } else {
            logger.info((Object)"Don't seek (let consumer settings kick in)");
            this.currentState = new KafkaRecordedState();
            Iterator<Object> iterator = this.endOffsets.keySet().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                this.currentState.recordedOffsets.put(n, null);
            }
        }
        logger.info((Object)("Current state " + JSON.json((Object)this.currentState)));
        logger.info((Object)"Ready to dequeue");
    }

    @Override
    public void setLimit(JsonElement limit) {
        if (limit == Replayable.EOS) {
            logger.info((Object)"Set max offset to endOffsets");
            this.maxOffsets = Maps.newHashMap(this.endOffsets);
        } else if (limit != null) {
            logger.info((Object)("Set max offset to " + JSON.json((Object)limit)));
            this.maxOffsets = Maps.newHashMap(((KafkaRecordedState)JSON.parse((JsonElement)limit, KafkaRecordedState.class)).recordedOffsets);
        } else {
            logger.info((Object)"Unset max offset");
            this.maxOffsets = null;
        }
        this.rewind.addAll(this.stashed);
        this.stashed.clear();
    }

    public boolean hasPassedEndOffsets() {
        return this.hasPassedEndOffsets;
    }

    public boolean hasPassedCommittedOffsets() {
        return this.hasPassedCommittedOffsets;
    }

    @Override
    public JsonElement getCurrentOffsets() {
        return JSON.toJsonElement((Object)this.currentState);
    }

    @Override
    public void seekTo(JsonElement offsets) {
        if (offsets == Replayable.BOS || offsets == Replayable.EOS) {
            if (offsets == Replayable.BOS) {
                this.kconsumer.seekToBeginning(this.assigned);
            } else {
                this.kconsumer.seekToEnd(this.assigned);
            }
            this.currentState = new KafkaRecordedState();
            for (TopicPartition topicPartition : this.assigned) {
                logger.info((Object)("Initialized partition: " + topicPartition.partition()));
                this.currentState.recordedOffsets.put(topicPartition.partition(), this.kconsumer.position(topicPartition));
            }
        } else {
            this.currentState = (KafkaRecordedState)JSON.parse((JsonElement)offsets, KafkaRecordedState.class);
            for (Map.Entry<Integer, Long> krps : this.currentState.recordedOffsets.entrySet()) {
                logger.info((Object)("Initializing partition: " + String.valueOf(krps.getKey()) + " offset " + String.valueOf(krps.getValue())));
                this.kconsumer.seek(new TopicPartition(this.params.topic, krps.getKey().intValue()), krps.getValue().longValue());
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closed) {
            return;
        }
        this.closed = true;
    }

    @Override
    public StreamingEndpointSimplePuller.RowsPulled next() throws Exception {
        if (this.maxOffsets != null && !this.maxOffsets.isEmpty()) {
            logger.trace(() -> "compare " + JSON.json(this.currentState.recordedOffsets) + " to " + JSON.json(this.maxOffsets));
            if (this.compareOffsetsMap(this.currentState.recordedOffsets, this.maxOffsets) >= 0) {
                logger.info((Object)"Reached limit");
                return null;
            }
        }
        StreamingEndpointSimplePuller.RowsPulled pulled = new StreamingEndpointSimplePuller.RowsPulled();
        pulled.rows = Lists.newArrayList();
        if (!this.rewind.isEmpty()) {
            logger.info((Object)("Replaying " + this.rewind.size() + " already pulled records"));
            for (StashedRow stashedRow : this.rewind) {
                int partition = stashedRow.partition;
                long offset = stashedRow.offset;
                Row row = stashedRow.row;
                if (this.maxOffsets != null && this.maxOffsets.containsKey(partition) && offset >= this.maxOffsets.get(partition)) {
                    this.stashed.add(stashedRow);
                    continue;
                }
                pulled.rows.add(row);
                this.currentState.recordedOffsets.put(partition, offset + 1L);
            }
            this.rewind.clear();
        }
        if (pulled.rows.isEmpty()) {
            ConsumerRecords records = this.kconsumer.poll(1000L);
            if (this.closed) {
                throw new Exception("Producer closed");
            }
            for (ConsumerRecord record : records) {
                if (this.params.consumerParams.ignoreTombstones && record.value() == null) {
                    logger.infoV("Ignoring tombstone record, offset %s", new Object[]{record.offset()});
                    continue;
                }
                int partition = record.partition();
                long offset = record.offset();
                Row row = this.rf.row();
                this.keyDeserializer.deserialize(record.key(), row);
                this.valueDeserializer.deserialize(record.value(), row);
                if (this.timestampColumn != null) {
                    row.put(this.timestampColumn, DKUDateUtils.isoFormatUTC((long)record.timestamp()));
                }
                if (row instanceof RowWithTimestamp) {
                    ((RowWithTimestamp)row).putTimestamp(record.timestamp());
                }
                if (logger.isTraceEnabled()) {
                    logger.traceV("Process record p=%s offset=%d key=%s", new Object[]{partition, offset, record.key()});
                }
                if (this.maxOffsets != null && this.maxOffsets.containsKey(partition) && offset >= this.maxOffsets.get(partition)) {
                    StashedRow stashedRow = new StashedRow();
                    stashedRow.offset = offset;
                    stashedRow.partition = partition;
                    stashedRow.row = row;
                    this.stashed.add(stashedRow);
                    continue;
                }
                pulled.rows.add(row);
                this.currentState.recordedOffsets.put(partition, offset + 1L);
            }
        }
        if (!this.hasPassedEndOffsets) {
            int passedOffsets = this.countOffsetsAfter(this.currentState.recordedOffsets, this.endOffsets);
            logger.trace(() -> "passed " + passedOffsets + " end offsets " + this.currentState.recordedOffsets.entrySet().stream().map(e -> String.format("%d -> %d", e.getKey(), e.getValue())).collect(Collectors.joining(", ")));
            if (passedOffsets == this.endOffsets.size()) {
                this.hasPassedEndOffsets = true;
            }
        }
        if (!this.hasPassedCommittedOffsets) {
            int passedOffsets = this.countOffsetsAfter(this.currentState.recordedOffsets, this.committedOffsets);
            logger.trace(() -> "passed " + passedOffsets + " committed offsets " + this.currentState.recordedOffsets.entrySet().stream().map(e -> String.format("%d -> %d", e.getKey(), e.getValue())).collect(Collectors.joining(", ")));
            if (passedOffsets == this.committedOffsets.size()) {
                this.hasPassedCommittedOffsets = true;
            }
        }
        pulled.state = JSON.toJsonElement((Object)this.currentState);
        pulled.ack = null;
        return pulled;
    }

    @Override
    public int compareOffsets(JsonElement a, JsonElement b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Map<Integer, Long> aS = ((KafkaRecordedState)JSON.parse((JsonElement)a, KafkaRecordedState.class)).recordedOffsets;
        Map<Integer, Long> bS = ((KafkaRecordedState)JSON.parse((JsonElement)b, KafkaRecordedState.class)).recordedOffsets;
        return this.compareOffsetsMap(aS, bS);
    }

    private int compareOffsetsMap(Map<Integer, Long> aS, Map<Integer, Long> bS) {
        int aBeforeB = 0;
        int bBeforeA = 0;
        Sets.SetView partitions = Sets.union(aS.keySet(), bS.keySet());
        Iterator iterator = partitions.iterator();
        while (iterator.hasNext()) {
            int p = (Integer)iterator.next();
            if (aS.containsKey(p)) {
                if (bS.containsKey(p)) {
                    long cmp = aS.get(p) - bS.get(p);
                    if (cmp < 0L) {
                        ++aBeforeB;
                        continue;
                    }
                    if (cmp <= 0L) continue;
                    ++bBeforeA;
                    continue;
                }
                ++bBeforeA;
                continue;
            }
            if (!bS.containsKey(p)) continue;
            ++aBeforeB;
        }
        if (aBeforeB > 0 && bBeforeA == 0) {
            return -1;
        }
        if (aBeforeB == 0 && bBeforeA > 0) {
            return 1;
        }
        if (aBeforeB > 0 && bBeforeA > 0) {
            return 0;
        }
        return 0;
    }

    private int countOffsetsAfter(Map<Integer, Long> offsets, Map<Integer, Long> limit) {
        int passedOffsets = 0;
        for (Map.Entry<Integer, Long> e : limit.entrySet()) {
            Long o = offsets.get(e.getKey());
            if (e.getValue() != null && (o == null || o < e.getValue())) continue;
            ++passedOffsets;
        }
        return passedOffsets;
    }

    private class StashedRow {
        public Row row;
        public int partition;
        public long offset;

        private StashedRow() {
        }
    }
}

