/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringPaths;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringProxySMV;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringDesignCRUDService {
    private final DKULogger logger = DKULogger.getLogger((String)"dku.services.unifiedMonitoringDesignCRUDService");

    public void save(List<UnifiedMonitoringProxySMV> unifiedMonitoringProxySMVS) throws IOException {
        this.logger.infoV("Creating a listing of proxy model versions for unified monitoring : %s", new Object[]{unifiedMonitoringProxySMVS.stream().map(smv -> smv.fullModelId.toString()).collect(Collectors.toList())});
        JSON.prettyToFile(unifiedMonitoringProxySMVS, (File)UnifiedMonitoringPaths.getCachedProxyModelVersionsList());
    }

    public void deleteProxyModelVersionListing(FullModelId fullModelId) throws IOException {
        Preconditions.checkNotNull((Object)fullModelId, (Object)"The full model id can not be null");
        File proxyModelListFiles = UnifiedMonitoringPaths.getCachedProxyModelVersionsList();
        if (!proxyModelListFiles.exists() || !proxyModelListFiles.isFile()) {
            throw new IllegalArgumentException(String.format("The proxy model was not listed %s", fullModelId));
        }
        List proxyModels = (List)JSON.parseFile((File)proxyModelListFiles, (TypeToken)new TypeToken<List<UnifiedMonitoringProxySMV>>(){});
        this.save(proxyModels.stream().filter(pm -> !fullModelId.equals(pm.fullModelId)).collect(Collectors.toList()));
        this.logger.infoV("The proxy model version has been deleted from the unified monitoring listing : %s", new Object[]{fullModelId.toString()});
    }

    public List<UnifiedMonitoringProxySMV> getCachedProxyModelVersionsList() throws IOException {
        File proxyModelVersionsFile = UnifiedMonitoringPaths.getCachedProxyModelVersionsList();
        if (proxyModelVersionsFile.exists() && proxyModelVersionsFile.isFile()) {
            return (List)JSON.parseFile((File)proxyModelVersionsFile, (TypeToken)new TypeToken<List<UnifiedMonitoringProxySMV>>(){});
        }
        return Collections.emptyList();
    }
}

