/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.unifiedmonitoring;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.KernelsModelEvaluationStoresService;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.MesMonitoringStatus;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringModelStatusCRUDService;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnifiedMonitoringModelStatusComputationService {
    @Autowired
    private KernelsModelEvaluationStoresService kernelsModelEvaluationStoresService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    protected UnifiedMonitoringModelStatusCRUDService unifiedMonitoringModelStatusCRUDService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    private final DKULogger logger = DKULogger.getLogger((String)"dku.services.unifiedMonitoringModelStatusService");

    public ModelStatus getOrComputeModelStatus(String projectKey, FullModelId fullModelId, @Nullable List<String> mesToFilterOn) throws Exception {
        if (!fullModelId.exists()) {
            throw new NotFoundException(String.format("Saved Model Version %s does not exist", fullModelId));
        }
        try {
            return this.unifiedMonitoringModelStatusCRUDService.getModelStatus(projectKey, fullModelId.toString(), mesToFilterOn);
        }
        catch (NotFoundException e) {
            this.logger.infoV("Model status not found for project %s and Saved Model Version %s, computing it", new Object[]{projectKey, fullModelId});
            ModelStatus modelStatus = this.computeAndSaveModelStatus(projectKey, fullModelId);
            if (mesToFilterOn != null) {
                modelStatus.mesMonitoringStatuses = modelStatus.mesMonitoringStatuses.stream().filter(mesMonitoringStatus -> mesToFilterOn.contains(mesMonitoringStatus.id)).collect(Collectors.toList());
            }
            return modelStatus;
        }
    }

    private ModelStatus computeAndSaveModelStatus(String projectKey, FullModelId fullModelId) throws Exception {
        List recipes;
        try (Transaction t = this.transactionService.beginRead();){
            recipes = this.recipesDAO.listUnsafe(projectKey);
        }
        List mesIds = recipes.stream().filter(recipe -> recipe.type.equals("evaluation")).filter(recipe -> recipe.getInputsForRole((String)"model").get((int)0).ref.equals(fullModelId.getSavedModelID())).filter(recipe -> !recipe.getOutputsForRole("evaluationStore").isEmpty()).map(recipe -> recipe.getOutputsForRole((String)"evaluationStore").get((int)0).ref).collect(Collectors.toList());
        ModelStatus modelStatus = new ModelStatus(fullModelId.toString());
        modelStatus.savedModelId = fullModelId.getSavedModelID();
        try {
            NavigatorService.SavedModelFullInfo info = new NavigatorService.SavedModelFullInfo();
            try (Transaction t = this.transactionService.beginRead();){
                info.model = (SavedModel)this.savedModelsDAO.getMandatoryUnsafe(projectKey, modelStatus.savedModelId);
            }
            modelStatus.savedModelName = info.model == null ? fullModelId.getSavedModelID() + " / " + fullModelId.getSavedModelVersionID() : info.model.name + " / " + fullModelId.getSavedModelVersionID();
        }
        catch (IOException e) {
            this.logger.infoV("Unable to retrieve %s display name: %s", new Object[]{fullModelId.toString(), e.getMessage()});
        }
        if (mesIds.isEmpty()) {
            this.logger.infoV("No MES found for Saved Model Version %s", new Object[]{fullModelId});
            return modelStatus;
        }
        this.logger.infoV("Found %d MES for Saved Model Version %s: %s", new Object[]{mesIds.size(), fullModelId, mesIds});
        for (String mesId : mesIds) {
            MesMonitoringStatus mesMonitoringStatus = this.computeMesMonitoringStatus(projectKey, fullModelId, mesId);
            modelStatus.mesMonitoringStatuses.add(mesMonitoringStatus);
        }
        this.unifiedMonitoringModelStatusCRUDService.saveModelStatus(projectKey, modelStatus);
        return modelStatus;
    }

    private MesMonitoringStatus computeMesMonitoringStatus(String projectKey, FullModelId fullModelId, String mesId) throws Exception {
        ModelEvaluationStore mes;
        this.logger.infoV("Computing monitoring status for project %s, Saved Model Version %s and MES %s", new Object[]{projectKey, fullModelId, mesId});
        try (Transaction t = this.transactionService.beginRead();){
            mes = this.kernelsModelEvaluationStoresService.getMandatory(projectKey, mesId);
        }
        Map<String, Long> smvEvaluationsToTimestamps = this.kernelsModelEvaluationStoresService.listEvaluations(mes).stream().filter(AbstractModelEvaluation::isTabular).map(evaluation -> (TabularModelEvaluation)evaluation).filter(evaluation -> evaluation.modelRef != null && evaluation.modelRef.getSavedModelVersionID() != null).filter(evaluation -> evaluation.modelRef.getSavedModelVersionID().equals(fullModelId.getSavedModelVersionID())).collect(Collectors.toMap(evaluation -> evaluation.ref.evaluationId, evaluation -> evaluation.created));
        MesMonitoringStatus mesMonitoringStatus = new MesMonitoringStatus(mesId);
        mesMonitoringStatus.mesName = mes.getDisplayName();
        if (smvEvaluationsToTimestamps.isEmpty()) {
            this.logger.infoV("No evaluation found for MES %s and Saved Model Version %s", new Object[]{mes.id, fullModelId});
            mesMonitoringStatus.timestamp = System.currentTimeMillis();
            return mesMonitoringStatus;
        }
        this.logger.infoV("Found %s evaluations for MES %s and Saved Model Version %s", new Object[]{smvEvaluationsToTimestamps.size(), mes.id, fullModelId.getSavedModelVersionID()});
        List<MetricsService.ComputedCheck> mesChecks = this.getChecks(mes);
        for (MetricsService.ComputedCheck check : mesChecks) {
            MetricsService.ComputedCheckPartition lastCheckOnSmv = check.lastValues.stream().filter(lastValue -> smvEvaluationsToTimestamps.containsKey(lastValue.partition)).max(Comparator.comparingLong(lastValue -> (Long)smvEvaluationsToTimestamps.get(lastValue.partition))).orElse(null);
            if (lastCheckOnSmv == null) {
                this.logger.infoV("No runs of check %s found for MES %s and Saved Model Version %s", new Object[]{check.meta.label, mes.id, fullModelId});
                continue;
            }
            boolean hasMoreRecentRunOnDifferentVersion = false;
            Long latestCheckTimestamp = check.lastValues.stream().map(value -> value.computed).max(Comparator.naturalOrder()).orElse(null);
            if (!Objects.equals(latestCheckTimestamp, lastCheckOnSmv.computed)) {
                hasMoreRecentRunOnDifferentVersion = true;
            }
            this.logger.infoV("The last run of check %s in MES %s for Saved Model Version %s has outcome %s", new Object[]{check.meta.label, mes.id, fullModelId, lastCheckOnSmv.outcome});
            MesMonitoringStatus.CheckInfo checkInfo = new MesMonitoringStatus.CheckInfo(lastCheckOnSmv.message, lastCheckOnSmv.computed, hasMoreRecentRunOnDifferentVersion);
            switch (lastCheckOnSmv.outcome) {
                case OK: {
                    mesMonitoringStatus.successes.put(check.meta.label, checkInfo);
                    break;
                }
                case WARNING: {
                    mesMonitoringStatus.warnings.put(check.meta.label, checkInfo);
                    break;
                }
                case ERROR: {
                    mesMonitoringStatus.errors.put(check.meta.label, checkInfo);
                    break;
                }
            }
        }
        mesMonitoringStatus.latestCheckTimestamp = mesMonitoringStatus.computeLatestCheckTimestamp();
        mesMonitoringStatus.timestamp = System.currentTimeMillis();
        return mesMonitoringStatus;
    }

    private void computeAndSaveMesMonitoringStatus(String projectKey, FullModelId fullModelId, String mesId) throws Exception {
        MesMonitoringStatus mesMonitoringStatus = this.computeMesMonitoringStatus(projectKey, fullModelId, mesId);
        this.unifiedMonitoringModelStatusCRUDService.saveMesMonitoringStatus(projectKey, fullModelId.toString(), mesMonitoringStatus);
    }

    private List<MetricsService.ComputedCheck> getChecks(ModelEvaluationStore mes) throws Exception {
        List mesCheckLabels = mes.metricsChecks.checks.stream().map(check -> check.meta.label).collect(Collectors.toList());
        return this.metricsService.listComputedChecks_NT((Object)mes, (MetricTargetType)MetricTargetType.MODEL_EVALUATION_STORE, null, (boolean)true).checks.stream().filter(check -> check.meta.label != null).filter(check -> mesCheckLabels.contains(check.meta.label)).collect(Collectors.toList());
    }

    public void updateOrCreateMesMonitoringStatus(String projectKey, String mesId, FullModelId fullModelId, Map<String, AbstractCheckContext.CheckResult> checkResults, Long mesUpdateTimestamp) throws Exception {
        File mesMonitoringFile = this.unifiedMonitoringModelStatusCRUDService.getMesMonitoringFile(projectKey, fullModelId.toString(), mesId);
        if (!mesMonitoringFile.exists()) {
            this.logger.infoV("No monitoring found for SMV %s and MES %s, computing it", new Object[]{fullModelId, mesId});
            this.computeAndSaveMesMonitoringStatus(projectKey, fullModelId, mesId);
        } else {
            this.logger.infoV("Updating monitoring status for SMV %s and MES %s", new Object[]{fullModelId, mesId});
            MesMonitoringStatus mesMonitoringStatus = MesMonitoringStatus.readMonitoringStatus(mesMonitoringFile);
            mesMonitoringStatus.applyCheckResults(checkResults, mesUpdateTimestamp);
            this.unifiedMonitoringModelStatusCRUDService.saveMesMonitoringStatus(projectKey, fullModelId.toString(), mesMonitoringStatus);
        }
        this.updateMonitoringStatusesWithHasMoreRecentRunOnDifferentSMV(projectKey, mesId, fullModelId.toString(), checkResults.keySet());
    }

    public void deleteChecksFromMonitorings(String projectKey, String mesId, List<String> deletedCheckLabels) throws IOException {
        List<File> mesFiles = this.unifiedMonitoringModelStatusCRUDService.getMesFiles(mesId);
        Predicate<Map.Entry> filter = labelToInfo -> {
            String checkLabel = (String)labelToInfo.getKey();
            return deletedCheckLabels.contains(checkLabel);
        };
        for (File mesFile : mesFiles) {
            String fullModelId = mesFile.getParentFile().getName();
            this.logger.infoV("Deleting checks %s from monitoring of project %s, Saved Model Version %s and MES %s", new Object[]{deletedCheckLabels, projectKey, fullModelId, mesId});
            MesMonitoringStatus mesMonitoringStatus = MesMonitoringStatus.readMonitoringStatus(mesFile);
            mesMonitoringStatus.successes.entrySet().removeIf(filter);
            mesMonitoringStatus.warnings.entrySet().removeIf(filter);
            mesMonitoringStatus.errors.entrySet().removeIf(filter);
            mesMonitoringStatus.latestCheckTimestamp = mesMonitoringStatus.computeLatestCheckTimestamp();
            mesMonitoringStatus.timestamp = System.currentTimeMillis();
            this.unifiedMonitoringModelStatusCRUDService.saveMesMonitoringStatus(projectKey, fullModelId, mesMonitoringStatus);
        }
    }

    private void updateMonitoringStatusesWithHasMoreRecentRunOnDifferentSMV(String projectKey, String mesId, String latestSmvIdEvaluated, Collection<String> checkLabels) throws IOException {
        List<File> mesFiles = this.unifiedMonitoringModelStatusCRUDService.getMesFiles(mesId);
        for (File mesFile : mesFiles) {
            String fullModelId = mesFile.getParentFile().getName();
            if (fullModelId.equals(latestSmvIdEvaluated)) continue;
            MesMonitoringStatus mesMonitoringStatus = MesMonitoringStatus.readMonitoringStatus(mesFile);
            this.updateHasMoreRecentRunOnDifferentSMV(mesMonitoringStatus.successes, checkLabels);
            this.updateHasMoreRecentRunOnDifferentSMV(mesMonitoringStatus.warnings, checkLabels);
            this.updateHasMoreRecentRunOnDifferentSMV(mesMonitoringStatus.errors, checkLabels);
            this.unifiedMonitoringModelStatusCRUDService.saveMesMonitoringStatus(projectKey, fullModelId, mesMonitoringStatus);
        }
    }

    private void updateHasMoreRecentRunOnDifferentSMV(Map<String, MesMonitoringStatus.CheckInfo> checkMap, Collection<String> checkLabels) {
        for (String label : checkLabels) {
            MesMonitoringStatus.CheckInfo check = checkMap.getOrDefault(label, null);
            if (check == null) continue;
            check.hasMoreRecentRunOnDifferentSMV = true;
            checkMap.put(label, check);
        }
    }

    public void purgeMesFromModelStatuses(String mesId) throws IOException {
        this.unifiedMonitoringModelStatusCRUDService.deleteMesMonitorings(mesId);
    }

    public void updateMesDisplayNameInModelStatuses(String mesId, String newDisplayName) throws IOException {
        this.unifiedMonitoringModelStatusCRUDService.getMesFiles(mesId).forEach(mesFile -> {
            try {
                MesMonitoringStatus mesMonitoringStatus = MesMonitoringStatus.readMonitoringStatus(mesFile);
                mesMonitoringStatus.mesName = newDisplayName;
                this.unifiedMonitoringModelStatusCRUDService.saveMesMonitoringStatus((File)mesFile, mesMonitoringStatus);
            }
            catch (IOException e) {
                this.logger.warnV((Throwable)e, "Could not update the display name of MES %s in monitoring status %s", new Object[]{mesId, mesFile.getAbsolutePath()});
            }
        });
    }
}

