/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.IOException;

public class LibreOfficeUtil {
    private static final DKULogger logger = DKULogger.getLogger(LibreOfficeUtil.class);

    public static boolean hasLibreOfficeBin() {
        logger.info((Object)"Checking if Libreoffice bin is available");
        try {
            int exit_code = DKUtils.execAndLog((String[])new String[]{"which", "soffice"}, null);
            if (exit_code != 0) {
                logger.info((Object)"Libreoffice is not installed, or is not available");
                return false;
            }
            exit_code = DKUtils.execAndLog((String[])new String[]{"soffice", "--headless", "--version", "--nologo", "--nolockcheck"}, null);
            if (exit_code != 0) {
                logger.info((Object)"Libreoffice is not installed, or is not available");
                return false;
            }
        }
        catch (IOException e) {
            logger.error((Object)"Failed to check if Libreoffice is installed", (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        logger.info((Object)"Libreoffice is installed and available");
        return true;
    }
}

