/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.standard;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.WebAppTemplate;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractStandardWebAppHandler
extends WebAppHandler {
    @Autowired
    protected VariablesService variablesService;
    @Autowired
    protected PublicAPIKeysService publicAPIKeysService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    protected StandardWebAppMeta.StandardWebAppParams params;
    static DKULogger logger = DKULogger.getLogger((String)"dku.webapps.standard");

    public AbstractStandardWebAppHandler(WebApp webapp) {
        this.webapp = webapp;
        this.params = webapp.getParamsAs(StandardWebAppMeta.StandardWebAppParams.class);
        SpringUtils.getInstance().autowire((Object)this);
    }

    protected void initApiKey(List<String> datasets) throws IOException {
        ProjectScopePublicAPIKey psKey = new ProjectScopePublicAPIKey(this.webapp.projectKey);
        psKey.label = "Key for Web app " + this.webapp.name + "(" + this.webapp.id + ")";
        psKey.onBehalf = this.webapp.id;
        if (datasets != null) {
            ProjectScopePublicAPIKey.LocalDatasetPrivilege dsp = new ProjectScopePublicAPIKey.LocalDatasetPrivilege();
            dsp.datasets = datasets;
            dsp.privileges.add(Privileges.DatasetLevelPrivilegeType.READ_DATA);
            dsp.privileges.add(Privileges.DatasetLevelPrivilegeType.READ_METADATA);
            dsp.privileges.add(Privileges.DatasetLevelPrivilegeType.READ_SCHEMA);
            psKey.getLocalDatasetPrivileges().add(dsp);
        }
        psKey = this.publicAPIKeysService.createProjectAPIKey(psKey);
        this.webapp.apiKey = this.passwordEncryptionService.encryptIfNotEncryptedOrEmpty(psKey.key);
    }

    @Override
    public boolean backendReady(WebAppBackendInstance.BackendState currentState, int requestTimeout) {
        if (currentState == null || !currentState.hasExposedEndpoint) {
            return false;
        }
        try {
            WebAppBackend backend = this.backendsManager.getBackendOrNull(this.webapp.projectKey, this.webapp.id);
            if (backend == null) {
                throw ErrorContext.iaef((String)"Backend not registered for webapp %s.%s", (Object)this.webapp.projectKey, (Object[])new Object[]{this.webapp.id});
            }
            int code = backend.probeBackend((int)requestTimeout).code;
            return code == 200 || code == 401;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getBaseHref() {
        return "/";
    }

    @Override
    public String getHtml(int requestTimeout) throws IOException {
        return this.getHtmlAndDeps((boolean)false).html;
    }

    public HtmlAndDeps getHtmlAndDeps(boolean forDirectAccess) throws IOException {
        HtmlAndDeps htmlAndDeps = new HtmlAndDeps();
        String js = this.params.enableJavascriptModules ? "<script type=\"module\" id=\"dku_js\">%s</script>" : "<script id=\"dku_js\">(function(){  %s}  )()</script>";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("html", this.params.html);
        map.put("css", this.params.css);
        map.put("js", String.format(js, this.params.js));
        List<SimpleKeyValue> libraries = this.buildLibrariesCode(forDirectAccess);
        ArrayList librariesMarkup = Lists.newArrayList();
        for (SimpleKeyValue library : libraries) {
            librariesMarkup.add(library.value);
            htmlAndDeps.installDirDeps.add(library.key);
        }
        htmlAndDeps.installDirDeps.add("/static/dataiku/fonts/");
        htmlAndDeps.installDirDeps.add("/static/public/");
        htmlAndDeps.dataDirDeps.add("/local/static/");
        map.put("libraries", Joiner.on((String)"\n").join((Iterable)librariesMarkup));
        map.put("title", this.webapp.name);
        map.put("apiKey", this.passwordEncryptionService.decryptIfEncrypted(this.webapp.apiKey));
        map.put("projectKey", this.webapp.projectKey);
        map.put("webAppConfig", this.params.hideWebAppConfig ? "{}" : JSON.pretty((Object)this.webapp.config));
        if (forDirectAccess) {
            map.put("baseHref", "");
        } else {
            map.put("baseHref", "<base href=" + this.getBaseHref() + ">");
        }
        if (forDirectAccess) {
            map.put("backendUrlPrefix", "");
        } else {
            WebAppBackend backend = this.backendsManager.getBackendOrNull(this.webapp.projectKey, this.webapp.id);
            if (backend != null) {
                map.put("backendUrlPrefix", backend.getBackendUrl());
            }
        }
        map.put("webAppDesc", JSON.pretty((Object)WebAppRegistry.getMeta(this.webapp.type).getWebAppDesc()));
        String template = DKUtils.getResourceFileContentUTF8((String)"com/dataiku/dip/webapps/standard/standard-webapp-template.html");
        htmlAndDeps.html = StrSubstitutor.replace((Object)template, map);
        return htmlAndDeps;
    }

    private List<SimpleKeyValue> buildLibrariesCode(boolean forDirectAccess) {
        ArrayList ret = Lists.newArrayList();
        if (this.params.libraries != null && !this.params.libraries.isEmpty()) {
            for (WebAppTemplate.JavaScriptLibrary lib : EnumSet.copyOf(this.params.libraries)) {
                if (lib.jsHref != null) {
                    ret.add(new SimpleKeyValue(lib.jsHref, "<script type=\"text/javascript\" src=\"" + this.prepareHref(forDirectAccess, lib.jsHref) + "\"></script>"));
                }
                if (lib.cssHref == null) continue;
                ret.add(new SimpleKeyValue(lib.cssHref, "<link rel=\"stylesheet\" href=\"" + this.prepareHref(forDirectAccess, lib.cssHref) + "\" />"));
            }
        }
        return ret;
    }

    private String prepareHref(boolean forDirectAccess, String href) {
        if (forDirectAccess && href.startsWith("/")) {
            href = href.substring(1);
        }
        return href;
    }

    public void prepareDepsFolder(HtmlAndDeps htmlAndDeps, List<String> depsPaths, File folder) throws IOException {
        File target;
        File file;
        Object[] depChunks;
        ArrayList chunks;
        DKUFileUtils.mkdirs((File)folder);
        ArrayList copies = Lists.newArrayList();
        for (String dep : htmlAndDeps.installDirDeps) {
            chunks = Lists.newArrayList();
            if ("1".equals(System.getenv("DSS_DEV"))) {
                chunks.add("src");
                chunks.add("main");
                chunks.add("platypus");
            } else {
                chunks.add("frontend");
            }
            dep = PathUtils.makeNotLeadingNoTrailing((String)dep);
            depChunks = dep.split("/");
            chunks.addAll(Lists.newArrayList((Object[])depChunks));
            file = ApplicationConfigurator.getInstallFile((String[])chunks.toArray(new String[0]));
            target = DKUFileUtils.getWithin((File)folder, (String[])depChunks);
            copies.add(new Pair((Object)file, (Object)target));
        }
        for (String dep : htmlAndDeps.dataDirDeps) {
            chunks = Lists.newArrayList();
            dep = PathUtils.makeNotLeadingNoTrailing((String)dep);
            depChunks = dep.split("/");
            chunks.addAll(Lists.newArrayList((Object[])depChunks));
            file = ApplicationConfigurator.getFile((String[])chunks.toArray(new String[0]));
            target = DKUFileUtils.getWithin((File)folder, (String[])depChunks);
            copies.add(new Pair((Object)file, (Object)target));
        }
        for (Pair copy : copies) {
            File file2 = (File)copy.first;
            File target2 = (File)copy.second;
            if (!file2.exists()) {
                logger.warn((Object)("Dependency " + file2.getAbsolutePath() + " not found"));
                continue;
            }
            if (file2.isFile()) {
                logger.info((Object)("Copying file dependency " + file2.getAbsolutePath()));
                FileUtils.copyFile((File)file2, (File)target2);
                continue;
            }
            if (file2.isDirectory()) {
                logger.info((Object)("Copying folder dependency " + file2.getAbsolutePath()));
                DKUFileUtils.copyDirectory((File)file2, (File)target2, EnumSet.of(DKUFileUtils.CopyDirectoryFlags.ExcludeGitFolder), (FileFilter[])new FileFilter[0]);
                continue;
            }
            logger.warn((Object)("Dependency " + file2.getAbsolutePath() + " is not a file or dir"));
        }
        depsPaths.addAll(htmlAndDeps.installDirDeps);
        depsPaths.addAll(htmlAndDeps.dataDirDeps);
    }

    public static class HtmlAndDeps {
        public String html;
        public List<String> installDirDeps = Lists.newArrayList();
        public List<String> dataDirDeps = Lists.newArrayList();
    }
}

