/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.wikis;

import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.FileFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.wikis.Article;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.dataiku.dip.wikis.ArticlesDAO;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedArticlesDAO
extends AbstractStandardDAO<Article>
implements ArticlesDAO {
    @Autowired
    ArticlesCacheService articlesCacheService;

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.ARTICLE.toHumanReadableString();
    }

    @Override
    protected Article getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        RelFile articleFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(articleFile = this.getDAOFile(projectKey, id))) {
            return null;
        }
        Article article = unsafe ? (Article)t.readObjectUnsafe(articleFile, Article.class) : (Article)t.readObject(articleFile, Article.class);
        article.id = id;
        article.projectKey = projectKey;
        return article;
    }

    @Override
    public String getPayloadOrNull(String projectKey, String id) throws IOException {
        RelFile payloadFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isFile(payloadFile = this.getPayloadFile(projectKey, id))) {
            return null;
        }
        return t.readStringUTF8(payloadFile);
    }

    @Override
    public void save(Article article, String payload) throws IOException {
        super.save(article);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (payload != null) {
            RelFile payloadFile = this.getPayloadFile(article.projectKey, article.id);
            t.writeStringUTF8(payloadFile, payload);
        }
        this.articlesCacheService.putNameMapping(article.projectKey, article.id, article.name);
    }

    @Override
    protected List<Article> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<Article> ret = new ArrayList<Article>();
        RelFile articlesFolder = this.getArticlesFolder(projectKey);
        if (!t.exists(articlesFolder)) {
            return ret;
        }
        for (RelFile file : t.listFiles(articlesFolder, (RelFileFilter)FileFilter.json())) {
            try {
                String id = StringUtils.removeEnd((String)file.getLeafName(), (String)".json");
                Article article = unsafe ? (Article)t.readObjectUnsafe(file, Article.class) : (Article)t.readObject(file, Article.class);
                article.id = id;
                article.projectKey = projectKey;
                ret.add(article);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to read article file " + String.valueOf(file) + ": " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile articlesFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(articlesFolder = this.getArticlesFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(articlesFolder, (RelFileFilter)FileFilter.json()).size();
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RelFile file;
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.isFile(file = this.getDAOFile(projectKey, id))) {
            throw new NotFoundException("Article does not exist: " + projectKey + "." + id);
        }
        t.deleteFile(file);
        RelFile payloadFile = this.getPayloadFile(projectKey, id);
        if (t.isFile(payloadFile)) {
            t.deleteFile(payloadFile);
        }
        this.articlesCacheService.removeNameMapping(projectKey, id);
    }

    private RelFile getPayloadFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Article id is not specified");
        return new RelFile(this.getArticlesFolder(projectKey), new String[]{id + ".md"});
    }

    private RelFile getArticlesFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Article project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "wiki", "articles"});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Article id is not specified");
        return new RelFile(this.getArticlesFolder(projectKey), new String[]{id + ".json"});
    }
}

