/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Control;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.ast.VariableExpr;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectFilter
implements Control {
    @Override
    public String checkArguments(Evaluable[] args) {
        if (args.length != 4) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects 4 arguments";
        }
        if (!(args[1] instanceof VariableExpr)) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects second argument to be a variable name";
        }
        if (!(args[2] instanceof VariableExpr)) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects third argument to be a variable name";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(Properties bindings, Evaluable[] args) {
        Object prev = args[0].evaluate(bindings);
        if (ExpressionUtils.isError(prev)) {
            return prev;
        }
        if (prev == null) {
            return null;
        }
        JSONObject prevObj = DKUFormulaUtils.asJSONObject(prev);
        String keyName = ((VariableExpr)args[1]).getName();
        String valueName = ((VariableExpr)args[2]).getName();
        Object oldKeyValue = bindings.get(keyName);
        Object oldValueValue = bindings.get(valueName);
        try {
            JSONObject out = new JSONObject();
            Iterator it = prevObj.keys();
            while (it.hasNext()) {
                Object k = it.next();
                Object v = prevObj.get(k.toString());
                bindings.put(keyName, k);
                bindings.put(valueName, v);
                Object r = args[3].evaluate(bindings);
                if (!(r instanceof Boolean) || !((Boolean)r).booleanValue()) continue;
                out.put(k.toString(), v);
            }
            JSONObject jSONObject = out;
            return jSONObject;
        }
        catch (JSONException e) {
            EvalError evalError = new EvalError(GrelControlFunctionRegistry.getInstance().getControlName(this) + " error: " + e.getMessage());
            return evalError;
        }
        finally {
            if (oldKeyValue != null) {
                bindings.put(keyName, oldKeyValue);
            } else {
                bindings.remove(keyName);
            }
            if (oldValueValue != null) {
                bindings.put(valueName, oldValueValue);
            } else {
                bindings.remove(valueName);
            }
        }
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ObjectFilter.DOCUMENTATION", "Evaluates expression a to an object. Then for each element (k, v) of this object, binds its key to variable name k, its value to variable name v, evaluates expression test which should return a boolean. If the boolean is true, pushes (k, v) onto the result object.").withParams("expression a, variable k, variable v, expression test").withReturns("object").withCategory("GREL.FUNCTIONS.CATEGORY.CONTROL_STRUCTURES", "Control structures").withExample(Example.with("'{\"fName\":\"Joe\", \"lName\":\"Smith\", \"age\":42 }'", "k", "v", "k.contains(\"Name\")").returns("{\"fName\":\"Joe\",\"lName\":\"Smith\"}"));
    }
}

