/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectNew
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        JSONObject obj = new JSONObject();
        try {
            if (args.length % 2 == 1) {
                return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects an even number of arguments");
            }
            for (int i = 0; i < args.length; i += 2) {
                Object k = args[i];
                Object v = args[i + 1];
                if (k == null) {
                    return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " got a null key");
                }
                obj.put(k.toString(), v);
            }
            return obj;
        }
        catch (JSONException e) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " error: " + e.getMessage());
        }
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ObjectNew.DOCUMENTATION", "Creates a new object, optionally pre-filled with key/values.<br/>Must get an even number of arguments, as successive key-value pairs. Giving 0 arguments is possible and will return an empty object (you can use objectPut to add to it)").withParams("k1, v1, k2, v2, ...").withReturns("object").withCategory("GREL.FUNCTIONS.CATEGORY.OBJECT", "Object functions").withExample(Example.with("\"name\"", "\"Smith\"", "\"age\"", "42").returns("{\"name\":\"Smith\",\"age\":42}"));
    }
}

