/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.geo;

import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class GeoMakeValid
implements Function {
    private static final GeometryMeaning geometryMeaning = new GeometryMeaning();
    private static final GeometryFactory geometryFactory = new GeometryFactory();

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1) {
            Object geometry = args[0];
            if (geometry instanceof String && !StringUtils.isBlank((String)((String)geometry))) {
                try {
                    Geometry parsedGeometry = geometryMeaning.toGeometry((String)geometry);
                    if (parsedGeometry == null) {
                        return new EvalError("Geometry should be geospatial data in WKT format");
                    }
                    if (!parsedGeometry.isValid()) {
                        Geometry geomValid;
                        if (parsedGeometry instanceof MultiPolygon) {
                            geomValid = this.fixMultiPolygon((MultiPolygon)parsedGeometry);
                        } else if (parsedGeometry instanceof Polygon) {
                            geomValid = this.fixPolygon(parsedGeometry);
                        } else {
                            return "";
                        }
                        if (geomValid == null) {
                            return new EvalError("Failed to make valid a geometry");
                        }
                        return !geomValid.isEmpty() ? geomValid.toString() : "";
                    }
                    return geometry;
                }
                catch (Exception e) {
                    return new EvalError(String.format("Failed to make valid a geometry %s", e.getMessage()));
                }
            }
            return null;
        }
        return new EvalError(String.format("%s requires one argument)", GrelControlFunctionRegistry.getInstance().getFunctionName(this)));
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.GeoMakeValid.DOCUMENTATION", "Transform invalid geometries (Polygons and Multipolygons) into valid geometries. Valid geometries remain unchanged.").withParams("string geometry").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.GEO", "Geo functions").withExample(Example.with("\"POLYGON ((1 1, 1 5, 5 5, 5 1, 2.5 5, 1 1))\"").returns("MULTIPOLYGON (((1 1, 1 5, 2.5 5, 1 1)), ((2.5 5, 5 5, 5 1, 2.5 5)))")).withExample(Example.with("GeometryColumn").returns("a column of valid geometries."));
    }

    private Geometry fixMultiPolygon(MultiPolygon multipolygon) {
        ArrayList<Polygon> polygonsFixed = new ArrayList<Polygon>();
        for (int i = 0; i < multipolygon.getNumGeometries(); ++i) {
            Polygon polygon = (Polygon)multipolygon.getGeometryN(i);
            Geometry validPolygons = this.fixPolygon((Geometry)polygon);
            if (validPolygons == null) continue;
            for (int k = 0; k < validPolygons.getNumGeometries(); ++k) {
                Polygon validPolygon = (Polygon)validPolygons.getGeometryN(k);
                if (validPolygon == null || validPolygon.isEmpty()) continue;
                polygonsFixed.add(validPolygon);
            }
        }
        MultiPolygon multiPolyFixed = geometryFactory.createMultiPolygon(polygonsFixed.toArray(new Polygon[0]));
        return multiPolyFixed.union();
    }

    private Geometry fixPolygon(Geometry polygon) {
        Geometry polygonFixed = polygon.buffer(0.0);
        return polygonFixed.isValid() ? polygonFixed : null;
    }
}

