/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class ReplaceChars
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 3) {
            Object o1 = args[0];
            Object o2 = args[1];
            Object o3 = args[2];
            if (o1 != null && o2 instanceof String && o3 instanceof String) {
                String str = o1 instanceof String ? (String)o1 : o1.toString();
                return StringUtils.replaceChars((String)str, (String)((String)o2), (String)((String)o3));
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects 3 strings");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ReplaceChars.DOCUMENTATION", "Returns the string obtained by replacing all character in <code>s</code> that match <code>f</code> with the character in <code>r</code> at that same position. The function can be used to delete characters by replacing them with nothing.").withParams("string s, string f, string r").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"abcba\"", "\"bc\"", "\"BC\"").returns("\"aBCBa\"")).withExample(Example.with("\"abcba\"", "\"bc\"", "\"Z\"").returns("\"aZZa\""));
    }
}

