/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel.controls;

import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Control;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.ast.VariableExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Filter
implements Control {
    @Override
    public String checkArguments(Evaluable[] args) {
        if (args.length != 3) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects 3 arguments";
        }
        if (!(args[1] instanceof VariableExpr)) {
            return GrelControlFunctionRegistry.getInstance().getControlName(this) + " expects second argument to be a variable name";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call(Properties bindings, Evaluable[] args) {
        Object o = args[0].evaluate(bindings);
        if (ExpressionUtils.isError(o)) {
            return o;
        }
        if (o == null) {
            return null;
        }
        String name = ((VariableExpr)args[1]).getName();
        Object oldValue = bindings.get(name);
        try {
            List<?> input = DKUFormulaUtils.asList(o);
            ArrayList results = new ArrayList(input.size());
            for (Object v : input) {
                bindings.put(name, v);
                Object r = args[2].evaluate(bindings);
                if (!(r instanceof Boolean) || !((Boolean)r).booleanValue()) continue;
                results.add(v);
            }
            Object[] objectArray = results.toArray();
            return objectArray;
        }
        finally {
            if (oldValue != null) {
                bindings.put(name, oldValue);
            } else {
                bindings.remove(name);
            }
        }
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Filter.DOCUMENTATION", "Evaluates expression <code>a</code> to an array. Then for each array element, binds its value to variable name <code>v</code>, evaluates expression <code>e</code>, and pushes the result onto the result array if the result is truish.").withParams("expression a, variable v, expression test").withReturns("array").withCategory("GREL.FUNCTIONS.CATEGORY.CONTROL_STRUCTURES", "Control structures").withExample(Example.with("[1,2,4,9]", "item", "mod(item,2)==1").returns("[1,9]"));
    }
}

