/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.builders;

import com.dataiku.dss.shadelib.com.google.gson.Gson;
import com.dataiku.dss.shadelib.com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;

public class BuildUtils {
    private static final GsonBuilder gsonBuilder = new GsonBuilder();

    public static <T> T parseURL(URL url, Class<T> classOfT) throws IOException {
        try (InputStream is = url.openStream();){
            T t = BuildUtils.parse(is, classOfT);
            return t;
        }
    }

    public static <T> T parse(InputStream in, Class<T> classOfT) throws IOException {
        Object t;
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            t = BuildUtils.gson().fromJson((Reader)reader, classOfT);
        }
        return (T)t;
    }

    public static <T> T parseGzippedURL(URL url, Class<T> classOfT) throws IOException {
        try (InputStream is = url.openStream();){
            T t = BuildUtils.parseGzipped(is, classOfT);
            return t;
        }
    }

    public static <T> T parseGzipped(InputStream in, Class<T> classOfT) throws IOException {
        Object t;
        try (GZIPInputStream gis = new GZIPInputStream(in);
             InputStreamReader reader = new InputStreamReader((InputStream)gis, StandardCharsets.UTF_8);){
            t = BuildUtils.gson().fromJson((Reader)reader, classOfT);
        }
        return (T)t;
    }

    public static void registerAdapter(Type t, Object a) {
        gsonBuilder.registerTypeAdapter(t, a);
    }

    private static Gson gson() {
        return gsonBuilder.create();
    }
}

