/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.linalg;

import com.dataiku.scoring.linalg.Util;
import com.dataiku.scoring.linalg.Vector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DenseVector
implements Vector {
    private static final long serialVersionUID = 0L;
    private final double[] data;

    public DenseVector(double[] data) {
        this.data = data;
    }

    @Override
    public double get(int i) {
        return this.data[i];
    }

    @Override
    public Iterable<Integer> activeIndices() {
        return new Util.Range(this.data.length);
    }

    @Override
    public boolean isActive(int i) {
        return true;
    }

    @Override
    public boolean isMissing(int i) {
        return Double.isNaN(this.data[i]);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public double[] toArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    @Override
    public List<Double> toList() {
        ArrayList<Double> ret = new ArrayList<Double>();
        for (double d : this.data) {
            ret.add(d);
        }
        return ret;
    }
}

