/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;
import java.util.Map;

public class ImputeWithValue
implements Processor {
    private static final long serialVersionUID = 0L;
    private static final String EMPTY = "";
    private final boolean emptyStringIsNull;
    private final Map<String, Object> columnMapping;

    public ImputeWithValue(Map<String, Object> columnMapping, boolean emptyStringIsNull) {
        this.columnMapping = columnMapping;
        this.emptyStringIsNull = emptyStringIsNull;
    }

    public Map<String, Object> getColumnMapping() {
        return this.columnMapping;
    }

    @Override
    public void process(RawObservation data) {
        if (this.emptyStringIsNull) {
            for (Map.Entry<String, Object> e : this.columnMapping.entrySet()) {
                Object x = data.get(e.getKey());
                if (x != null && !EMPTY.equals(x)) continue;
                data.put(e.getKey(), e.getValue());
            }
        } else {
            for (Map.Entry<String, Object> e : this.columnMapping.entrySet()) {
                if (data.get(e.getKey()) != null) continue;
                data.put(e.getKey(), e.getValue());
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("ImputeWithValue(");
        for (Map.Entry<String, Object> e : this.columnMapping.entrySet()) {
            s.append(e.getKey()).append(" -> ").append(e.getValue()).append(" ; ");
        }
        return s.append(")").toString();
    }
}

