/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token;

import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.Scope;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.AccessToken;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.AccessTokenUtils;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import com.dataiku.dss.shadelib.net.jcip.annotations.Immutable;
import com.dataiku.dss.shadelib.net.minidev.json.JSONObject;
import java.util.List;
import java.util.Map;

@Immutable
public class BearerAccessToken
extends AccessToken {
    private static final long serialVersionUID = 2387121016151061194L;

    public BearerAccessToken() {
        this(32);
    }

    public BearerAccessToken(int byteLength) {
        this(byteLength, 0L, null);
    }

    public BearerAccessToken(long lifetime, Scope scope) {
        this(32, lifetime, scope);
    }

    public BearerAccessToken(int byteLength, long lifetime, Scope scope) {
        super(AccessTokenType.BEARER, byteLength, lifetime, scope);
    }

    public BearerAccessToken(String value) {
        this(value, 0L, null, null);
    }

    public BearerAccessToken(String value, long lifetime, Scope scope) {
        this(value, lifetime, scope, null);
    }

    public BearerAccessToken(String value, long lifetime, Scope scope, TokenTypeURI issuedTokenType) {
        super(AccessTokenType.BEARER, value, lifetime, scope, null, issuedTokenType);
    }

    public BearerAccessToken(String value, long lifetime, Scope scope, List<AuthorizationDetail> authorizationDetails, TokenTypeURI issuedTokenType) {
        super(AccessTokenType.BEARER, value, lifetime, scope, authorizationDetails, issuedTokenType);
    }

    @Override
    public String toAuthorizationHeader() {
        return "Bearer " + this.getValue();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof BearerAccessToken && this.toString().equals(object.toString());
    }

    public static BearerAccessToken parse(JSONObject jsonObject) throws ParseException {
        AccessTokenUtils.parseAndEnsureType(jsonObject, AccessTokenType.BEARER);
        String accessTokenValue = AccessTokenUtils.parseValue(jsonObject);
        long lifetime = AccessTokenUtils.parseLifetime(jsonObject);
        Scope scope = AccessTokenUtils.parseScope(jsonObject);
        List<AuthorizationDetail> authorizationDetails = AccessTokenUtils.parseAuthorizationDetails(jsonObject);
        TokenTypeURI issuedTokenType = AccessTokenUtils.parseIssuedTokenType(jsonObject);
        return new BearerAccessToken(accessTokenValue, lifetime, scope, authorizationDetails, issuedTokenType);
    }

    public static BearerAccessToken parse(String header) throws ParseException {
        return new BearerAccessToken(AccessTokenUtils.parseValueFromHeader(header, AccessTokenType.BEARER));
    }

    public static BearerAccessToken parse(Map<String, List<String>> parameters) throws ParseException {
        return new BearerAccessToken(AccessTokenUtils.parseValueFromQueryParameters(parameters, AccessTokenType.BEARER));
    }

    public static BearerAccessToken parse(HTTPRequest request) throws ParseException {
        String authzHeader = request.getAuthorization();
        if (authzHeader != null) {
            return BearerAccessToken.parse(authzHeader);
        }
        Map<String, List<String>> params = request.getQueryParameters();
        return BearerAccessToken.parse(params);
    }
}

