/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ImpactsDISI;
import com.dataiku.dss.shadelib.org.apache.lucene.search.LeafSimScorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MaxScoreCache;
import com.dataiku.dss.shadelib.org.apache.lucene.search.PhraseMatcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TwoPhaseIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import java.io.IOException;

class PhraseScorer
extends Scorer {
    final DocIdSetIterator approximation;
    final ImpactsDISI impactsApproximation;
    final MaxScoreCache maxScoreCache;
    final PhraseMatcher matcher;
    final ScoreMode scoreMode;
    private final LeafSimScorer simScorer;
    final float matchCost;
    private float minCompetitiveScore = 0.0f;
    private float freq = 0.0f;

    PhraseScorer(Weight weight, PhraseMatcher matcher, ScoreMode scoreMode, LeafSimScorer simScorer) {
        super(weight);
        this.matcher = matcher;
        this.scoreMode = scoreMode;
        this.simScorer = simScorer;
        this.matchCost = matcher.getMatchCost();
        this.approximation = matcher.approximation();
        this.impactsApproximation = matcher.impactsApproximation();
        this.maxScoreCache = this.impactsApproximation.getMaxScoreCache();
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return new TwoPhaseIterator(this.approximation){

            @Override
            public boolean matches() throws IOException {
                PhraseScorer.this.matcher.reset();
                if (PhraseScorer.this.scoreMode == ScoreMode.TOP_SCORES && PhraseScorer.this.minCompetitiveScore > 0.0f) {
                    float maxFreq = PhraseScorer.this.matcher.maxFreq();
                    if (PhraseScorer.this.simScorer.score(PhraseScorer.this.docID(), maxFreq) < PhraseScorer.this.minCompetitiveScore) {
                        return false;
                    }
                }
                PhraseScorer.this.freq = 0.0f;
                return PhraseScorer.this.matcher.nextMatch();
            }

            @Override
            public float matchCost() {
                return PhraseScorer.this.matchCost;
            }
        };
    }

    @Override
    public int docID() {
        return this.approximation.docID();
    }

    @Override
    public float score() throws IOException {
        if (this.freq == 0.0f) {
            this.freq = this.matcher.sloppyWeight();
            while (this.matcher.nextMatch()) {
                this.freq += this.matcher.sloppyWeight();
            }
        }
        return this.simScorer.score(this.docID(), this.freq);
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        this.minCompetitiveScore = minScore;
        this.impactsApproximation.setMinCompetitiveScore(minScore);
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.maxScoreCache.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScoreCache.getMaxScore(upTo);
    }

    public String toString() {
        return "PhraseScorer(" + this.weight + ")";
    }
}

