/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.io;

import com.dataiku.dss.shadelib.org.eclipse.jetty.io.AbstractEndPoint;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.EndPoint;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.FillInterest;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.WriteFlusher;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.BufferUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.AutoLock;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.Invocable;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HexFormat;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryEndPointPipe
implements EndPoint.Pipe {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryEndPointPipe.class);
    private final LocalEndPoint localEndPoint;
    private final RemoteEndPoint remoteEndPoint;
    private final Consumer<Invocable.Task> taskConsumer;

    public MemoryEndPointPipe(Scheduler scheduler, Consumer<Invocable.Task> consumer, SocketAddress socketAddress) {
        this.localEndPoint = new LocalEndPoint(scheduler, socketAddress);
        this.remoteEndPoint = new RemoteEndPoint(scheduler, new MemorySocketAddress());
        this.localEndPoint.setPeerEndPoint(this.remoteEndPoint);
        this.remoteEndPoint.setPeerEndPoint(this.localEndPoint);
        this.taskConsumer = consumer;
    }

    @Override
    public EndPoint getLocalEndPoint() {
        return this.localEndPoint;
    }

    @Override
    public EndPoint getRemoteEndPoint() {
        return this.remoteEndPoint;
    }

    private class LocalEndPoint
    extends MemoryEndPoint {
        private LocalEndPoint(Scheduler scheduler, SocketAddress socketAddress) {
            super(scheduler, socketAddress);
        }
    }

    private class RemoteEndPoint
    extends MemoryEndPoint {
        private RemoteEndPoint(Scheduler scheduler, SocketAddress socketAddress) {
            super(scheduler, socketAddress);
        }
    }

    private static class MemorySocketAddress
    extends SocketAddress {
        private static final AtomicLong ID = new AtomicLong();
        private final long id = ID.incrementAndGet();
        private final String address = "[memory:/%s]".formatted(HexFormat.of().formatHex(ByteBuffer.allocate(8).putLong(this.id).array()));

        private MemorySocketAddress() {
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MemorySocketAddress) {
                MemorySocketAddress that = (MemorySocketAddress)obj;
                return this.id == that.id;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public String toString() {
            return this.address;
        }
    }

    private class MemoryEndPoint
    extends AbstractEndPoint {
        private static final ByteBuffer EOF = ByteBuffer.allocate(0);
        private final AutoLock lock;
        private final Deque<ByteBuffer> byteBuffers;
        private final SocketAddress localAddress;
        private MemoryEndPoint peerEndPoint;
        private Invocable.Task fillableTask;
        private Invocable.Task completeWriteTask;
        private long maxCapacity;
        private long capacity;

        private MemoryEndPoint(Scheduler scheduler, SocketAddress localAddress) {
            super(scheduler);
            this.lock = new AutoLock();
            this.byteBuffers = new ArrayDeque<ByteBuffer>();
            this.localAddress = localAddress;
        }

        void setPeerEndPoint(MemoryEndPoint peerEndPoint) {
            this.peerEndPoint = peerEndPoint;
            this.fillableTask = new FillableTask(peerEndPoint.getFillInterest());
            this.completeWriteTask = new CompleteWriteTask(peerEndPoint.getWriteFlusher());
        }

        public long getMaxCapacity() {
            return this.maxCapacity;
        }

        public void setMaxCapacity(long maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public Object getTransport() {
            return null;
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.localAddress;
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.peerEndPoint.getLocalSocketAddress();
        }

        @Override
        protected void onIncompleteFlush() {
        }

        @Override
        protected void needsFillInterest() {
        }

        @Override
        public int fill(ByteBuffer buffer) throws IOException {
            int filled;
            ByteBuffer data;
            if (!this.isOpen()) {
                throw new IOException("closed");
            }
            if (this.isInputShutdown()) {
                return -1;
            }
            try (AutoLock ignored = this.peerEndPoint.lock.lock();){
                Deque<ByteBuffer> byteBuffers = this.peerEndPoint.byteBuffers;
                data = (ByteBuffer)byteBuffers.peek();
                if (data == null) {
                    filled = 0;
                } else if (data == EOF) {
                    filled = -1;
                } else {
                    int space;
                    int length = data.remaining();
                    if (length <= (space = BufferUtil.space(buffer))) {
                        byteBuffers.poll();
                    }
                    filled = Math.min(length, space);
                    this.peerEndPoint.capacity -= (long)filled;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("filled {} from {}", (Object)filled, (Object)this);
            }
            if (data == null) {
                return 0;
            }
            if (data == EOF) {
                this.shutdownInput();
                return -1;
            }
            int copied = BufferUtil.append(buffer, data);
            assert (copied == filled);
            if (filled > 0) {
                this.notIdle();
                this.onFilled();
            }
            return filled;
        }

        private void onFilled() {
            MemoryEndPointPipe.this.taskConsumer.accept(this.completeWriteTask);
        }

        @Override
        public boolean flush(ByteBuffer ... buffers) throws IOException {
            if (!this.isOpen()) {
                throw new IOException("closed");
            }
            if (this.isOutputShutdown()) {
                throw new IOException("shutdown");
            }
            long flushed = 0L;
            boolean result = true;
            try (AutoLock ignored = this.lock.lock();){
                for (ByteBuffer buffer : buffers) {
                    int remaining = buffer.remaining();
                    if (remaining == 0) continue;
                    long newCapacity = this.capacity + (long)remaining;
                    long maxCapacity = this.getMaxCapacity();
                    if (maxCapacity > 0L && newCapacity > maxCapacity) {
                        result = false;
                        break;
                    }
                    this.byteBuffers.offer(BufferUtil.copy(buffer));
                    buffer.position(buffer.limit());
                    this.capacity = newCapacity;
                    flushed += (long)remaining;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} to {}", (Object)flushed, (Object)this);
            }
            if (flushed > 0L) {
                this.notIdle();
                this.onFlushed();
            }
            return result;
        }

        @Override
        protected void doShutdownOutput() {
            super.doShutdownOutput();
            try (AutoLock ignored = this.lock.lock();){
                this.byteBuffers.offer(EOF);
            }
            this.onFlushed();
        }

        @Override
        protected void doClose() {
            super.doClose();
            try (AutoLock ignored = this.lock.lock();){
                ByteBuffer last = this.byteBuffers.peekLast();
                if (last != EOF) {
                    this.byteBuffers.offer(EOF);
                }
            }
            this.onFlushed();
        }

        private void onFlushed() {
            MemoryEndPointPipe.this.taskConsumer.accept(this.fillableTask);
        }
    }

    private record CompleteWriteTask(WriteFlusher writeFlusher) implements Invocable.Task
    {
        @Override
        public void run() {
            this.writeFlusher.completeWrite();
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.writeFlusher.getCallbackInvocationType();
        }
    }

    private record FillableTask(FillInterest fillInterest) implements Invocable.Task
    {
        @Override
        public void run() {
            this.fillInterest.fillable();
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this.fillInterest.getCallbackInvocationType();
        }
    }
}

