/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.git;

import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;

public class DKUDiffFormatter {
    private Git git;
    public boolean statsOnly;

    public DKUDiffFormatter(Git git) {
        this.git = git;
    }

    public GitModel.FileChange formatFileChange(byte[] data) throws IOException {
        return this.formatFileChange(data, 5);
    }

    public GitModel.FileChange formatFileChange(byte[] data, int startAtLine) throws IOException {
        String formatted = IOUtils.toString((byte[])data, (String)"utf8");
        GitModel.FileChange fc = new GitModel.FileChange();
        int lineIdx = 0;
        StringBuilder sb = new StringBuilder();
        for (String line : formatted.split("\\r?\\n")) {
            if (++lineIdx < startAtLine || line.startsWith("+++ /dev/null")) continue;
            if (this.statsOnly) {
                if (line.startsWith("+")) {
                    ++fc.addedLines;
                    continue;
                }
                if (!line.startsWith("-")) continue;
                ++fc.removedLines;
                continue;
            }
            fc.c.add(line);
            if (line.startsWith("@")) {
                sb.append('H');
                continue;
            }
            if (line.startsWith("+")) {
                ++fc.addedLines;
                sb.append('A');
                continue;
            }
            if (line.startsWith("-")) {
                ++fc.removedLines;
                sb.append('R');
                continue;
            }
            sb.append('C');
        }
        fc.s = sb.toString();
        return fc;
    }

    public GitModel.DKUDiffEntry buildDiffEntry(DiffEntry diffEntry, boolean nameOnly) throws IOException {
        GitModel.DKUDiffEntry out = new GitModel.DKUDiffEntry();
        out.changeType = diffEntry.getChangeType();
        out.oldPath = diffEntry.getOldPath();
        out.newPath = diffEntry.getNewPath();
        if (!nameOnly) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try (DiffFormatter formatter = new DiffFormatter((OutputStream)os);){
                formatter.setRepository(this.git.getRepository());
                formatter.format(diffEntry);
            }
            out.fileChange = this.formatFileChange(os.toByteArray());
        }
        return out;
    }
}

