/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.transactions.git.jgit;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.transactions.TransactionCodes;
import com.dataiku.dip.transactions.fs.ProtectedFiles;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.transactions.git.IGitManager;
import com.dataiku.dip.transactions.git.jgit.GitLocalCommands;
import com.dataiku.dip.utils.AutoCloseableLock;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.NamedLock;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.revwalk.RevCommit;

public abstract class JGitManager
implements IGitManager {
    protected File root;
    protected ProtectedFiles gitProtectedFiles = ProtectedFiles.GIT_PROTECTED_FILES;
    private final String[] otherGitignored = new String[]{"*.pyc", ".coverage", ".htmlcov", ".DS_Store", ".idea"};
    protected static final Logger logger = Logger.getLogger((String)"dku.jgit");

    public abstract Git getGlobalGit();

    public abstract SubGit getSubGit(String var1) throws IOException;

    public abstract void invalidateSubGit(String var1);

    Git getGit(String namespace) throws IOException {
        if (StringUtils.isBlank((String)namespace)) {
            return this.getGlobalGit();
        }
        return this.getSubGit((String)namespace).git;
    }

    public File getRoot() {
        return this.root;
    }

    public static String getRepositoryLockName(String path) {
        return "git:" + path;
    }

    public static String getRepositoryLockName(Git git) {
        String path = git.getRepository().getDirectory().getAbsolutePath();
        return JGitManager.getRepositoryLockName(path);
    }

    protected Git initRepository(File repositoryRoot, @Nullable GitModel.GitAuthor gitAuthor) throws IOException {
        String lockName = JGitManager.getRepositoryLockName(repositoryRoot.getAbsolutePath());
        try (AutoCloseableLock ignored = NamedLock.acquire(lockName);){
            Git git = this.initRepositoryNoLock(repositoryRoot, gitAuthor);
            return git;
        }
    }

    String getDefaultBranch() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected Git initRepositoryNoLock(File repositoryRoot, @Nullable GitModel.GitAuthor gitAuthor) throws IOException {
        if (!new File(repositoryRoot, ".git").isDirectory()) {
            try {
                gitInitCommand = Git.init().setBare(false).setDirectory(repositoryRoot);
                defaultBaseBranch = this.getDefaultBranch();
                if (StringUtils.isNotBlank((String)defaultBaseBranch)) {
                    gitInitCommand.setInitialBranch(defaultBaseBranch);
                }
                gitInitCommand.call();
                git = Git.open((File)repositoryRoot);
                gitIgnore = new File(repositoryRoot, ".gitignore");
                if (gitIgnore.exists()) ** GOTO lbl35
                gitIgnoreContent = new StringBuilder();
                for (RelFile rf : this.gitProtectedFiles.list()) {
                    gitIgnoreContent.append(rf.getFullPath() + "\n");
                }
                for (String i : this.otherGitignored) {
                    gitIgnoreContent.append(i + "\n");
                }
                DKUFileUtils.writeFileUTF8((File)gitIgnore, (String)gitIgnoreContent.toString());
                git.add().addFilepattern(".gitignore").call();
                commit = git.commit().setSign(Boolean.valueOf(false)).setMessage("Initialize gitignore");
                if (gitAuthor != null) {
                    commit.setAuthor(gitAuthor.name, gitAuthor.getEmailOrName());
                }
                commit.call();
            }
            catch (GitAPIException e) {
                throw new IOException("Failed to initialize Git repository in " + String.valueOf(repositoryRoot), e);
            }
        } else {
            git = Git.open((File)repositoryRoot);
        }
lbl35:
        // 3 sources

        gitLocalCommands = new GitLocalCommands(git);
        gitLocalCommands.disableSymlinksIfNeeded();
        gitLocalCommands.disableHooksIfNeeded();
        return git;
    }

    protected String basicCommitChanges(Git git, File root, ProtectedFiles protectedFiles, GitModel.GitAuthor author, String message, List<RelFile> changes) throws IOException {
        try {
            AddCommand add = git.add();
            RmCommand rm = git.rm();
            AddCommand update = git.add().setUpdate(true);
            boolean hasRm = false;
            boolean hasAdd = false;
            boolean hasUpdate = false;
            for (RelFile rf : changes) {
                if (protectedFiles.isProtected(rf)) continue;
                File file = rf.resolve(root);
                if (file.exists()) {
                    add.addFilepattern(rf.getFullPath());
                    hasAdd = true;
                    if (!file.isDirectory()) continue;
                    update.addFilepattern(rf.getFullPath());
                    hasUpdate = true;
                    continue;
                }
                rm.addFilepattern(rf.getFullPath());
                hasRm = true;
            }
            if (hasRm) {
                rm.call();
            }
            if (hasAdd) {
                add.call();
            }
            if (hasUpdate) {
                update.call();
            }
            CommitCommand commit = git.commit().setSign(Boolean.valueOf(false));
            commit.setAuthor(author.name, author.getEmailOrName());
            commit.setMessage(message);
            commit.setSign(Boolean.valueOf(false));
            RevCommit rev = commit.call();
            return rev.name();
        }
        catch (GitAPIException | JGitInternalException e) {
            throw new CodedIOException((InfoMessage.MessageCode)TransactionCodes.ERR_TRANSACTION_GIT_COMMIT_FAILED, "Unable to commit transaction", e);
        }
    }

    protected String basicCommitPatterns(Git git, ProtectedFiles protectedFiles, GitModel.GitAuthor author, String message, List<String> patterns) throws IOException {
        try {
            AddCommand add = git.add();
            AddCommand mod = git.add().setUpdate(true);
            StatusCommand statusCommand = git.status();
            for (String pattern : patterns) {
                statusCommand.addPath(pattern);
                add.addFilepattern(pattern);
                mod.addFilepattern(pattern);
            }
            Status status = statusCommand.call();
            if (!status.getMissing().isEmpty() || !status.getRemoved().isEmpty()) {
                RmCommand rm = git.rm();
                for (String deletedFile : Iterables.concat((Iterable)status.getMissing(), (Iterable)status.getRemoved())) {
                    rm.addFilepattern(deletedFile);
                }
                rm.call();
            }
            add.call();
            mod.call();
            CommitCommand commit = git.commit().setSign(Boolean.valueOf(false));
            commit.setAuthor(author.name, author.getEmailOrName());
            commit.setMessage(message);
            commit.setSign(Boolean.valueOf(false));
            RevCommit rev = commit.call();
            return rev.name();
        }
        catch (GitAPIException | JGitInternalException e) {
            throw new CodedIOException((InfoMessage.MessageCode)TransactionCodes.ERR_TRANSACTION_GIT_COMMIT_FAILED, "Unable to commit transaction", e);
        }
    }

    @Override
    public void postInit() {
    }

    public static class SubGit {
        public final Git git;
        public final String pathPrefix;

        public SubGit(Git git, String prefix) {
            this.git = git;
            this.pathPrefix = prefix;
        }
    }
}

