/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.spnego;

import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.sourceforge.spnego.Base64;
import net.sourceforge.spnego.SpnegoAuthScheme;
import net.sourceforge.spnego.SpnegoFilterConfig;
import net.sourceforge.spnego.SpnegoHttpServletResponse;
import net.sourceforge.spnego.SpnegoPrincipal;
import net.sourceforge.spnego.SpnegoProvider;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public final class SpnegoAuthenticator {
    private static final Logger LOGGER = Logger.getLogger("SpnegoHttpFilter");
    private static final Lock LOCK = new ReentrantLock();
    private static final GSSManager MANAGER = GSSManager.getInstance();
    private final transient boolean allowBasic;
    private final transient boolean allowDelegation;
    private final transient boolean allowLocalhost;
    private final transient boolean allowUnsecure;
    private final transient boolean promptIfNtlm;
    private final transient String clientModuleName;
    private final transient LoginContext loginContext;
    private final transient GSSCredential serverCredentials;
    private final transient KerberosPrincipal serverPrincipal;

    public SpnegoAuthenticator(SpnegoFilterConfig config) throws LoginException, GSSException, PrivilegedActionException {
        LOGGER.fine("config=" + config);
        this.allowBasic = config.isBasicAllowed();
        this.allowUnsecure = config.isUnsecureAllowed();
        this.clientModuleName = config.getClientLoginModule();
        this.allowLocalhost = config.isLocalhostAllowed();
        this.promptIfNtlm = config.downgradeNtlm();
        this.allowDelegation = config.isDelegationAllowed();
        if (config.useKeyTab()) {
            this.loginContext = new LoginContext(config.getServerLoginModule());
        } else {
            CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(config.getPreauthUsername(), config.getPreauthPassword());
            this.loginContext = new LoginContext(config.getServerLoginModule(), handler);
        }
        this.loginContext.login();
        this.serverCredentials = SpnegoProvider.getServerCredential(this.loginContext.getSubject());
        this.serverPrincipal = new KerberosPrincipal(this.serverCredentials.getName().toString());
    }

    public SpnegoAuthenticator(final Map<String, String> config) throws LoginException, GSSException, PrivilegedActionException, FileNotFoundException, URISyntaxException {
        this(SpnegoFilterConfig.getInstance(new FilterConfig(){
            private final Map<String, String> map;
            {
                this.map = Collections.unmodifiableMap(config);
            }

            public String getFilterName() {
                throw new UnsupportedOperationException();
            }

            public String getInitParameter(String param) {
                if (null == this.map.get(param)) {
                    throw new NullPointerException("Config missing param value for: " + param);
                }
                return this.map.get(param);
            }

            public Enumeration<String> getInitParameterNames() {
                throw new UnsupportedOperationException();
            }

            public ServletContext getServletContext() {
                throw new UnsupportedOperationException();
            }
        }));
    }

    public SpnegoAuthenticator(String loginModuleName, SpnegoFilterConfig config) throws LoginException, GSSException, PrivilegedActionException {
        boolean hasUsername;
        LOGGER.fine("loginModuleName=" + loginModuleName);
        this.allowBasic = config.isBasicAllowed();
        this.allowUnsecure = config.isUnsecureAllowed();
        this.clientModuleName = config.getClientLoginModule();
        this.allowLocalhost = config.isLocalhostAllowed();
        this.promptIfNtlm = config.downgradeNtlm();
        this.allowDelegation = config.isDelegationAllowed();
        String username = config.getPreauthUsername();
        boolean bl = hasUsername = null != username && !username.trim().isBlank();
        if (hasUsername) {
            this.loginContext = new LoginContext(loginModuleName, SpnegoProvider.getUsernamePasswordHandler(username, config.getPreauthPassword()));
        } else if (config.useKeyTab()) {
            this.loginContext = new LoginContext(loginModuleName);
        } else {
            throw new IllegalArgumentException("Must provide a username/password or specify a keytab file");
        }
        this.loginContext.login();
        this.serverCredentials = SpnegoProvider.getServerCredential(this.loginContext.getSubject());
        this.serverPrincipal = new KerberosPrincipal(this.serverCredentials.getName().toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SpnegoPrincipal authenticate(HttpServletRequest req, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        String serverRealm;
        if (this.allowLocalhost && this.isLocalhost(req)) {
            return this.doLocalhost();
        }
        boolean basicSupported = this.allowBasic && (this.allowUnsecure || req.isSecure());
        SpnegoAuthScheme scheme = SpnegoProvider.negotiate(req, resp, basicSupported, this.promptIfNtlm, serverRealm = this.serverPrincipal.getRealm());
        if (null == scheme) {
            LOGGER.fine("scheme null.");
            return null;
        }
        if (scheme.isNegotiateScheme()) {
            return this.doSpnegoAuth(scheme, resp);
        }
        if (!scheme.isBasicScheme()) throw new UnsupportedOperationException("scheme=" + scheme);
        if (basicSupported) {
            return this.doBasicAuth(scheme, resp);
        }
        LOGGER.severe("allowBasic=" + this.allowBasic + "; allowUnsecure=" + this.allowUnsecure + "; req.isSecure()=" + req.isSecure());
        throw new UnsupportedOperationException("Basic Auth not allowed or SSL required.");
    }

    public void dispose() {
        if (null != this.serverCredentials) {
            try {
                this.serverCredentials.dispose();
            }
            catch (GSSException e) {
                LOGGER.log(Level.WARNING, "Dispose failed.", e);
            }
        }
        if (null != this.loginContext) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException lex) {
                LOGGER.log(Level.WARNING, "Logout failed.", lex);
            }
        }
    }

    private SpnegoPrincipal doBasicAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws IOException {
        byte[] data = scheme.getToken();
        if (0 == data.length) {
            LOGGER.fine("Basic Auth data was NULL.");
            return null;
        }
        String[] basicData = new String(data).split(":", 2);
        if (basicData.length != 2) {
            throw new IllegalArgumentException("Username/Password may have contained an invalid character. basicData.length=" + basicData.length);
        }
        String username = basicData[0].substring(basicData[0].indexOf(92) + 1);
        String password = basicData[1];
        CallbackHandler handler = SpnegoProvider.getUsernamePasswordHandler(username, password);
        SpnegoPrincipal principal = null;
        try {
            if (null == username || username.isBlank()) {
                throw new LoginException("Username is required.");
            }
            LoginContext cntxt = new LoginContext(this.clientModuleName, handler);
            cntxt.login();
            cntxt.logout();
            principal = new SpnegoPrincipal(username + "@" + this.serverPrincipal.getRealm(), 1);
        }
        catch (LoginException lex) {
            LOGGER.fine(lex.getMessage() + ": Login failed. username=" + username);
            resp.setHeader("WWW-Authenticate", "Negotiate");
            resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.serverPrincipal.getRealm() + "\"");
            resp.setStatus(401, true);
        }
        return principal;
    }

    private SpnegoPrincipal doLocalhost() {
        String username = System.getProperty("user.name");
        if (null == username || username.isBlank()) {
            return new SpnegoPrincipal(this.serverPrincipal.getName() + "@" + this.serverPrincipal.getRealm(), this.serverPrincipal.getNameType());
        }
        return new SpnegoPrincipal(username + "@" + this.serverPrincipal.getRealm(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpnegoPrincipal doSpnegoAuth(SpnegoAuthScheme scheme, SpnegoHttpServletResponse resp) throws GSSException, IOException {
        String principal;
        byte[] gss = scheme.getToken();
        if (0 == gss.length) {
            LOGGER.fine("GSS data was NULL.");
            return null;
        }
        GSSContext context = null;
        GSSCredential delegCred = null;
        try {
            byte[] token;
            LOCK.lock();
            try {
                context = MANAGER.createContext(this.serverCredentials);
                token = context.acceptSecContext(gss, 0, gss.length);
            }
            finally {
                LOCK.unlock();
            }
            if (null == token) {
                LOGGER.fine("Token was NULL.");
                SpnegoPrincipal spnegoPrincipal = null;
                return spnegoPrincipal;
            }
            resp.setHeader("WWW-Authenticate", "Negotiate " + Base64.encode(token));
            if (!context.isEstablished()) {
                LOGGER.fine("context not established");
                resp.setStatus(401, true);
                SpnegoPrincipal spnegoPrincipal = null;
                return spnegoPrincipal;
            }
            principal = context.getSrcName().toString();
            if (this.allowDelegation && context.getCredDelegState()) {
                delegCred = context.getDelegCred();
            }
        }
        finally {
            if (null != context) {
                LOCK.lock();
                try {
                    context.dispose();
                }
                finally {
                    LOCK.unlock();
                }
            }
        }
        return new SpnegoPrincipal(principal, 1, delegCred);
    }

    public String getServerRealm() {
        return this.serverPrincipal.getRealm();
    }

    private boolean isLocalhost(HttpServletRequest req) {
        boolean isLocal = req.getLocalAddr().equals(req.getRemoteAddr());
        if (!isLocal && "0.0.0.0".equals(req.getLocalAddr()) && "0:0:0:0:0:0:0:1".equals(req.getRemoteAddr())) {
            isLocal = true;
        }
        return isLocal;
    }
}

