/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.Days;
import com.dataiku.dss.shadelib.org.joda.time.LocalDate;
import com.dataiku.dss.shadelib.org.joda.time.ReadablePartial;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormat;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatterBuilder;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeParser;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DKUDateUtils {
    public static final String ISO_FORMAT_LOCAL = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static DateTimeFormatter ymdDashOrSlash() {
        DateTimeParser ymdDash = new DateTimeFormatterBuilder().appendYear(4, 4).appendLiteral('-').appendMonthOfYear(2).appendLiteral('-').appendDayOfMonth(2).toParser();
        DateTimeParser ymdSlash = new DateTimeFormatterBuilder().appendYear(4, 4).appendLiteral('/').appendMonthOfYear(2).appendLiteral('/').appendDayOfMonth(2).toParser();
        DateTimeParser ymdDashOrSlash = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{ymdDash, ymdSlash}).toParser();
        return new DateTimeFormatterBuilder().append(ymdDashOrSlash).toFormatter();
    }

    public static String isoFormatUTC(long ts) {
        return ISODateTimeFormat.dateHourMinuteSecondMillis().withZone(DateTimeZone.UTC).print(ts) + "Z";
    }

    public static String formatUTC(long ts, String format) {
        return DateTimeFormat.forPattern((String)format).withZone(DateTimeZone.UTC).print(ts);
    }

    public static String isoFormatUTCNow() {
        return DKUDateUtils.isoFormatUTC(System.currentTimeMillis());
    }

    public static long parseISOUTCWithMicroseconds(String in) {
        String FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ";
        return DateTimeFormat.forPattern((String)FORMAT).withZone(DateTimeZone.UTC).parseMillis(in);
    }

    public static long parseISOLocal(String in) {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS").withZone(DateTimeZone.getDefault()).parseMillis(in);
    }

    public static long parseISOUTC(String in) {
        return DateTimeFormat.forPattern((String)ISO_FORMAT_LOCAL).parseMillis(in);
    }

    public static String isoFormatLocal(long ts) {
        return DateTimeFormat.forPattern((String)ISO_FORMAT_LOCAL).withZone(DateTimeZone.getDefault()).print(ts);
    }

    public static String isoFormatFileFriendlyLocal(long ts) {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd-HH-mm-ss-SSS").withZone(DateTimeZone.getDefault()).print(ts);
    }

    public static String isoFormatLocalNow() {
        return DKUDateUtils.isoFormatLocal(System.currentTimeMillis());
    }

    public static String isoFormatFileFriendlyLocalNow() {
        return DKUDateUtils.isoFormatFileFriendlyLocal(System.currentTimeMillis());
    }

    public static int daysBetweenUTC(long start, long end) {
        return DKUDateUtils.daysBetween(start, end, DateTimeZone.UTC);
    }

    public static int daysBetweenLocal(long start, long end) {
        return DKUDateUtils.daysBetween(start, end, DateTimeZone.getDefault());
    }

    public static int daysBetween(long start, long end, DateTimeZone tz) {
        return Days.daysBetween((ReadablePartial)new LocalDate(start, tz), (ReadablePartial)new LocalDate(end, tz)).getDays();
    }

    public static FormatPattern parsePattern(String pattern, boolean joda) {
        return joda ? DKUDateUtils.parseJodaPattern(pattern) : DKUDateUtils.parseSimpleDateFormatPattern(pattern);
    }

    static FormatPattern parseJodaPattern(String pattern) {
        FormatPattern ret = new FormatPattern();
        if (pattern == null || pattern.length() == 0) {
            return ret;
        }
        int p = 0;
        int l = pattern.length();
        block23: while (p < l) {
            int en;
            int st;
            char c = pattern.charAt(p);
            if (c == '\'') {
                st = ++p;
                while (p < l && (pattern.charAt(p) != '\'' || p + 1 < l && pattern.charAt(p + 1) == '\'')) {
                    if (pattern.charAt(p) != '\'') {
                        ++p;
                        continue;
                    }
                    p += 2;
                }
                if (p >= l) {
                    en = l - 1;
                } else {
                    en = p - 1;
                    ++p;
                }
                String quoted = pattern.substring(st, en + 1);
                quoted = quoted.replace("''", "'");
                if (quoted.length() == 0) {
                    quoted = "'";
                }
                ret.add(new FormatPatternPart(FormatPatternPartType.TEXT, false, false, quoted));
                continue;
            }
            st = p;
            while (p < l && pattern.charAt(p) == c) {
                ++p;
            }
            en = p - 1;
            String text = pattern.substring(st, en + 1);
            switch (c) {
                case 'G': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.ERA, false, false, text));
                    continue block23;
                }
                case 'C': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.CENTURY, text));
                    continue block23;
                }
                case 'Y': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.YEAROFERA, true, text.length() == 2, text));
                    continue block23;
                }
                case 'y': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.YEAR, true, text.length() == 2, text));
                    continue block23;
                }
                case 'x': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.WEEKYEAR, true, text.length() == 2, text));
                    continue block23;
                }
                case 'M': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.MONTH, text.length() <= 2, text.length() == 3, text));
                    continue block23;
                }
                case 'w': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.WEEK, text));
                    continue block23;
                }
                case 'D': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.DAYOFYEAR, text));
                    continue block23;
                }
                case 'd': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.DAY, text));
                    continue block23;
                }
                case 'e': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.DAYOFWEEK, text));
                    continue block23;
                }
                case 'E': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.DAYOFWEEK, false, text.length() < 4, text));
                    continue block23;
                }
                case 'H': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.HOUR, text));
                    continue block23;
                }
                case 'a': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.HALFDAY, false, false, text));
                    continue block23;
                }
                case 'K': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.HOUROFHALFDAY, text));
                    continue block23;
                }
                case 'h': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.CLOCKHOUROFHALFDAY, text));
                    continue block23;
                }
                case 'k': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.CLOCKHOUR, text));
                    continue block23;
                }
                case 'm': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.MINUTE, text));
                    continue block23;
                }
                case 's': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.SECOND, text));
                    continue block23;
                }
                case 'S': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.MILLISECOND, text));
                    continue block23;
                }
                case 'z': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.TIMEZONE, false, text.length() < 4, text));
                    continue block23;
                }
                case 'Z': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.TIMEZONE, true, false, text));
                    continue block23;
                }
            }
            ret.add(new FormatPatternPart(FormatPatternPartType.TEXT, false, false, text));
        }
        FormatPattern clean = new FormatPattern();
        StringBuilder currentText = new StringBuilder();
        for (FormatPatternPart part : ret) {
            if (part.type == FormatPatternPartType.TEXT) {
                currentText.append(part.text);
                continue;
            }
            if (currentText.length() > 0) {
                clean.add(new FormatPatternPart(FormatPatternPartType.TEXT, false, false, currentText.toString()));
                currentText.delete(0, currentText.length());
            }
            clean.add(part);
        }
        if (currentText.length() > 0) {
            clean.add(new FormatPatternPart(FormatPatternPartType.TEXT, false, false, currentText.toString()));
        }
        return clean;
    }

    static FormatPattern parseSimpleDateFormatPattern(String pattern) {
        FormatPattern ret = new FormatPattern();
        if (pattern == null || pattern.length() == 0) {
            return ret;
        }
        int p = 0;
        int l = pattern.length();
        block21: while (p < l) {
            int en;
            int st;
            char c = pattern.charAt(p);
            if (c == '\'') {
                st = ++p;
                while (p < l && (pattern.charAt(p) != '\'' || p + 1 < l && pattern.charAt(p + 1) == '\'')) {
                    if (pattern.charAt(p) != '\'') {
                        ++p;
                        continue;
                    }
                    p += 2;
                }
                if (p >= l) {
                    en = l - 1;
                } else {
                    en = p - 1;
                    ++p;
                }
                String quoted = pattern.substring(st, en + 1);
                quoted = quoted.replace("''", "'");
                if (quoted.length() == 0) {
                    quoted = "'";
                }
                ret.add(new FormatPatternPart(FormatPatternPartType.TEXT, false, false, quoted));
                continue;
            }
            st = p;
            while (p < l && pattern.charAt(p) == c) {
                ++p;
            }
            en = p - 1;
            String text = pattern.substring(st, en + 1);
            switch (c) {
                case 'G': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.ERA, false, false, text));
                    continue block21;
                }
                case 'y': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.YEAR, true, text.length() == 2, text));
                    continue block21;
                }
                case 'Y': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.WEEKYEAR, true, text.length() == 2, text));
                    continue block21;
                }
                case 'M': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.MONTH, text.length() <= 2, text.length() == 3, text));
                    continue block21;
                }
                case 'w': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.WEEK, text));
                    continue block21;
                }
                case 'D': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.DAYOFYEAR, text));
                    continue block21;
                }
                case 'd': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.DAY, text));
                    continue block21;
                }
                case 'F': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.DAYOFWEEK, text));
                    continue block21;
                }
                case 'E': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.DAYOFWEEK, false, text.length() < 4, text));
                    continue block21;
                }
                case 'H': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.HOUR, text));
                    continue block21;
                }
                case 'a': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.HALFDAY, false, false, text));
                    continue block21;
                }
                case 'K': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.HOUROFHALFDAY, text));
                    continue block21;
                }
                case 'h': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.CLOCKHOUROFHALFDAY, text));
                    continue block21;
                }
                case 'k': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.CLOCKHOUR, text));
                    continue block21;
                }
                case 'm': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.MINUTE, text));
                    continue block21;
                }
                case 's': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.SECOND, text));
                    continue block21;
                }
                case 'S': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.MILLISECOND, text));
                    continue block21;
                }
                case 'z': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.TIMEZONE, false, text.length() < 4, text));
                    continue block21;
                }
                case 'Z': {
                    ret.add(new FormatPatternPart(FormatPatternPartType.TIMEZONE, true, false, text));
                    continue block21;
                }
            }
            ret.add(new FormatPatternPart(FormatPatternPartType.TEXT, false, false, text));
        }
        FormatPattern clean = new FormatPattern();
        StringBuilder currentText = new StringBuilder();
        for (FormatPatternPart part : ret) {
            if (part.type == FormatPatternPartType.TEXT) {
                currentText.append(part.text);
                continue;
            }
            if (currentText.length() > 0) {
                clean.add(new FormatPatternPart(FormatPatternPartType.TEXT, false, false, currentText.toString()));
                currentText.delete(0, currentText.length());
            }
            clean.add(part);
        }
        if (currentText.length() > 0) {
            clean.add(new FormatPatternPart(FormatPatternPartType.TEXT, false, false, currentText.toString()));
        }
        return clean;
    }

    public static boolean isISO8601FormatString(String format) {
        return ISO_FORMAT_LOCAL.equals(format) || "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".equals(format);
    }

    public static class FormatPattern
    extends ArrayList<FormatPatternPart> {
        private static final long serialVersionUID = 1L;

        public String toApproximateRegex(Locale locale) {
            StringBuilder sb = new StringBuilder();
            String toEscape = "(){}[]|?!+-*.\\^$";
            sb.append("^");
            block17: for (FormatPatternPart part : this) {
                switch (part.type) {
                    case TEXT: {
                        for (char c : part.text.toLowerCase().toCharArray()) {
                            if (toEscape.indexOf(c) >= 0) {
                                sb.append('\\');
                            }
                            sb.append(c);
                        }
                        continue block17;
                    }
                    case ERA: {
                        HashSet possible = Sets.newHashSet();
                        for (String s : DateFormatSymbols.getInstance(locale).getEras()) {
                            possible.add(s.toLowerCase(locale));
                        }
                        sb.append("(" + Joiner.on((String)"|").join((Iterable)possible) + ")");
                        break;
                    }
                    case CENTURY: {
                        sb.append("[0-9]{1,2}");
                        break;
                    }
                    case YEAROFERA: 
                    case WEEKYEAR: 
                    case YEAR: {
                        if (part.shortened) {
                            sb.append("[0-9]{2}");
                            break;
                        }
                        sb.append("[0-9]{4}");
                        break;
                    }
                    case MONTH: {
                        if (part.numeric) {
                            sb.append("((0?[1-9])|(1[012]))");
                            break;
                        }
                        HashSet possible = Sets.newHashSet();
                        for (String s : DateFormatSymbols.getInstance(locale).getShortMonths()) {
                            if (s.length() <= 0) continue;
                            possible.add(s.toLowerCase(locale));
                        }
                        sb.append("(" + Joiner.on((String)"|").join((Iterable)possible) + ")[a-z.-]*");
                        break;
                    }
                    case DAY: {
                        sb.append("((0?[1-9])|([12][0-9])|(3[01]))");
                        break;
                    }
                    case DAYOFYEAR: {
                        sb.append("((0?0?[1-9])|(0?[1-9][0-9])|([123][0-9][0-9]))");
                        break;
                    }
                    case WEEK: {
                        sb.append("((0?[1-9])|([1-4][0-9])|(5[0-3]))");
                        break;
                    }
                    case DAYOFWEEK: {
                        if (part.numeric) {
                            sb.append("[1-7]");
                            break;
                        }
                        HashSet possible = Sets.newHashSet();
                        for (String s : DateFormatSymbols.getInstance(locale).getShortWeekdays()) {
                            if (s.length() <= 0) continue;
                            possible.add(s.toLowerCase(locale));
                        }
                        sb.append("(" + Joiner.on((String)"|").join((Iterable)possible) + ")[a-z.-]*");
                        break;
                    }
                    case HALFDAY: {
                        HashSet possible = Sets.newHashSet();
                        for (String s : DateFormatSymbols.getInstance(locale).getAmPmStrings()) {
                            possible.add(s.toLowerCase(locale));
                        }
                        sb.append("(" + Joiner.on((String)"|").join((Iterable)possible) + ")");
                        break;
                    }
                    case HOUR: 
                    case CLOCKHOUR: {
                        sb.append("((0?[0-9])|(1[0-9])|(2[0-4]))");
                        break;
                    }
                    case CLOCKHOUROFHALFDAY: 
                    case HOUROFHALFDAY: {
                        sb.append("((0?[0-9])|(1[012]))");
                        break;
                    }
                    case MINUTE: 
                    case SECOND: {
                        sb.append("((0?[0-9])|([1-5][0-9]))");
                        break;
                    }
                    case MILLISECOND: {
                        sb.append("[0-9]{1,6}");
                        break;
                    }
                    case TIMEZONE: {
                        sb.append("(((\\+|\\-)?[0-9.:]+)|([a-z /.\\-]+))");
                    }
                }
            }
            sb.append("$");
            return sb.toString();
        }

        @Override
        public String toString() {
            ArrayList chunks = Lists.newArrayList();
            for (FormatPatternPart part : this) {
                chunks.add(part.toString());
            }
            return "[" + Joiner.on((String)",").join((Iterable)chunks) + "]";
        }

        public boolean hasAll(FormatPatternPartType ... types) {
            HashSet expected = Sets.newHashSet(Arrays.asList(types));
            HashSet actual = Sets.newHashSet();
            for (FormatPatternPart part : this) {
                actual.add(part.type);
            }
            return actual.containsAll(expected);
        }

        public boolean hasAny(FormatPatternPartType ... types) {
            HashSet expected = Sets.newHashSet(Arrays.asList(types));
            HashSet actual = Sets.newHashSet();
            for (FormatPatternPart part : this) {
                actual.add(part.type);
            }
            return !Sets.intersection((Set)actual, (Set)expected).isEmpty();
        }

        public List<FormatPatternPartType> getPartTypes() {
            ArrayList ret = Lists.newArrayList();
            for (FormatPatternPart part : this) {
                ret.add(part.type);
            }
            return ret;
        }
    }

    public static class FormatPatternPart {
        public final FormatPatternPartType type;
        public final boolean numeric;
        public final int length;
        public final String text;
        public final boolean shortened;

        public FormatPatternPart(FormatPatternPartType type, String text) {
            this(type, true, false, text);
        }

        public FormatPatternPart(FormatPatternPartType type, boolean numeric, boolean shortened, String text) {
            this.type = type;
            this.numeric = numeric;
            this.shortened = shortened;
            this.length = text.length();
            this.text = text;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.length;
            result = 31 * result + (this.numeric ? 1231 : 1237);
            result = 31 * result + (this.shortened ? 1231 : 1237);
            result = 31 * result + this.text.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FormatPatternPart other = (FormatPatternPart)obj;
            if (this.length != other.length) {
                return false;
            }
            if (this.numeric != other.numeric) {
                return false;
            }
            if (this.shortened != other.shortened) {
                return false;
            }
            if (!this.text.equals(other.text)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "{" + String.valueOf((Object)this.type) + " l=" + this.length + " n=" + this.numeric + " s=" + this.shortened + " " + this.text + "}";
        }
    }

    public static enum FormatPatternPartType {
        ERA,
        CENTURY,
        YEAR,
        YEAROFERA,
        WEEKYEAR,
        MONTH,
        WEEK,
        DAY,
        DAYOFWEEK,
        DAYOFYEAR,
        HOUR,
        CLOCKHOUR,
        HALFDAY,
        HOUROFHALFDAY,
        CLOCKHOUROFHALFDAY,
        MINUTE,
        SECOND,
        MILLISECOND,
        TIMEZONE,
        TEXT;

    }
}

