/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import java.util.ArrayList;
import java.util.List;

public class PrettyArray {
    private List<List<String>> matrix = new ArrayList<List<String>>();
    private List<Integer> line = new ArrayList<Integer>();
    private String tab = " ";
    private String beginChar = "| ";
    private String betweenChar = " | ";
    private String endChar = " |";
    private String lineChar = "-";
    private String lineCellSeparator = "-+-";
    private String lineBeginChar = "|-";
    private String lineEndChar = "-|";
    private boolean indentLast = true;
    private Align align = Align.LEFT;
    private boolean trailingLine = false;

    public void add(List<String> row) {
        this.matrix.add(row);
    }

    public void print() {
        int i;
        ArrayList<Integer> colSize = new ArrayList<Integer>();
        for (List<String> row : this.matrix) {
            for (i = 0; i < row.size(); ++i) {
                String str = row.get(i);
                if (colSize.size() == i) {
                    colSize.add(str.length());
                    continue;
                }
                colSize.set(i, Math.max((Integer)colSize.get(i), str.length()));
            }
        }
        for (List<String> row : this.matrix) {
            i = 0;
            if (this.line.contains(i)) {
                this.line(colSize);
            }
            int size = row.size();
            System.out.print(this.beginChar);
            for (String cell : row) {
                boolean isLast;
                int indentSize = (Integer)colSize.get(i) - cell.length();
                boolean bl = isLast = i + 1 == size;
                if (isLast) {
                    if (this.indentLast) {
                        if (i + 1 == colSize.size()) {
                            this.print(cell, indentSize, this.endChar);
                        } else {
                            this.print(cell, indentSize, this.betweenChar);
                        }
                    } else {
                        this.print(cell, -1, this.endChar);
                    }
                } else {
                    this.print(cell, indentSize, this.betweenChar);
                }
                ++i;
            }
            if (this.indentLast) {
                for (int j = size; j < colSize.size(); ++j) {
                    this.indent((Integer)colSize.get(j));
                    if (j + 1 != colSize.size()) {
                        this.indent(this.betweenChar.length());
                        continue;
                    }
                    System.out.print(this.endChar);
                }
            }
            System.out.println();
        }
        if (this.trailingLine) {
            this.line(colSize);
        }
    }

    public void rawPrint() {
        for (List<String> row : this.matrix) {
            for (String cell : row) {
                System.out.print(cell + "\t");
            }
            System.out.println();
        }
    }

    public String getTab() {
        return this.tab;
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public void setBeginChar(String beginChar) {
        this.beginChar = beginChar;
    }

    public void setBetweenChar(String betweenChar) {
        this.betweenChar = betweenChar;
    }

    public void setEndChar(String endChar) {
        this.endChar = endChar;
    }

    public void setLineChar(String lineChar) {
        this.lineChar = lineChar;
    }

    public void setLineCellSeparator(String lineCellSeparator) {
        this.lineCellSeparator = lineCellSeparator;
    }

    public void setLineBeginChar(String lineBeginChar) {
        this.lineBeginChar = lineBeginChar;
    }

    public void setLineEndChar(String lineEndChar) {
        this.lineEndChar = lineEndChar;
    }

    public void setIndentLast(boolean indentLast) {
        this.indentLast = indentLast;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public void addLineAt(int idx) {
        this.line.add(idx);
    }

    public void setTrailingLine(boolean trailingLine) {
        this.trailingLine = trailingLine;
    }

    public String getBeginChar() {
        return this.beginChar;
    }

    public String getBetweenChar() {
        return this.betweenChar;
    }

    public String getEndChar() {
        return this.endChar;
    }

    public String getLineChar() {
        return this.lineChar;
    }

    public String getLineCellSeparator() {
        return this.lineCellSeparator;
    }

    public String getLineBeginChar() {
        return this.lineBeginChar;
    }

    public String getLineEndChar() {
        return this.lineEndChar;
    }

    public boolean getIndentLast() {
        return this.indentLast;
    }

    public Align getAlign() {
        return this.align;
    }

    public boolean getTrailingLine() {
        return this.trailingLine;
    }

    private void indent(int size) {
        for (int i = 0; i < size; ++i) {
            System.out.print(this.tab);
        }
    }

    private void indent(int size, Align from) {
        if (this.align == Align.CENTER) {
            if (from == Align.LEFT) {
                this.indent(size / 2);
            } else {
                this.indent(size / 2 + size % 2);
            }
        } else if (this.align != from) {
            this.indent(size);
        }
    }

    private void print(String cell, int indentSize, String separator) {
        this.indent(indentSize, Align.LEFT);
        System.out.print(cell);
        this.indent(indentSize, Align.RIGHT);
        System.out.print(separator);
    }

    private void line(List<Integer> colsSize) {
        System.out.print(this.lineBeginChar);
        int cellNumber = 0;
        for (Integer colSize : colsSize) {
            for (int i = 0; i < colSize; ++i) {
                System.out.print(this.lineChar);
            }
            if (++cellNumber >= colsSize.size()) {
                System.out.print(this.lineEndChar);
                continue;
            }
            System.out.print(this.lineCellSeparator);
        }
        System.out.println();
    }

    public static enum Align {
        LEFT,
        RIGHT,
        CENTER;

    }
}

