/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.polyjson;

import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dip.utils.polyjson.PolyJSONAdapterFactory;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class PolyClassMetadata {
    private final Map<String, Class<?>> typeToClass = new HashMap();
    public final Map<Class<?>, String> classToType = new HashMap();
    private final Class<?> annotatedClass;
    private final String typeProperty;
    private final PolyJSONAdapterFactory factory;
    @Nullable
    private final Class<? extends Enum<?>> enumClass;
    @Nullable
    private final Map<String, Enum<?>> typeToEnum;
    @Nullable
    private final String defaultType;

    public PolyClassMetadata(PolyJSONAdapterFactory factory, Class<?> annotatedClass, String typeProperty, Class<? extends Enum<?>> enumClass, String defaultType) {
        this.factory = factory;
        this.annotatedClass = annotatedClass;
        this.typeProperty = typeProperty;
        this.defaultType = defaultType;
        if (enumClass == PolyJSON.NoEnumClass.class) {
            this.typeToEnum = null;
            this.enumClass = null;
        } else {
            this.typeToEnum = PolyClassMetadata.listEnumValues(enumClass);
            this.enumClass = enumClass;
        }
    }

    private static Map<String, Enum<?>> listEnumValues(Class<? extends Enum<?>> enumClass) {
        Map<String, Enum<?>> valueToEnum;
        Object[] enumValues;
        try {
            enumValues = (Enum[])enumClass.getMethod("values", new Class[0]).invoke(null, new Object[0]);
            valueToEnum = Arrays.stream(enumValues).collect(Collectors.toMap(Enum::toString, Function.identity()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot list values of enum " + String.valueOf(enumClass), e);
        }
        if (valueToEnum.size() != enumValues.length) {
            throw new IllegalArgumentException("Enum " + String.valueOf(enumClass) + " contains duplicate values: " + StringUtils.join((Object[])enumValues, (String)","));
        }
        return valueToEnum;
    }

    public Class<?> getAnnotatedClass() {
        return this.annotatedClass;
    }

    public String getTypeProperty() {
        return this.typeProperty;
    }

    public PolyJSONAdapterFactory getFactory() {
        return this.factory;
    }

    public synchronized String getTypeFromClass(Class<?> clazz) {
        return this.classToType.get(clazz);
    }

    synchronized Enum<?> getEnumFromClass(Class<?> clazz) {
        String type = this.getTypeFromClass(clazz);
        if (type != null && this.typeToEnum != null) {
            return this.typeToEnum.get(type);
        }
        return null;
    }

    synchronized String getCanonicalType(String type) {
        return this.classToType.get(this.typeToClass.get(type));
    }

    public synchronized Class<?> getClassFromType(String type) {
        return this.typeToClass.get(type);
    }

    @Nullable
    public String getDefaultType() {
        return this.defaultType;
    }

    public synchronized List<String> getAllPossibleTypesFromBaseClass(Class<?> baseClass) {
        return this.typeToClass.entrySet().stream().filter(entry -> baseClass.isAssignableFrom((Class)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public synchronized List<Class<?>> listSubClasses() {
        return new ArrayList(this.classToType.keySet());
    }

    synchronized void storeMapping(String type, String[] typeAliases, Class<?> subClass) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (subClass == null || !this.annotatedClass.isAssignableFrom(subClass) || this.annotatedClass.equals(subClass) || subClass.isInterface() || Modifier.isAbstract(subClass.getModifiers())) {
            throw new IllegalArgumentException("Expected " + String.valueOf(subClass) + " to be a concrete subclass of " + String.valueOf(this.annotatedClass));
        }
        try {
            subClass.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.valueOf(subClass) + " should have a default constructor (or cannot be a non-static inner class)");
        }
        Class<?> existingSubclassForType = this.typeToClass.get(type);
        if (existingSubclassForType != null) {
            throw new IllegalArgumentException("Could not register " + String.valueOf(subClass) + " because " + String.valueOf(existingSubclassForType) + " already registered for type \"" + type + "\" in " + String.valueOf(this.annotatedClass));
        }
        for (String typeAlias : typeAliases) {
            existingSubclassForType = this.typeToClass.get(typeAlias);
            if (existingSubclassForType == null) continue;
            throw new IllegalArgumentException("Could not register " + String.valueOf(subClass) + " because " + String.valueOf(existingSubclassForType) + " already registered for type \"" + type + "\" in " + String.valueOf(this.annotatedClass));
        }
        String existingTypeForSubclass = this.classToType.get(subClass);
        if (existingTypeForSubclass != null) {
            throw new IllegalArgumentException(String.valueOf(subClass) + " already registered with type \"" + existingTypeForSubclass + "\" in " + String.valueOf(this.annotatedClass));
        }
        this.typeToClass.put(type, subClass);
        this.classToType.put(subClass, type);
        for (String typeAlias : typeAliases) {
            this.typeToClass.put(typeAlias, subClass);
        }
    }

    public synchronized void compareTypesAndEnumValues() {
        if (this.typeToEnum == null) {
            return;
        }
        for (Map.Entry<Class<?>, String> entry : this.classToType.entrySet()) {
            String type = entry.getValue();
            Class<?> clazz = entry.getKey();
            if (this.typeToEnum.containsKey(type)) continue;
            throw new IllegalArgumentException("Could not register " + String.valueOf(clazz) + " because enum " + String.valueOf(this.enumClass) + " does not contain value " + type + " (expected one of " + StringUtils.join(this.typeToEnum.keySet(), (String)",") + ")");
        }
        for (String type : this.typeToEnum.keySet()) {
            Class<?> clazz = this.typeToClass.get(type);
            if (clazz != null && Objects.equals(this.classToType.get(clazz), type)) continue;
            throw new IllegalArgumentException("Value \"" + type + "\" in enum " + String.valueOf(this.enumClass) + " does not have a correspond mapping in @PolyJSON annotated " + String.valueOf(this.annotatedClass));
        }
    }
}

