/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.polyjson;

import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyClassMetadata;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dip.utils.polyjson.PolyJSONAdapter;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public class PolyJSONAdapterFactory
implements TypeAdapterFactory {
    private final Map<Class<?>, PolyClassMetadata> registry = Maps.newHashMap();
    private final Map<Class<?>, Enum<?>> cachedMappingClassToEnum = new ConcurrentHashMap();
    private final Map<Class<?>, String> cachedMappingClassToType = new ConcurrentHashMap();

    public <T, U extends T> void register(Class<T> baseClass, Class<U> subClass, String type) {
        PolyClassMetadata metadata = this.getOrCreateMetadataForClass(baseClass);
        if (metadata.getAnnotatedClass() != baseClass) {
            throw new IllegalArgumentException("Expected " + String.valueOf(baseClass) + " to have PolyJSON() annotation");
        }
        DKUtils.forceInit(subClass);
        metadata.storeMapping(type, new String[0], subClass);
    }

    public String getType(Object object) {
        return this.getType(object.getClass());
    }

    public Enum<?> getEnumType(Object object) {
        return this.getEnumType(object.getClass());
    }

    public PolyClassMetadata getMetadata(Class<?> clazz) {
        Pair<Class<?>, PolyJSON> classAndAnnotation = PolyJSONAdapterFactory.findAnnotatedClassInHierarchy(clazz);
        if (classAndAnnotation == null) {
            return null;
        }
        PolyClassMetadata metadata = this.initAndLookupRegistry((Class)classAndAnnotation.first, (PolyJSON)classAndAnnotation.second);
        DKUtils.forceInit(clazz);
        for (Class<?> subClass2 : metadata.listSubClasses()) {
            DKUtils.forceInit(subClass2);
        }
        if (!Modifier.isAbstract(clazz.getModifiers()) && metadata.listSubClasses().stream().noneMatch(subClass -> subClass == clazz)) {
            throw new IllegalArgumentException("Missing @Mapping for non-abstract class " + clazz.getName() + " in @PolyJSON annotation");
        }
        return metadata;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Class clazz = typeToken.getRawType();
        PolyClassMetadata metadata = this.getMetadata(clazz);
        if (metadata == null) {
            return null;
        }
        return new PolyJSONAdapter(gson, clazz, metadata);
    }

    private static Pair<Class<?>, PolyJSON> findAnnotatedClassInHierarchy(Class<?> aClass) {
        Pair output = null;
        while (aClass != null) {
            PolyJSON annotation = aClass.getAnnotation(PolyJSON.class);
            if (annotation != null) {
                if (aClass.isInterface()) {
                    throw new IllegalArgumentException("@PolyJSON cannot target interfaces (" + String.valueOf(aClass) + ")");
                }
                if (output != null) {
                    throw new IllegalArgumentException("Unexpected multiple @PolyJSON annotations in hierarchy (" + String.valueOf(aClass) + " and " + String.valueOf(output.first) + ")");
                }
                if (!Modifier.isAbstract(aClass.getModifiers())) {
                    throw new IllegalArgumentException("@PolyJSON can only target abstract classes (" + String.valueOf(aClass) + ")");
                }
                output = new Pair(aClass, annotation);
            }
            aClass = aClass.getSuperclass();
        }
        return output;
    }

    private PolyClassMetadata getOrCreateMetadataForClass(Class<?> clazz) {
        Pair<Class<?>, PolyJSON> classAndAnnotation = PolyJSONAdapterFactory.findAnnotatedClassInHierarchy(clazz);
        if (classAndAnnotation == null) {
            throw new IllegalArgumentException("Expected " + String.valueOf(clazz) + " or a parent to have PolyJSON() annotation");
        }
        DKUtils.forceInit(clazz);
        return this.initAndLookupRegistry((Class)classAndAnnotation.first, (PolyJSON)classAndAnnotation.second);
    }

    private synchronized PolyClassMetadata initAndLookupRegistry(Class<?> annotatedClass, PolyJSON annotation) {
        if (!this.registry.containsKey(annotatedClass)) {
            String typeProperty = annotation.typeProperty();
            if (StringUtils.isBlank((String)typeProperty)) {
                throw new IllegalArgumentException("Invalid 'typeProperty' in PolyJSON annotation of " + String.valueOf(annotatedClass));
            }
            PolyClassMetadata metadata = new PolyClassMetadata(this, annotatedClass, typeProperty, annotation.enumClass(), annotation.defaultType());
            for (Mapping mapping : annotation.value()) {
                if (!annotatedClass.isAssignableFrom(mapping.value())) {
                    throw new IllegalArgumentException("Expected " + String.valueOf(mapping.value()) + " to be a subclass of " + String.valueOf(annotatedClass));
                }
                metadata.storeMapping(mapping.type(), mapping.typeAliases(), mapping.value());
            }
            metadata.compareTypesAndEnumValues();
            this.registry.put(annotatedClass, metadata);
        }
        return this.registry.get(annotatedClass);
    }

    private String getType(Class<?> clazz) {
        PolyClassMetadata metadata;
        String type = this.cachedMappingClassToType.get(clazz);
        if (type == null && (type = (metadata = this.getOrCreateMetadataForClass(clazz)).getTypeFromClass(clazz)) != null) {
            this.cachedMappingClassToType.put(clazz, type);
        }
        if (type == null) {
            throw new IllegalArgumentException("No PolyJSON type mapping exists for class " + String.valueOf(clazz));
        }
        return type;
    }

    private Enum<?> getEnumType(Class<?> clazz) {
        PolyClassMetadata metadata;
        Enum<?> enumValue = this.cachedMappingClassToEnum.get(clazz);
        if (enumValue == null && (enumValue = (metadata = this.getOrCreateMetadataForClass(clazz)).getEnumFromClass(clazz)) != null) {
            this.cachedMappingClassToEnum.put(clazz, enumValue);
        }
        if (enumValue == null) {
            throw new IllegalArgumentException("No PolyJSON enum mapping exists for class " + String.valueOf(clazz));
        }
        return enumValue;
    }
}

