/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.dao.impl.FilesBasedUsersDAO;
import com.dataiku.gh.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class AddUserCommand
extends CLICommandWithInvalidateCommonFilesCache {
    public String login;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.add-user");

    @Override
    public String usageString() {
        return "add-user [options] LOGIN";
    }

    @Override
    public String description() {
        return "Adds a user to the Dataiku Govern database";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        options.addOption("admin", false, "Add user to default administrators group");
        options.addOption("displayName", true, "User full name (e.g. \"FIRST_NAME LAST_NAME\")");
        options.addOption("email", true, "User email");
        options.addOption("group", true, "Add user to group <arg> (may be specified multiple times)");
        options.addOption("ldap", false, "Add LDAP user (default: add local user)");
        options.addOption("password", true, "Set user password");
        options.addOption("profile", true, "Set user profile");
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "add-user", true);
        if (cmdLine.getArgs().length < 2) {
            return this.usage(1, "Missing login argument");
        }
        if (cmdLine.hasOption("ldap") && cmdLine.hasOption("password")) {
            return this.usage(1, "Cannot set password for LDAP users");
        }
        this.login = cmdLine.getArgs()[1];
        String displayName = cmdLine.getOptionValue("displayName", this.login);
        String email = cmdLine.getOptionValue("email");
        String password = cmdLine.getOptionValue("password");
        ArrayList<String> groups = new ArrayList<String>();
        if (cmdLine.hasOption("group")) {
            Collections.addAll(groups, cmdLine.getOptionValues("group"));
        }
        GHSpring.doCLISetup();
        try (RWTransaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginWriteAsDSS();){
            UsersDAO.User user;
            FilesBasedUsersDAO ud = new FilesBasedUsersDAO();
            for (String g : groups) {
                if (ud.getGroup(g) != null) continue;
                int n = this.usage(1, "Group " + g + " does not exist");
                return n;
            }
            String profile = null;
            if (cmdLine.hasOption("profile")) {
                profile = cmdLine.getOptionValue("profile");
            }
            if (password == null) {
                UserSourceType sourceType = cmdLine.hasOption("ldap") ? UserSourceType.LDAP : UserSourceType.LOCAL_NO_AUTH;
                user = new UsersDAO.User(this.login, sourceType);
                user.displayName = displayName;
                user.email = email;
                user.groups = groups;
                user.userProfile = profile;
                ud.addForeignUser(user);
            } else {
                user = ud.addUser(this.login, password);
                user.displayName = displayName;
                user.email = email;
                user.groups.addAll(groups);
            }
            if (profile != null) {
                user.userProfile = profile;
            }
            if (cmdLine.hasOption("admin")) {
                user.groups.add(ud.getDefaultAdminGroup((boolean)true).name);
            }
            ud.saveUser(user);
            t.commit("CLI: Added a new user: " + user.login + " (" + user.displayName + ")");
        }
        return 0;
    }

    @Override
    void onPostExecute() {
        super.onPostExecute();
        try (LocalBackendPrivilegedIntercomAPIClient client = new LocalBackendPrivilegedIntercomAPIClient();){
            client.postObject("dip/api/pintercom/users-mappings/sync", Void.class, new JsonObject());
        }
        catch (Exception e) {
            logger.warn((Object)"User mapping sync failed, Dataiku Govern server not running? If it is running, you should restart Dataiku Govern", (Throwable)e);
        }
    }
}

