/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.dao.impl.FilesBasedUsersDAO;
import com.dataiku.gh.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.google.gson.JsonObject;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class RemoveUserCommand
extends CLICommandWithInvalidateCommonFilesCache {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.remove-user");

    @Override
    public String usageString() {
        return "remove-user LOGIN";
    }

    @Override
    public String description() {
        return "Remove a user from the DSS configuration";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, "remove-user", true);
        if (cmdLine.getArgs().length < 2) {
            return this.usage(1, "Missing argument");
        }
        String login = cmdLine.getArgs()[1];
        GHSpring.doCLISetup();
        try (RWTransaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginWriteAsDSS();){
            FilesBasedUsersDAO ud = new FilesBasedUsersDAO();
            ud.forceDeleteUser(login);
            t.commit("CLI: Removed user " + login);
        }
        return 0;
    }

    @Override
    public void onPostExecute() {
        super.onPostExecute();
        try (LocalBackendPrivilegedIntercomAPIClient client = new LocalBackendPrivilegedIntercomAPIClient();){
            client.postObject("dip/api/pintercom/users-mappings/sync", Void.class, new JsonObject());
        }
        catch (Exception e) {
            logger.warn((Object)"User mapping sync failed, Dataiku Govern server not running? If it is running, you should restart Dataiku Govern", (Throwable)e);
        }
    }
}

