/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.dss;

import com.dataiku.gh.core.models.dss.IDSSArtifactContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class AbstractDSSProjectArtifactsContainer<PROJECT extends IDSSArtifactContainer, BUNDLE extends IDSSArtifactContainer, DATASET extends IDSSArtifactContainer, SAVEDMODEL extends IDSSArtifactContainer, RETRIEVABLEKNOWLEDGE extends IDSSArtifactContainer, SAVEDMODELVERSION extends IDSSArtifactContainer> {
    private PROJECT dssProject = null;
    private final Map<String, BUNDLE> dssBundles = new HashMap<String, BUNDLE>();
    private final Map<String, DATASET> dssDatasets = new HashMap<String, DATASET>();
    private final Map<String, SAVEDMODEL> dssSavedModels = new HashMap<String, SAVEDMODEL>();
    private final Map<String, RETRIEVABLEKNOWLEDGE> dssRetrievableKnowledges = new HashMap<String, RETRIEVABLEKNOWLEDGE>();
    private final Map<String, SAVEDMODELVERSION> dssSavedModelVersions = new HashMap<String, SAVEDMODELVERSION>();
    public final List<IDSSArtifactContainer> duplicatedArtifacts = new ArrayList<IDSSArtifactContainer>();

    public PROJECT getDSSProject() {
        return this.dssProject;
    }

    public Map<String, BUNDLE> getDSSBundles() {
        return this.dssBundles;
    }

    public Map<String, DATASET> getDSSDatasets() {
        return this.dssDatasets;
    }

    public Map<String, SAVEDMODEL> getDSSSavedModels() {
        return this.dssSavedModels;
    }

    public Map<String, RETRIEVABLEKNOWLEDGE> getDSSRetrievableKnowledges() {
        return this.dssRetrievableKnowledges;
    }

    public Map<String, SAVEDMODELVERSION> getDSSSavedModelVersions() {
        return this.dssSavedModelVersions;
    }

    public void setProject(PROJECT container) {
        if (this.dssProject == null) {
            this.dssProject = container;
        } else {
            this.duplicatedArtifacts.add((IDSSArtifactContainer)container);
        }
    }

    public void replaceProject(PROJECT container) {
        this.dssProject = container;
    }

    public void addBundle(BUNDLE container) {
        this.checkDuplicateAndAdd(this::getDSSBundles, (IDSSArtifactContainer)container);
    }

    public void replaceBundle(BUNDLE container) {
        this.dssBundles.put(container.getIdentifier(), container);
    }

    public void addDataset(DATASET container) {
        this.checkDuplicateAndAdd(this::getDSSDatasets, (IDSSArtifactContainer)container);
    }

    public void replaceDataset(DATASET container) {
        this.dssDatasets.put(container.getIdentifier(), container);
    }

    public void addSavedModel(SAVEDMODEL container) {
        this.checkDuplicateAndAdd(this::getDSSSavedModels, (IDSSArtifactContainer)container);
    }

    public void replaceSavedModel(SAVEDMODEL container) {
        this.dssSavedModels.put(container.getIdentifier(), container);
    }

    public void addRetrievableKnowledge(RETRIEVABLEKNOWLEDGE container) {
        this.checkDuplicateAndAdd(this::getDSSRetrievableKnowledges, (IDSSArtifactContainer)container);
    }

    public void replaceRetrievableKnowledge(RETRIEVABLEKNOWLEDGE container) {
        this.dssRetrievableKnowledges.put(container.getIdentifier(), container);
    }

    public void addSavedModelVersion(SAVEDMODELVERSION container) {
        this.checkDuplicateAndAdd(this::getDSSSavedModelVersions, (IDSSArtifactContainer)container);
    }

    public void replaceSavedModelVersion(SAVEDMODELVERSION container) {
        this.dssSavedModelVersions.put(container.getIdentifier(), container);
    }

    private <T extends IDSSArtifactContainer> void checkDuplicateAndAdd(Supplier<Map<String, T>> getTarget, T container) {
        Map<String, T> map = getTarget.get();
        if (map.containsKey(container.getIdentifier())) {
            this.duplicatedArtifacts.add(container);
        } else {
            map.put(container.getIdentifier(), container);
        }
    }
}

