/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.roles.permissions;

import com.dataiku.gh.core.visitors.IBlueprintPermissionsVisitor;
import java.util.Objects;

public class FieldPermissionsItem {
    public boolean read;
    public boolean write;

    public boolean hasReadPermission() {
        return this.read || this.write;
    }

    public boolean hasWritePermission() {
        return this.write;
    }

    public boolean hasAllPermissions() {
        return this.hasReadPermission() && this.hasWritePermission();
    }

    public boolean hasAnyPermissions() {
        return this.hasReadPermission() || this.hasWritePermission();
    }

    public boolean hasNoPermissions() {
        return !this.hasAnyPermissions();
    }

    public FieldPermissionsItem mergeWith(FieldPermissionsItem fieldPermissionsItem) {
        this.read = this.hasReadPermission() || fieldPermissionsItem.hasReadPermission();
        this.write = this.hasWritePermission() || fieldPermissionsItem.hasWritePermission();
        return this;
    }

    public void accept(IBlueprintPermissionsVisitor blueprintPermissionsVisitor, String fieldId) {
        blueprintPermissionsVisitor.visit(fieldId, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldPermissionsItem)) {
            return false;
        }
        FieldPermissionsItem fp = (FieldPermissionsItem)o;
        return Objects.equals(this.read, fp.read) && Objects.equals(this.write, fp.write);
    }

    public int hashCode() {
        return Objects.hash(this.read, this.write);
    }

    public static FieldPermissionsItem buildWithNoPermissions() {
        return FieldPermissionsItem.build(false, false);
    }

    public static FieldPermissionsItem buildWithAllPermissions() {
        return FieldPermissionsItem.build(true, true);
    }

    public static FieldPermissionsItem build(boolean read, boolean write) {
        FieldPermissionsItem fieldPermissionsItem = new FieldPermissionsItem();
        fieldPermissionsItem.read = read;
        fieldPermissionsItem.write = write;
        return fieldPermissionsItem;
    }
}

