/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.roles.permissions.BlueprintPermissions;
import com.dataiku.gh.core.services.roles_and_permissions.permissions.IAdminBlueprintPermissionsService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.auth.MetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIAdminBlueprintPermissionsController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IAdminBlueprintPermissionsService adminBlueprintPermissionsService;

    @AuditedCall(value={"msgType", "blueprint-permissions-list"})
    @RequestMapping(value={"/publicapi/admin/blueprint-permissions"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIAdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, this.adminBlueprintPermissionsService.listBlueprintPermissions(authCtx));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/blueprint-permissions"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_PERMISSIONS_CREATE)
    public void create(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            BlueprintPermissions blueprintRoleAssignments = (BlueprintPermissions)this.getRequestBodyAs(req, BlueprintPermissions.class);
            BlueprintPermissions createdBlueprintPermissions = this.adminBlueprintPermissionsService.createBlueprintPermissions(authCtx, blueprintRoleAssignments);
            this.auditTrailService.generic("blueprint-permissions-create").with("blueprintId", createdBlueprintPermissions.blueprintId).emit();
            PublicAPIAdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)createdBlueprintPermissions);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-permissions-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "blueprint-permissions-get", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint-permissions/{blueprintId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIAdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)this.adminBlueprintPermissionsService.getBlueprintPermissions(authCtx, blueprintId));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/blueprint-permissions/{blueprintId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_PERMISSIONS_SAVE)
    public void save(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            BlueprintPermissions blueprintRoleAssignments = (BlueprintPermissions)this.getRequestBodyAs(req, BlueprintPermissions.class);
            if (!StringUtils.equals((CharSequence)blueprintId, (CharSequence)blueprintRoleAssignments.blueprintId)) {
                throw new ValidationException("Blueprint IDs do not match: " + blueprintId + " , " + blueprintRoleAssignments.blueprintId);
            }
            BlueprintPermissions savedBlueprintPermissions = this.adminBlueprintPermissionsService.saveBlueprintPermissions(authCtx, blueprintRoleAssignments);
            this.auditTrailService.generic("blueprint-permissions-save").with("blueprintId", savedBlueprintPermissions.blueprintId).emit();
            PublicAPIAdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)savedBlueprintPermissions);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-permissions-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "blueprint-permissions-delete", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/publicapi/admin/blueprint-permissions/{blueprintId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.BLUEPRINT_PERMISSIONS_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String blueprintId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.adminBlueprintPermissionsService.deleteBlueprintPermissions(authCtx, blueprintId);
        PublicAPIAdminBlueprintPermissionsController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "blueprint-permissions-default-get"})
    @RequestMapping(value={"/publicapi/admin/blueprint-permissions/default"}, method={RequestMethod.GET})
    public void getDefault(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        PublicAPIAdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)this.adminBlueprintPermissionsService.getDefaultBlueprintPermissions(authCtx));
    }

    @AuditedCall(value={"msgType", "blueprint-permissions-default-save"})
    @RequestMapping(value={"/publicapi/admin/blueprint-permissions/default"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_PERMISSIONS_DEFAULT_SAVE)
    public void saveDefault(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        BlueprintPermissions blueprintPermissions = (BlueprintPermissions)this.getRequestBodyAs(req, BlueprintPermissions.class);
        BlueprintPermissions ret = this.adminBlueprintPermissionsService.saveDefaultBlueprintPermissions(authCtx, blueprintPermissions);
        PublicAPIAdminBlueprintPermissionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }
}

