/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.publicapi.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.custom_pages.CustomPage;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.custom_pages.IAdminCustomPagesService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.security.auth.MetaAuthService;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIAdminCustomPagesController
extends PublicAPIControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IAdminCustomPagesService adminCustomPagesService;

    @AuditedCall(value={"msgType", "admin-custom-page-get", "customPageId", "${customPageId}"})
    @RequestMapping(value={"/publicapi/admin/custom-page/{customPageId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String customPageId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        CustomPage customPage = this.adminCustomPagesService.getCustomPage(authCtx, customPageId);
        PublicAPIAdminCustomPagesController.writeJSON((HttpServletResponse)resp, (Object)customPage);
    }

    @AuditedCall(value={"msgType", "admin-custom-pages-list"})
    @RequestMapping(value={"/publicapi/admin/custom-pages"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        List<CustomPage> customPages = this.adminCustomPagesService.listCustomPages(authCtx);
        PublicAPIAdminCustomPagesController.writeJSON((HttpServletResponse)resp, customPages);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/custom-pages"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.CUSTOM_PAGE_CREATE)
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String newIdentifier) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            CustomPage customPage = (CustomPage)this.getRequestBodyAs(req, CustomPage.class);
            CustomPage createdCustomPage = this.adminCustomPagesService.createCustomPage(authCtx, customPage, newIdentifier);
            this.auditTrailService.generic("admin-custom-page-create").with("customPageId", createdCustomPage.id).emit();
            PublicAPIAdminCustomPagesController.writeJSON((HttpServletResponse)resp, (Object)createdCustomPage);
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-custom-page-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/custom-page/{customPageId}"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.CUSTOM_PAGE_SAVE)
    public void save(HttpServletRequest req, HttpServletResponse resp, @PathVariable String customPageId) throws Exception {
        try {
            AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
            CustomPage customPage = (CustomPage)this.getRequestBodyAs(req, CustomPage.class);
            if (!StringUtils.equals((CharSequence)customPageId, (CharSequence)customPage.id)) {
                throw new ValidationException("Custom pages IDs do not match: " + customPageId + " , " + customPage.id);
            }
            CustomPage savedCustomPage = this.adminCustomPagesService.saveCustomPage(authCtx, customPage);
            this.auditTrailService.generic("admin-custom-page-save").with("customPageId", savedCustomPage.id).emit();
            PublicAPIAdminCustomPagesController.writeJSON((HttpServletResponse)resp, (Object)savedCustomPage);
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-custom-page-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-custom-page-delete", "customPageId", "${customPageId}"})
    @RequestMapping(value={"/publicapi/admin/custom-page/{customPageId}"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.CUSTOM_PAGE_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String customPageId) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        this.adminCustomPagesService.deleteCustomPage(authCtx, customPageId);
        PublicAPIAdminCustomPagesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "admin-custom-page-order-save"})
    @RequestMapping(value={"/publicapi/admin/custom-pages/order"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.CUSTOM_PAGE_ORDER_SAVE)
    @ResponseBody
    public List<String> saveOrder(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        List customPageIds = (List)this.getRequestBodyAs(req, (TypeToken)new TypeToken<List<String>>(){});
        return this.adminCustomPagesService.saveOrder(authCtx, customPageIds);
    }

    @AuditedCall(value={"msgType", "admin-custom-page-order-get"})
    @RequestMapping(value={"/publicapi/admin/custom-pages/order"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getOrder(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        return this.adminCustomPagesService.getOrder(authCtx);
    }
}

