/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.ReferenceFieldDefinition;
import com.dataiku.gh.core.models.roles.assignments.RoleAssignmentsRule;
import com.dataiku.gh.core.models.roles.assignments.criteria.ArtifactDeletedCriterion;
import com.dataiku.gh.core.models.roles.assignments.criteria.ArtifactExistingCriterion;
import com.dataiku.gh.core.models.roles.assignments.criteria.ArtifactExistingFieldValueCriterion;
import com.dataiku.gh.core.models.roles.assignments.criteria.ArtifactExistingStatusCriterion;
import com.dataiku.gh.core.models.roles.assignments.criteria.BlueprintVersionIdCriterion;
import com.dataiku.gh.core.models.roles.assignments.criteria.Criterion;
import com.dataiku.gh.core.models.roles.audit.RolesAndPermissionsAudit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RoleAssignmentsComputationUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.blueprint-role-assignments-operators");

    public static Set<String> getInheritArtifactIds(EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.ArtifactsInheritanceLookupAudit artifactsInheritanceLookupAudit) {
        if (enrichedArtifact.blueprintRoleAssignments == null) {
            return Collections.emptySet();
        }
        List<String> fieldIds = enrichedArtifact.blueprintRoleAssignments.inheritArtifactFieldIds;
        if (CollectionUtils.isEmpty(fieldIds)) {
            return Collections.emptySet();
        }
        HashSet<String> resolvedArtifactIds = new HashSet<String>();
        for (String fieldId : fieldIds) {
            RolesAndPermissionsAudit.ArtifactInheritanceLookupFieldAudit fieldAudit = artifactsInheritanceLookupAudit.addArtifactInheritanceLookupFieldAudit(fieldId);
            FieldDefinition fieldDefinition = fieldAudit.fieldDefinition = enrichedArtifact.blueprintVersion.fieldDefinitions.get(fieldId);
            Object fieldValue = fieldAudit.fieldValue = enrichedArtifact.artifact.fields.get(fieldId);
            HashSet<String> fieldResolvedArtifactIds = new HashSet<String>();
            if (fieldDefinition instanceof ReferenceFieldDefinition && fieldValue != null) {
                if (fieldValue instanceof List) {
                    for (Object valItem : (List)fieldValue) {
                        if (!(valItem instanceof String)) continue;
                        fieldResolvedArtifactIds.add((String)valItem);
                    }
                } else if (fieldValue instanceof String) {
                    fieldResolvedArtifactIds.add((String)fieldValue);
                }
            }
            fieldAudit.resolvedArtifactIds.addAll(fieldResolvedArtifactIds);
            resolvedArtifactIds.addAll(fieldResolvedArtifactIds);
        }
        return resolvedArtifactIds;
    }

    public static boolean doRuleCriteriaComply(RoleAssignmentsRule roleAssignmentsRule, BiPredicate<Criterion, RolesAndPermissionsAudit.CriterionAudit> criterionPredicate, RolesAndPermissionsAudit.RoleAssignmentRuleAudit roleAssignmentRuleAudit) {
        boolean ruleComplies = true;
        for (Criterion criterion : roleAssignmentsRule.criteria) {
            boolean criterionComplies;
            RolesAndPermissionsAudit.CriterionAudit criterionAudit = roleAssignmentRuleAudit.addCriterionAudit(criterion);
            criterionAudit.complies = criterionComplies = criterionPredicate.test(criterion, criterionAudit);
            if (criterionComplies) continue;
            ruleComplies = false;
            if (!roleAssignmentRuleAudit.auditConfiguration.shouldBreak()) continue;
            break;
        }
        return ruleComplies;
    }

    public static boolean doCriterionComplyAtBlueprintLevel(Criterion criterion, RolesAndPermissionsAudit.CriterionAudit criterionAudit) {
        if (criterion instanceof BlueprintVersionIdCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactExistingCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactExistingStatusCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactExistingFieldValueCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactDeletedCriterion) {
            return false;
        }
        logger.error((Object)("Criterion unknown : " + criterion.getClass().getSimpleName()));
        return false;
    }

    public static boolean doCriterionComplyAtBlueprintVersionLevel(Criterion criterion, EnrichedBlueprintVersion enrichedBlueprintVersion, RolesAndPermissionsAudit.CriterionAudit criterionAudit) {
        if (criterion instanceof BlueprintVersionIdCriterion) {
            criterionAudit.testedValue = enrichedBlueprintVersion.blueprintVersion.id.versionId;
            return StringUtils.equals((CharSequence)enrichedBlueprintVersion.blueprintVersion.id.versionId, (CharSequence)((BlueprintVersionIdCriterion)criterion).versionId);
        }
        if (criterion instanceof ArtifactExistingCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactExistingStatusCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactExistingFieldValueCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactDeletedCriterion) {
            return false;
        }
        logger.error((Object)("Criterion unknown : " + criterion.getClass().getSimpleName()));
        return false;
    }

    public static boolean doCriterionComplyAtExistingArtifactLevel(Criterion criterion, EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit.CriterionAudit criterionAudit) {
        if (criterion instanceof BlueprintVersionIdCriterion) {
            criterionAudit.testedValue = enrichedArtifact.blueprintVersion.id.versionId;
            return StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.versionId, (CharSequence)((BlueprintVersionIdCriterion)criterion).versionId);
        }
        if (criterion instanceof ArtifactExistingCriterion) {
            return true;
        }
        if (criterion instanceof ArtifactExistingStatusCriterion) {
            String currentOngoingWorkflowStepId = enrichedArtifact.getCurrentOngoingWorkflowStepId();
            criterionAudit.testedValue = currentOngoingWorkflowStepId;
            return StringUtils.equals((CharSequence)currentOngoingWorkflowStepId, (CharSequence)((ArtifactExistingStatusCriterion)criterion).stepId);
        }
        if (criterion instanceof ArtifactExistingFieldValueCriterion) {
            ArtifactExistingFieldValueCriterion artifactExistingFieldValueCriterion = (ArtifactExistingFieldValueCriterion)criterion;
            criterionAudit.testedValue = enrichedArtifact.artifact.fields.get(artifactExistingFieldValueCriterion.fieldId);
            return artifactExistingFieldValueCriterion.operator.predicate.doComply(artifactExistingFieldValueCriterion, enrichedArtifact);
        }
        if (criterion instanceof ArtifactDeletedCriterion) {
            return false;
        }
        logger.error((Object)("Criterion unknown : " + criterion.getClass().getSimpleName()));
        return false;
    }

    public static boolean doCriterionComplyAtArtifactDeletedLevel(Criterion criterion, BlueprintVersionId lastKnownBlueprintVersionId, RolesAndPermissionsAudit.CriterionAudit criterionAudit) {
        if (criterion instanceof BlueprintVersionIdCriterion) {
            criterionAudit.testedValue = lastKnownBlueprintVersionId.versionId;
            return StringUtils.equals((CharSequence)lastKnownBlueprintVersionId.versionId, (CharSequence)((BlueprintVersionIdCriterion)criterion).versionId);
        }
        if (criterion instanceof ArtifactExistingCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactExistingStatusCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactExistingFieldValueCriterion) {
            return false;
        }
        if (criterion instanceof ArtifactDeletedCriterion) {
            return true;
        }
        logger.error((Object)("Criterion unknown : " + criterion.getClass().getSimpleName()));
        return false;
    }
}

