/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.security.mappings;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.security.mappings.GroupMapping;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.security.mappings.IGroupMappingDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QGroupMappings;
import com.dataiku.gh.core.storage.sql.model.QGroupMappingsHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

@Repository
public class GroupMappingDAO
extends AbstractPostgreSQLClient
implements IGroupMappingDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.group-mapping");
    @Autowired
    protected IHistoryDataService historyDataService;

    @Override
    @GHMandatoryTransaction
    public List<GroupMapping> listAllGroupMappings() throws IOException {
        return this.listGroupMappingsInternal(true, Collections.emptyList());
    }

    @Override
    @GHMandatoryTransaction
    public List<GroupMapping> listGroupMappings(Collection<String> groupNames) throws IOException {
        return this.listGroupMappingsInternal(false, groupNames);
    }

    private List<GroupMapping> listGroupMappingsInternal(boolean listAll, Collection<String> groupNames) throws IOException {
        if (!listAll && CollectionUtils.isEmpty(groupNames)) {
            return Collections.emptyList();
        }
        SQLQuery query = (SQLQuery)this.sqlQueryFactory.select(QGroupMappings.groupMappings.groupMappingJson).from((Expression)QGroupMappings.groupMappings);
        if (!listAll) {
            query = (SQLQuery)query.where((Predicate)QGroupMappings.groupMappings.groupMappingGroupName.in(groupNames));
        }
        try {
            return this.querydslJdbcTemplate.query(query, (rs, rowNum) -> (GroupMapping)JSON.parse((String)rs.getString(ColumnMetadata.getName(QGroupMappings.groupMappings.groupMappingJson)), GroupMapping.class));
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @GHMandatoryTransaction
    public void createGroupMappings(Collection<GroupMapping> groupMappings) throws IOException {
        if (CollectionUtils.isEmpty(groupMappings)) {
            return;
        }
        try {
            SQLInsertClause insert = this.sqlQueryFactory.insert((RelationalPath)QGroupMappings.groupMappings);
            for (GroupMapping groupMapping : groupMappings) {
                ((SQLInsertClause)insert.set(QGroupMappings.groupMappings.groupMappingJson, QueryBuilderUtils.toJsonb(groupMapping))).addBatch();
            }
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insert);
            this.insertHistoryRevisions(RevisionType.ADD, groupMappings);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @GHMandatoryTransaction
    public void deleteGroupMappings(Collection<GroupMapping> groupMappings) throws IOException {
        if (CollectionUtils.isEmpty(groupMappings)) {
            return;
        }
        try {
            this.insertHistoryRevisions(RevisionType.DELETE, groupMappings);
            SQLDeleteClause delete = this.sqlQueryFactory.delete((RelationalPath)QGroupMappings.groupMappings);
            for (GroupMapping groupMapping : groupMappings) {
                ((SQLDeleteClause)delete.where((Predicate)QGroupMappings.groupMappings.groupMappingArtifactId.eq((Object)groupMapping.artifactId).and((Predicate)QGroupMappings.groupMappings.groupMappingGroupName.eq((Object)groupMapping.groupName)))).addBatch();
            }
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)delete);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private void insertHistoryRevisions(RevisionType revisionType, Collection<GroupMapping> groupMappings) throws IOException {
        SQLInsertClause insertHistory = this.sqlQueryFactory.insert((RelationalPath)QGroupMappingsHistory.groupMappingsHistory);
        for (GroupMapping groupMapping : groupMappings) {
            HistoryRevision historyRevision = this.historyDataService.createRevision(revisionType, EntityType.GROUP_MAPPING);
            ((SQLInsertClause)((SQLInsertClause)insertHistory.set(QGroupMappingsHistory.groupMappingsHistory._revisionJson, QueryBuilderUtils.toJsonb(historyRevision))).set(QGroupMappingsHistory.groupMappingsHistory.groupMappingJson, QueryBuilderUtils.toJsonb(groupMapping))).addBatch();
        }
        this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insertHistory);
    }
}

