/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.services.licensing;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.license.License;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.ClientProtocolException;
import com.dataiku.dss.shadelib.org.apache.http.client.HttpClient;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.conn.ClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.UsersDAO;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SAASInstanceService {
    @Autowired
    private UsersDAO usersDAO;
    HttpClient client;
    private static Logger logger = Logger.getLogger((String)"dss.ssaas");

    public SAASInstanceService() {
        DefaultHttpClient defaultClient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
        defaultClient.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        this.client = defaultClient;
    }

    public License getLicense() throws ClientProtocolException, IOException {
        String instanceId = ApplicationConfigurator.getMandatoryProperty((String)"saasInstanceId");
        String instanceSharedSecret = ApplicationConfigurator.getMandatoryProperty((String)"saasSharedSecret");
        String managerURL = ApplicationConfigurator.getMandatoryProperty((String)"saasManagerURL");
        HttpGet get = new HttpGet(managerURL + "/api/comm/saas/instance/get-license?instanceId=" + instanceId + "&sharedSecret=" + instanceSharedSecret);
        HttpResponse resp = this.client.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Getting license failed: " + new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent()), "utf8"));
        }
        return (License)JSON.parse((String)new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent())), License.class);
    }

    public UserAccessSummary getAccess(String accessToken) throws ClientProtocolException, IOException {
        if (accessToken == null) {
            return new UserAccessSummary();
        }
        String instanceId = ApplicationConfigurator.getMandatoryProperty((String)"saasInstanceId");
        String instanceSharedSecret = ApplicationConfigurator.getMandatoryProperty((String)"saasSharedSecret");
        String managerURL = ApplicationConfigurator.getMandatoryProperty((String)"saasManagerURL");
        HttpGet get = new HttpGet(managerURL + "/api/saas/instance/get-access?instanceId=" + instanceId + "&sharedSecret=" + instanceSharedSecret + "&userAccessToken=" + accessToken);
        HttpResponse resp = this.client.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Getting auth failed: " + new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent()), "utf8"));
        }
        return (UserAccessSummary)JSON.parse((String)new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent())), UserAccessSummary.class);
    }

    public void syncUsersList() throws IOException, CodedException {
        String instanceId = ApplicationConfigurator.getMandatoryProperty((String)"saasInstanceId");
        String instanceSharedSecret = ApplicationConfigurator.getMandatoryProperty((String)"saasSharedSecret");
        String managerURL = ApplicationConfigurator.getMandatoryProperty((String)"saasManagerURL");
        HttpGet get = new HttpGet(managerURL + "/api/saas/instance/get-all-users?instanceId=" + instanceId + "&sharedSecret=" + instanceSharedSecret);
        HttpResponse resp = this.client.execute((HttpUriRequest)get);
        if (resp.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Getting auth failed: " + new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent()), "utf8"));
        }
        UserAccessDetailsList list = (UserAccessDetailsList)JSON.parse((String)new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent())), UserAccessDetailsList.class);
        this.syncUsersList(list.items);
    }

    private void syncUsersList(List<UserAccessDetails> newUsers) throws IOException, CodedException {
        HashMap<String, UsersDAO.User> existingUsers = new HashMap<String, UsersDAO.User>();
        for (UsersDAO.User u : this.usersDAO.listUsers()) {
            existingUsers.put(u.login, u);
        }
        HashSet<String> newUsersLogins = new HashSet<String>();
        for (UserAccessDetails pu : newUsers) {
            newUsersLogins.add(pu.login);
            UsersDAO.User existingUser = (UsersDAO.User)existingUsers.get(pu.login);
            if (existingUser == null) {
                logger.info((Object)("Sync adding user " + pu.login));
                UsersDAO.User u = new UsersDAO.User(pu.login, UserSourceType.SAAS);
                u.displayName = pu.displayName;
                u.groups = null;
                u.userProfile = "DATA_SCIENTIST";
                this.usersDAO.addForeignUser(u);
                continue;
            }
            existingUser.displayName = pu.displayName;
            this.usersDAO.saveUser(existingUser);
        }
        for (String deletedUser : Sets.difference(existingUsers.keySet(), newUsersLogins)) {
            logger.info((Object)("Sync deleting user " + deletedUser));
            this.usersDAO.deleteUser(deletedUser);
        }
    }

    public static class UserAccessSummary {
        public boolean loggedIn;
        public boolean hasAccess;
        public String login;
        public boolean instanceOwner;
        public String accessToken;
        public String xsrfTokenSalt;
    }

    public static class UserAccessDetailsList {
        public List<UserAccessDetails> items;
    }

    public static class UserAccessDetails {
        public String login;
        public String displayName;
    }
}

