/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.monitoring;

import com.codahale.metrics.Meter;
import com.dataiku.dip.apideployer.monitoring.ActivityMetric;
import com.dataiku.dip.apideployer.monitoring.SystemMetric;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.OperatingSystemInformation;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.lambda.APINodeMetrics;
import com.dataiku.lambda.StdLambdaContext;
import com.dataiku.lambda.model.serverconfig.ActivityMonitoringSettings;
import com.dataiku.lambda.model.serverconfig.GenerationsMapping;
import com.dataiku.lambda.model.serverconfig.LambdaServerConfig;
import com.dataiku.lambda.monitoring.SendActivityTask;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityMonitoringService {
    private final ServicesService servicesService;
    private final StdLambdaContext context;
    private final OperatingSystemInformation operatingSystemInformation;
    private final Scheduler metricsScheduler;
    private final Map<String, LastCount> lastCounts = new HashMap<String, LastCount>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.monitoring");

    public ActivityMonitoringService(@Autowired ServicesService servicesService, @Autowired StdLambdaContext stdLambdaContext, @Autowired OperatingSystemInformation operatingSystemInformation) throws SchedulerException {
        this.servicesService = servicesService;
        this.context = stdLambdaContext;
        this.operatingSystemInformation = operatingSystemInformation;
        this.metricsScheduler = StdSchedulerFactory.getDefaultScheduler();
        logger.info((Object)"Initialization of Activity metrics scheduler");
        this.metricsScheduler.start();
    }

    public void scheduleSendActivityIfNeeded(int frequencyInMinutes) throws IOException {
        LambdaServerConfig lsc = this.context.getMandatoryConfig();
        if (!(lsc.activityMonitoringSettings instanceof ActivityMonitoringSettings.Push)) {
            logger.infoV("NOT scheduling sending api activity metrics.", new Object[0]);
            return;
        }
        logger.infoV("Scheduling sending api activity metrics with %s minutes frequency", new Object[]{frequencyInMinutes});
        JobDetail job = JobBuilder.newJob(SendActivityTask.class).withIdentity("dku.SendActivity-job").build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("dku.SendActivity-trigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)String.format("0 */%s * * * ?", frequencyInMinutes)).withMisfireHandlingInstructionFireAndProceed()).build();
        try {
            this.metricsScheduler.clear();
            this.metricsScheduler.scheduleJob(job, trigger);
            logger.info((Object)("Scheduled task successfully added : " + job.getKey().toString()));
        }
        catch (SchedulerException e) {
            logger.error((Object)"Error scheduling the sending of activity metrics. No metrics will be sent automatically.", (Throwable)e);
        }
    }

    public String getActivityMetricsInGraphiteRawFormat() {
        ArrayList<String> metrics = new ArrayList<String>();
        List<String> serviceIds = this.servicesService.listActiveServiceIds();
        logger.debug((Object)("Start getting activity metrics for services: [" + String.join((CharSequence)" ,", serviceIds) + "]"));
        for (String serviceId : serviceIds) {
            Set<String> endpointIds;
            String deploymentId;
            try {
                deploymentId = this.getDeploymentId(serviceId);
            }
            catch (IllegalStateException ise) {
                logger.errorV("%s Won't send activity metrics for it.", new Object[]{ise.getMessage()});
                continue;
            }
            if (deploymentId == null) {
                logger.debugV("No deployment found for service %s, won't send activity metrics for it.", new Object[]{serviceId});
                continue;
            }
            try {
                endpointIds = this.getEndpointIds(serviceId);
            }
            catch (IOException | IllegalArgumentException e) {
                logger.errorV((Throwable)e, "Can't determine endpoints for service %s", new Object[]{serviceId});
                continue;
            }
            for (String endpointId : endpointIds) {
                long now = System.currentTimeMillis();
                HashMap<String, Double> rateByMetricName = new HashMap<String, Double>();
                List<String> metricNames = Arrays.asList("requests", "successRequests");
                for (String metricName : metricNames) {
                    String fullMetricId = ActivityMonitoringService.getActivityMetricId(deploymentId, endpointId, metricName);
                    Meter meter = APINodeMetrics.endpointMeter(serviceId, endpointId, metricName);
                    LastCount lastCount = this.lastCounts.computeIfAbsent(fullMetricId, k -> new LastCount());
                    long currentCount = meter.getCount();
                    double currentRate = (double)(currentCount - lastCount.count) / (double)(now - lastCount.timestamp) * 1000.0;
                    lastCount.timestamp = now;
                    lastCount.count = currentCount;
                    rateByMetricName.put(metricName, currentRate);
                }
                double allRequestsRate = (Double)rateByMetricName.get("requests");
                double errorRequestsRate = allRequestsRate - (Double)rateByMetricName.get("successRequests");
                double avgProcessingTimeInMs = APINodeMetrics.endpointTimer(serviceId, endpointId, "totalProcessing").getSnapshot().getMean() / 1000000.0;
                double p95ProcessingTimeInMs = APINodeMetrics.endpointTimer(serviceId, endpointId, "totalProcessing").getSnapshot().get95thPercentile() / 1000000.0;
                long time = now / 1000L;
                metrics.add(ActivityMonitoringService.composeGraphiteLine(ActivityMonitoringService.getActivityMetricId(deploymentId, endpointId, ActivityMetric.Type.ALL_REQUESTS_IN_COUNT_PER_S.getRrdFieldName()), allRequestsRate, time));
                metrics.add(ActivityMonitoringService.composeGraphiteLine(ActivityMonitoringService.getActivityMetricId(deploymentId, endpointId, ActivityMetric.Type.ERROR_REQUESTS_IN_COUNT_PER_S.getRrdFieldName()), errorRequestsRate, time));
                if (allRequestsRate == 0.0) continue;
                metrics.add(ActivityMonitoringService.composeGraphiteLine(ActivityMonitoringService.getActivityMetricId(deploymentId, endpointId, ActivityMetric.Type.AVG_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName()), avgProcessingTimeInMs, time));
                metrics.add(ActivityMonitoringService.composeGraphiteLine(ActivityMonitoringService.getActivityMetricId(deploymentId, endpointId, ActivityMetric.Type.P95_PROCESSING_TIME_IN_MS_PER_REQUEST.getRrdFieldName()), p95ProcessingTimeInMs, time));
            }
            logger.traceV("Prepared activity metrics for service: %s, deployment: %s and endpoints: [%s]", new Object[]{serviceId, deploymentId, String.join((CharSequence)", ", endpointIds)});
        }
        logger.debugV("Finished getting activity metrics, got %s metrics", new Object[]{metrics.size()});
        return String.join((CharSequence)"\n", metrics);
    }

    @Nullable
    public String getSystemMetricsInGraphiteRawFormat() {
        List<String> serviceIds = this.servicesService.listActiveServiceIds();
        logger.debugV("Start getting system metrics for services: [%s]", new Object[]{String.join((CharSequence)" ,", serviceIds)});
        ArrayList<String> metrics = new ArrayList<String>();
        for (String serviceId : serviceIds) {
            String deploymentId;
            try {
                deploymentId = this.getDeploymentId(serviceId);
            }
            catch (IllegalStateException ise) {
                logger.errorV("%s Won't send system metrics for it.", new Object[]{ise.getMessage()});
                continue;
            }
            if (deploymentId == null) {
                logger.debugV("No deployment found for service %s, won't send system metrics for it.", new Object[]{serviceId});
                continue;
            }
            long nowSeconds = DateTime.now().getMillis() / 1000L;
            metrics.addAll(this.getDeploymentSystemMetricsInGraphiteRawFormat(deploymentId, nowSeconds));
            logger.traceV("Prepared system metrics for service: %s, deployment: %s", new Object[]{serviceId, deploymentId});
        }
        logger.debugV("Finished getting system metrics, got %s metrics", new Object[]{metrics.size()});
        if (metrics.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)System.lineSeparator(), metrics);
    }

    @VisibleForTesting
    List<String> getDeploymentSystemMetricsInGraphiteRawFormat(String deploymentId, long nowSeconds) {
        double memoryCapacityInMB = ActivityMonitoringService.bytesToMegabytes(this.operatingSystemInformation.getTotalMemoryInBytes());
        Long availableMemoryInKilobytes = this.operatingSystemInformation.getAvailableMemoryInKilobytes();
        double availableMemoryInMB = availableMemoryInKilobytes == null ? Double.NaN : ActivityMonitoringService.kilobytesToMegabytes(availableMemoryInKilobytes);
        double memoryUsageInMB = memoryCapacityInMB - availableMemoryInMB;
        int cpuCapacityInMillicores = this.operatingSystemInformation.getAvailableProcessors() * 1000;
        double cpuLoad = this.operatingSystemInformation.getSystemCpuLoad();
        double cpuUsageInMillicores = cpuLoad < 0.0 ? Double.NaN : cpuLoad * (double)cpuCapacityInMillicores;
        return List.of(ActivityMonitoringService.composeGraphiteLine(ActivityMonitoringService.getSystemMetricId(deploymentId, SystemMetric.Type.MEMORY_CAPACITY_IN_MEGABYTES.getRrdFieldName()), memoryCapacityInMB, nowSeconds), ActivityMonitoringService.composeGraphiteLine(ActivityMonitoringService.getSystemMetricId(deploymentId, SystemMetric.Type.MEMORY_USAGE_ABSOLUTE_IN_MEGABYTES.getRrdFieldName()), memoryUsageInMB, nowSeconds), ActivityMonitoringService.composeGraphiteLine(ActivityMonitoringService.getSystemMetricId(deploymentId, SystemMetric.Type.CPU_CAPACITY_IN_MILLICORES.getRrdFieldName()), cpuCapacityInMillicores, nowSeconds), ActivityMonitoringService.composeGraphiteLine(ActivityMonitoringService.getSystemMetricId(deploymentId, SystemMetric.Type.CPU_USAGE_ABSOLUTE_IN_MILLICORES.getRrdFieldName()), cpuUsageInMillicores, nowSeconds));
    }

    @VisibleForTesting
    static String composeGraphiteLine(@Nonnull String metricId, double metricValue, long timestampInSeconds) {
        return String.format("%s %s %s", metricId, metricValue, timestampInSeconds);
    }

    @VisibleForTesting
    static String getActivityMetricId(@Nonnull String deploymentId, @Nonnull String endpointId, @Nonnull String metricName) {
        return String.format("%s.%s.%s", deploymentId, endpointId, metricName);
    }

    @VisibleForTesting
    static String getSystemMetricId(@Nonnull String deploymentId, @Nonnull String metricName) {
        return String.format("%s.%s", deploymentId, metricName);
    }

    @VisibleForTesting
    static double bytesToMegabytes(long bytes) {
        return (double)bytes / 1048576.0;
    }

    @VisibleForTesting
    static double kilobytesToMegabytes(long kilobytes) {
        return (double)kilobytes / 1024.0;
    }

    @VisibleForTesting
    String getDeploymentId(String serviceId) {
        ServiceManager sm = this.servicesService.getServiceManager(serviceId);
        GenerationsMapping mapping = sm.getCurrentGenerationsMapping();
        if (mapping == null) {
            throw ErrorContext.isef((String)"Can't find generation mappings for service service: %s", (Object)serviceId, (Object[])new Object[0]);
        }
        JsonObject auditMetadata = mapping.auditMetadata;
        if (auditMetadata == null || !auditMetadata.has("apiDeployerDeployment")) {
            throw ErrorContext.isef((String)"Can't read auditMetadata for service %s, and so can't get its deployment id.", (Object)serviceId, (Object[])new Object[0]);
        }
        JsonObject apiDeployerDeployment = auditMetadata.getAsJsonObject("apiDeployerDeployment");
        if (!apiDeployerDeployment.has("deploymentId")) {
            return null;
        }
        return apiDeployerDeployment.getAsJsonPrimitive("deploymentId").getAsString();
    }

    private Set<String> getEndpointIds(String serviceId) throws IOException {
        ServiceManager sm = this.servicesService.getServiceManager(serviceId);
        return this.servicesService.getGenerations(serviceId).stream().filter(g -> g.mounted).flatMap(g -> sm.getConfig((String)g.generationId).endpoints.stream()).map(e -> e.id).collect(Collectors.toSet());
    }

    public void cancelSchedule() {
        try {
            this.metricsScheduler.clear();
        }
        catch (SchedulerException e) {
            logger.error((Object)"Could not cancel the scheduling sending of activity metrics.", (Throwable)e);
        }
    }

    private static class LastCount {
        long timestamp;
        long count;

        private LastCount() {
        }
    }
}

