/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateCustomerGatewayRequestMarshaller
implements Marshaller<Request<CreateCustomerGatewayRequest>, CreateCustomerGatewayRequest> {
    @Override
    public Request<CreateCustomerGatewayRequest> marshall(CreateCustomerGatewayRequest createCustomerGatewayRequest) {
        SdkInternalList createCustomerGatewayRequestTagSpecificationsList;
        if (createCustomerGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateCustomerGatewayRequest> request = new DefaultRequest<CreateCustomerGatewayRequest>(createCustomerGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "CreateCustomerGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCustomerGatewayRequest.getBgpAsn() != null) {
            request.addParameter("BgpAsn", StringUtils.fromInteger(createCustomerGatewayRequest.getBgpAsn()));
        }
        if (createCustomerGatewayRequest.getPublicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString(createCustomerGatewayRequest.getPublicIp()));
        }
        if (createCustomerGatewayRequest.getCertificateArn() != null) {
            request.addParameter("CertificateArn", StringUtils.fromString(createCustomerGatewayRequest.getCertificateArn()));
        }
        if (createCustomerGatewayRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString(createCustomerGatewayRequest.getType()));
        }
        if (!(createCustomerGatewayRequestTagSpecificationsList = (SdkInternalList)createCustomerGatewayRequest.getTagSpecifications()).isEmpty() || !createCustomerGatewayRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createCustomerGatewayRequestTagSpecificationsListValue : createCustomerGatewayRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createCustomerGatewayRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createCustomerGatewayRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createCustomerGatewayRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createCustomerGatewayRequest.getDeviceName() != null) {
            request.addParameter("DeviceName", StringUtils.fromString(createCustomerGatewayRequest.getDeviceName()));
        }
        if (createCustomerGatewayRequest.getIpAddress() != null) {
            request.addParameter("IpAddress", StringUtils.fromString(createCustomerGatewayRequest.getIpAddress()));
        }
        if (createCustomerGatewayRequest.getBgpAsnExtended() != null) {
            request.addParameter("BgpAsnExtended", StringUtils.fromLong(createCustomerGatewayRequest.getBgpAsnExtended()));
        }
        return request;
    }
}

